/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection.v1_21_R1;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManagerAbstract;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.CraftArt;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftSound;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftCat;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ReflectionManager
implements ReflectionManagerAbstract {
    private Field dataItemsField;
    private final Field trackedEntityField;
    private final AtomicInteger entityCounter;
    private final Method entityDefaultSoundMethod;

    public ReflectionManager() {
        for (Field f : SynchedEntityData.class.getDeclaredFields()) {
            if (!f.getType().isArray()) continue;
            f.setAccessible(true);
            this.dataItemsField = f;
        }
        Field entityCounter = net.minecraft.world.entity.Entity.class.getDeclaredField("c");
        entityCounter.setAccessible(true);
        this.entityCounter = (AtomicInteger)entityCounter.get(null);
        this.trackedEntityField = ChunkMap.TrackedEntity.class.getDeclaredField("b");
        this.trackedEntityField.setAccessible(true);
        this.entityDefaultSoundMethod = LivingEntity.class.getDeclaredMethod("fa", new Class[0]);
        this.entityDefaultSoundMethod.setAccessible(true);
    }

    public boolean hasInvul(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (nmsEntity instanceof LivingEntity) {
            return nmsEntity.invulnerableTime > 0;
        }
        return nmsEntity.isInvulnerableTo(nmsEntity.damageSources().generic());
    }

    public int getIncrementedStateId(Player player) {
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        return serverPlayer.containerMenu.incrementStateId();
    }

    public int getNewEntityId() {
        return this.getNewEntityId(true);
    }

    public int getNewEntityId(boolean increment) {
        if (increment) {
            return this.entityCounter.incrementAndGet();
        }
        return this.entityCounter.get();
    }

    public ServerGamePacketListenerImpl getPlayerConnectionOrPlayer(Player player) {
        return ((CraftPlayer)player).getHandle().connection;
    }

    public net.minecraft.world.entity.Entity createEntityInstance(String entityName) {
        net.minecraft.world.entity.Entity entity;
        Optional optional = net.minecraft.world.entity.EntityType.byString((String)entityName.toLowerCase(Locale.ENGLISH));
        if (!optional.isPresent()) {
            return null;
        }
        net.minecraft.world.entity.EntityType entityType = (net.minecraft.world.entity.EntityType)optional.get();
        ServerLevel world = this.getWorldServer((World)Bukkit.getWorlds().get(0));
        if (entityType == net.minecraft.world.entity.EntityType.PLAYER) {
            GameProfile gameProfile = new GameProfile(new UUID(0L, 0L), "Steve");
            ClientInformation information = new ClientInformation("english", 10, ChatVisiblity.FULL, true, 0, HumanoidArm.RIGHT, true, true);
            entity = new ServerPlayer((MinecraftServer)this.getMinecraftServer(), world, gameProfile, information);
        } else {
            entity = entityType.create((Level)world);
        }
        if (entity == null) {
            return null;
        }
        entity.setPos(1.0, 1.0, 1.0);
        entity.setPos(0.0, 0.0, 0.0);
        return entity;
    }

    public AABB getBoundingBox(Entity entity) {
        return ((CraftEntity)entity).getHandle().getBoundingBox();
    }

    public double getXBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).maxX - this.getBoundingBox((Entity)entity).minX;
    }

    public double getYBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).maxY - this.getBoundingBox((Entity)entity).minY;
    }

    public double getZBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).maxZ - this.getBoundingBox((Entity)entity).minZ;
    }

    public ServerPlayer getPlayerFromPlayerConnection(Object nmsEntity) {
        return ((ServerPlayerConnection)nmsEntity).getPlayer();
    }

    public Entity getBukkitEntity(Object nmsEntity) {
        return ((net.minecraft.world.entity.Entity)nmsEntity).getBukkitEntity();
    }

    public ItemStack getBukkitItem(Object nmsItem) {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)nmsItem));
    }

    public ItemStack getCraftItem(ItemStack bukkitItem) {
        return CraftItemStack.asCraftCopy((ItemStack)bukkitItem);
    }

    public ServerEntity getEntityTrackerEntry(Entity target) throws Exception {
        ServerLevel world = ((CraftWorld)target.getWorld()).getHandle();
        ServerChunkCache chunkSource = world.getChunkSource();
        ChunkMap chunkMap = chunkSource.chunkMap;
        Int2ObjectMap entityMap = chunkMap.entityMap;
        ChunkMap.TrackedEntity trackedEntity = (ChunkMap.TrackedEntity)entityMap.get(target.getEntityId());
        if (trackedEntity == null) {
            return null;
        }
        return (ServerEntity)this.trackedEntityField.get(trackedEntity);
    }

    public DedicatedServer getMinecraftServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    public Object getNmsEntity(Entity entity) {
        return ((CraftEntity)entity).getHandle();
    }

    public double getPing(Player player) {
        return player.getPing();
    }

    public float[] getSize(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        EntityDimensions dimensions = nmsEntity.getDimensions(Pose.STANDING);
        return new float[]{dimensions.width(), nmsEntity.getEyeHeight()};
    }

    public MinecraftSessionService getMinecraftSessionService() {
        return this.getMinecraftServer().getSessionService();
    }

    public Float getSoundModifier(Object entity) {
        if (!(entity instanceof LivingEntity)) {
            return Float.valueOf(0.0f);
        }
        try {
            return (Float)this.entityDefaultSoundMethod.invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    public void injectCallback(String playername, ProfileLookupCallback callback) {
        this.getMinecraftServer().getProfileRepository().findProfilesByNames(new String[]{playername}, callback);
    }

    public void setBoundingBox(Entity entity, double x, double y, double z) {
        Location loc = entity.getLocation();
        ((CraftEntity)entity).getHandle().setBoundingBox(new AABB(loc.getX() - x / 2.0, loc.getY() - y / 2.0, loc.getZ() - z / 2.0, loc.getX() + x / 2.0, loc.getY() + y / 2.0, loc.getZ() + z / 2.0));
    }

    public String getSoundString(Sound sound) {
        return CraftSound.bukkitToMinecraft((Sound)sound).getLocation().toString();
    }

    public Material getMaterial(String name) {
        return CraftMagicNumbers.INSTANCE.getMaterial(name, CraftMagicNumbers.INSTANCE.getDataVersion());
    }

    public String getItemName(Material material) {
        return BuiltInRegistries.ITEM.getKey((Object)CraftMagicNumbers.getItem((Material)material)).getPath();
    }

    public ResourceLocation createMinecraftKey(String name) {
        return ResourceLocation.withDefaultNamespace((String)name);
    }

    public net.minecraft.world.entity.EntityType getEntityType(EntityType entityType) {
        return net.minecraft.world.entity.EntityType.byString((String)(entityType.getName() == null ? entityType.name().toLowerCase(Locale.ENGLISH) : entityType.getName())).orElse(null);
    }

    public Object registerEntityType(NamespacedKey key) {
        net.minecraft.world.entity.EntityType newEntity = new net.minecraft.world.entity.EntityType(null, null, false, false, false, false, null, null, 0.0f, 0, 0, FeatureFlagSet.of());
        Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (ResourceLocation)CraftNamespacedKey.toMinecraft((NamespacedKey)key), (Object)newEntity);
        newEntity.getDescriptionId();
        return newEntity;
    }

    public int getEntityTypeId(Object entityTypes) {
        net.minecraft.world.entity.EntityType entityType = (net.minecraft.world.entity.EntityType)entityTypes;
        return BuiltInRegistries.ENTITY_TYPE.getIdOrThrow((Object)entityType);
    }

    public int getEntityTypeId(EntityType entityType) {
        return this.getEntityTypeId(this.getEntityType(entityType));
    }

    public Object getEntityType(NamespacedKey name) {
        return BuiltInRegistries.ENTITY_TYPE.get(CraftNamespacedKey.toMinecraft((NamespacedKey)name));
    }

    public int getCombinedIdByBlockData(BlockData data) {
        BlockState state = ((CraftBlockData)data).getState();
        return Block.getId((BlockState)state);
    }

    public int getCombinedIdByItemStack(ItemStack itemStack) {
        Block block = CraftMagicNumbers.getBlock((Material)itemStack.getType());
        return Block.getId((BlockState)block.defaultBlockState());
    }

    public BlockData getBlockDataByCombinedId(int id) {
        return CraftBlockData.fromData((BlockState)Block.stateById((int)id));
    }

    public ItemStack getItemStackByCombinedId(int id) {
        return new ItemStack(CraftMagicNumbers.getMaterial((Block)Block.stateById((int)id).getBlock()));
    }

    public ServerLevel getWorldServer(World w) {
        return ((CraftWorld)w).getHandle();
    }

    public ItemMeta getDeserializedItemMeta(Map<String, Object> meta) {
        try {
            return SerializableMeta.deserialize(meta);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public ByteBuf getDataWatcherValues(Entity entity) {
        SynchedEntityData watcher = ((CraftEntity)entity).getHandle().getEntityData();
        SynchedEntityData.DataItem[] dataItems = (SynchedEntityData.DataItem[])this.dataItemsField.get(watcher);
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.buffer();
        RegistryFriendlyByteBuf serializer = (RegistryFriendlyByteBuf)RegistryFriendlyByteBuf.decorator((RegistryAccess)this.getMinecraftServer().registryAccess()).apply(buf);
        for (SynchedEntityData.DataItem dataItem : dataItems) {
            dataItem.value().write(serializer);
        }
        serializer.writeByte(255);
        return buf;
    }

    public GameProfile getMCGameProfile(Player player) {
        return ((CraftPlayer)player).getProfile();
    }

    public Cat.Type getCatTypeFromInt(int catType) {
        Registry registry = MinecraftServer.getDefaultRegistryAccess().registryOrThrow(Registries.CAT_VARIANT);
        return CraftCat.CraftType.minecraftHolderToBukkit((Holder)((Holder)registry.getHolder(catType).get()));
    }

    public int getCatVariantAsInt(Cat.Type type) {
        Registry registry = MinecraftServer.getDefaultRegistryAccess().registryOrThrow(Registries.CAT_VARIANT);
        return registry.getIdOrThrow((Object)CraftCat.CraftType.bukkitToMinecraft((Cat.Type)type));
    }

    public Frog.Variant getFrogVariantFromInt(int frogType) {
        Registry registry = MinecraftServer.getDefaultRegistryAccess().registryOrThrow(Registries.FROG_VARIANT);
        return CraftFrog.CraftVariant.minecraftHolderToBukkit((Holder)((Holder)registry.getHolder(frogType).get()));
    }

    public int getFrogVariantAsInt(Frog.Variant type) {
        Registry registry = MinecraftServer.getDefaultRegistryAccess().registryOrThrow(Registries.FROG_VARIANT);
        return registry.getIdOrThrow((Object)CraftFrog.CraftVariant.bukkitToMinecraft((Frog.Variant)type));
    }

    public Art getPaintingFromInt(int paintingId) {
        Registry registry = MinecraftServer.getDefaultRegistryAccess().registryOrThrow(Registries.PAINTING_VARIANT);
        return CraftArt.minecraftHolderToBukkit((Holder)((Holder)registry.getHolder(paintingId - 1).get()));
    }

    public int getPaintingAsInt(Art type) {
        Registry registry = MinecraftServer.getDefaultRegistryAccess().registryOrThrow(Registries.PAINTING_VARIANT);
        return registry.getIdOrThrow((Object)CraftArt.bukkitToMinecraft((Art)type)) + 1;
    }

    public Wolf.Variant getWolfVariantFromInt(int wolfVariant) {
        Registry registry = MinecraftServer.getDefaultRegistryAccess().registryOrThrow(Registries.WOLF_VARIANT);
        return CraftWolf.CraftVariant.minecraftHolderToBukkit((Holder)((Holder)registry.getHolder(wolfVariant - 1).get()));
    }

    public int getWolfVariantAsInt(Wolf.Variant type) {
        Registry registry = MinecraftServer.getDefaultRegistryAccess().registryOrThrow(Registries.WOLF_VARIANT);
        return registry.getIdOrThrow((Object)CraftWolf.CraftVariant.bukkitToMinecraft((Wolf.Variant)type)) + 1;
    }

    public Object serializeComponents(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        net.minecraft.world.item.ItemStack item = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        DataComponentPatch comps = item.getComponentsPatch();
        if (comps == null) {
            return null;
        }
        DataResult cond = DataComponentPatch.CODEC.encodeStart((DynamicOps)JavaOps.INSTANCE, (Object)comps);
        return cond.result().orElse(null);
    }
}

