/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection.v1_20_R2;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManagerAbstract;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R2.CraftArt;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.CraftSound;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftCat;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ReflectionManager
implements ReflectionManagerAbstract {
    private Field dataItemsField;

    public ReflectionManager() {
        for (Field f : DataWatcher.class.getDeclaredFields()) {
            if (!f.getType().isArray()) continue;
            f.setAccessible(true);
            this.dataItemsField = f;
        }
    }

    public boolean hasInvul(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (nmsEntity instanceof EntityLiving) {
            return nmsEntity.al > 0;
        }
        return nmsEntity.b(nmsEntity.dM().n());
    }

    public int getIncrementedStateId(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        return serverPlayer.bS.k();
    }

    public int getNewEntityId() {
        return this.getNewEntityId(true);
    }

    public int getNewEntityId(boolean increment) {
        try {
            Field entityCounter = net.minecraft.world.entity.Entity.class.getDeclaredField("d");
            entityCounter.setAccessible(true);
            AtomicInteger atomicInteger = (AtomicInteger)entityCounter.get(null);
            if (increment) {
                return atomicInteger.incrementAndGet();
            }
            return atomicInteger.get();
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public PlayerConnection getPlayerConnectionOrPlayer(Player player) {
        return ((CraftPlayer)player).getHandle().c;
    }

    public net.minecraft.world.entity.Entity createEntityInstance(String entityName) {
        Optional optional = EntityTypes.a((String)entityName.toLowerCase(Locale.ENGLISH));
        if (optional.isPresent()) {
            net.minecraft.world.entity.Entity entity;
            EntityTypes entityType = (EntityTypes)optional.get();
            WorldServer world = this.getWorldServer((org.bukkit.World)Bukkit.getWorlds().get(0));
            if (entityType == EntityTypes.bt) {
                GameProfile gameProfile = new GameProfile(new UUID(0L, 0L), "Steve");
                ClientInformation information = new ClientInformation("english", 10, EnumChatVisibility.a, true, 0, EnumMainHand.b, true, true);
                entity = new EntityPlayer((MinecraftServer)this.getMinecraftServer(), world, gameProfile, information);
            } else {
                entity = entityType.a((World)world);
            }
            if (entity == null) {
                return null;
            }
            entity.e(1.0, 1.0, 1.0);
            entity.e(0.0, 0.0, 0.0);
            return entity;
        }
        return null;
    }

    public AxisAlignedBB getBoundingBox(Entity entity) {
        return ((CraftEntity)entity).getHandle().cG();
    }

    public double getXBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).d - this.getBoundingBox((Entity)entity).a;
    }

    public double getYBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).e - this.getBoundingBox((Entity)entity).b;
    }

    public double getZBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).f - this.getBoundingBox((Entity)entity).c;
    }

    public EntityPlayer getPlayerFromPlayerConnection(Object nmsEntity) {
        return ((ServerPlayerConnection)nmsEntity).p();
    }

    public Entity getBukkitEntity(Object nmsEntity) {
        return ((net.minecraft.world.entity.Entity)nmsEntity).getBukkitEntity();
    }

    public ItemStack getBukkitItem(Object nmsItem) {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)nmsItem));
    }

    public ItemStack getCraftItem(ItemStack bukkitItem) {
        return CraftItemStack.asCraftCopy((ItemStack)bukkitItem);
    }

    public EntityTrackerEntry getEntityTrackerEntry(Entity target) throws Exception {
        WorldServer world = ((CraftWorld)target.getWorld()).getHandle();
        ChunkProviderServer chunkSource = world.k();
        PlayerChunkMap chunkMap = chunkSource.a;
        Int2ObjectMap entityMap = chunkMap.K;
        PlayerChunkMap.EntityTracker trackedEntity = (PlayerChunkMap.EntityTracker)entityMap.get(target.getEntityId());
        if (trackedEntity == null) {
            return null;
        }
        Field field = PlayerChunkMap.EntityTracker.class.getDeclaredField("b");
        field.setAccessible(true);
        return (EntityTrackerEntry)field.get(trackedEntity);
    }

    public DedicatedServer getMinecraftServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    public Object getNmsEntity(Entity entity) {
        return ((CraftEntity)entity).getHandle();
    }

    public double getPing(Player player) {
        return player.getPing();
    }

    public float[] getSize(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        EntitySize dimensions = nmsEntity.a(EntityPose.a);
        return new float[]{dimensions.a, nmsEntity.cH()};
    }

    public MinecraftSessionService getMinecraftSessionService() {
        return this.getMinecraftServer().am();
    }

    public Float getSoundModifier(Object entity) {
        if (!(entity instanceof EntityLiving)) {
            return Float.valueOf(0.0f);
        }
        try {
            Method method = EntityLiving.class.getDeclaredMethod("eV", new Class[0]);
            method.setAccessible(true);
            return (Float)method.invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    public void injectCallback(String playername, ProfileLookupCallback callback) {
        this.getMinecraftServer().ao().findProfilesByNames(new String[]{playername}, callback);
    }

    public void setBoundingBox(Entity entity, double x, double y, double z) {
        Location loc = entity.getLocation();
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(loc.getX() - x / 2.0, loc.getY() - y / 2.0, loc.getZ() - z / 2.0, loc.getX() + x / 2.0, loc.getY() + y / 2.0, loc.getZ() + z / 2.0));
    }

    public String getSoundString(Sound sound) {
        return CraftSound.bukkitToMinecraft((Sound)sound).a().toString();
    }

    public Material getMaterial(String name) {
        return CraftMagicNumbers.INSTANCE.getMaterial(name, CraftMagicNumbers.INSTANCE.getDataVersion());
    }

    public String getItemName(Material material) {
        return BuiltInRegistries.i.b((Object)CraftMagicNumbers.getItem((Material)material)).a();
    }

    public MinecraftKey createMinecraftKey(String name) {
        return new MinecraftKey(name);
    }

    public EntityTypes getEntityType(EntityType entityType) {
        return EntityTypes.a((String)(entityType.getName() == null ? entityType.name().toLowerCase(Locale.ENGLISH) : entityType.getName())).orElse(null);
    }

    public Object registerEntityType(NamespacedKey key) {
        EntityTypes newEntity = new EntityTypes(null, null, false, false, false, false, null, null, 0, 0, FeatureFlagSet.a());
        IRegistry.a((IRegistry)BuiltInRegistries.h, (MinecraftKey)CraftNamespacedKey.toMinecraft((NamespacedKey)key), (Object)newEntity);
        newEntity.g();
        return newEntity;
    }

    public int getEntityTypeId(Object entityTypes) {
        EntityTypes entityType = (EntityTypes)entityTypes;
        return BuiltInRegistries.h.a((Object)entityType);
    }

    public int getEntityTypeId(EntityType entityType) {
        return this.getEntityTypeId(this.getEntityType(entityType));
    }

    public Object getEntityType(NamespacedKey name) {
        return BuiltInRegistries.h.a(CraftNamespacedKey.toMinecraft((NamespacedKey)name));
    }

    public int getCombinedIdByBlockData(BlockData data) {
        IBlockData state = ((CraftBlockData)data).getState();
        return Block.i((IBlockData)state);
    }

    public int getCombinedIdByItemStack(ItemStack itemStack) {
        Block block = CraftMagicNumbers.getBlock((Material)itemStack.getType());
        return Block.i((IBlockData)block.n());
    }

    public BlockData getBlockDataByCombinedId(int id) {
        return CraftBlockData.fromData((IBlockData)Block.a((int)id));
    }

    public ItemStack getItemStackByCombinedId(int id) {
        return new ItemStack(CraftMagicNumbers.getMaterial((Block)Block.a((int)id).b()));
    }

    public WorldServer getWorldServer(org.bukkit.World w) {
        return ((CraftWorld)w).getHandle();
    }

    public ItemMeta getDeserializedItemMeta(Map<String, Object> meta) {
        try {
            Class<?> aClass = Class.forName("org.bukkit.craftbukkit.v1_20_R2.inventory.CraftMetaItem$SerializableMeta");
            Method deserialize = aClass.getDeclaredMethod("deserialize", Map.class);
            Object itemMeta = deserialize.invoke(null, meta);
            return (ItemMeta)itemMeta;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ByteBuf getDataWatcherValues(Entity entity) {
        net.minecraft.world.entity.Entity ent = (net.minecraft.world.entity.Entity)this.getNmsEntity(entity);
        List dataList = ent.al().c();
        if (dataList == null) {
            return null;
        }
        ByteBuf buf = PooledByteBufAllocator.DEFAULT.buffer();
        PacketDataSerializer serializer = new PacketDataSerializer(buf);
        dataList.forEach(d -> d.a(serializer));
        serializer.k(255);
        return buf;
    }

    public GameProfile getMCGameProfile(Player player) {
        return ((CraftPlayer)player).getProfile();
    }

    public Cat.Type getCatTypeFromInt(int catType) {
        IRegistry registry = BuiltInRegistries.aj;
        Holder.c ref = (Holder.c)registry.c(catType).get();
        return CraftCat.CraftType.minecraftToBukkit((CatVariant)((CatVariant)ref.a()));
    }

    public int getCatVariantAsInt(Cat.Type type) {
        IRegistry registry = BuiltInRegistries.aj;
        return registry.a((Object)CraftCat.CraftType.bukkitToMinecraft((Cat.Type)type));
    }

    public Frog.Variant getFrogVariantFromInt(int frogType) {
        IRegistry registry = BuiltInRegistries.ak;
        Holder.c ref = (Holder.c)registry.c(frogType).get();
        return CraftFrog.CraftVariant.minecraftToBukkit((FrogVariant)((FrogVariant)ref.a()));
    }

    public int getFrogVariantAsInt(Frog.Variant type) {
        IRegistry registry = BuiltInRegistries.ak;
        return registry.a((Object)CraftFrog.CraftVariant.bukkitToMinecraft((Frog.Variant)type));
    }

    public Art getPaintingFromInt(int paintingId) {
        RegistryBlocks registry = BuiltInRegistries.m;
        Holder.c ref = (Holder.c)registry.c(paintingId).get();
        return CraftArt.minecraftHolderToBukkit((Holder)((Holder)registry.c(paintingId).get()));
    }

    public int getPaintingAsInt(Art type) {
        RegistryBlocks registry = BuiltInRegistries.m;
        return registry.a((Object)CraftArt.bukkitToMinecraft((Art)type));
    }
}

