/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection.v1_18_1;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManagerAbstract;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vector3f;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R1.CraftArt;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.CraftSound;
import org.bukkit.craftbukkit.v1_18_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ReflectionManager
implements ReflectionManagerAbstract {
    public boolean hasInvul(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (nmsEntity instanceof LivingEntity) {
            return nmsEntity.invulnerableTime > 0;
        }
        return nmsEntity.isInvulnerableTo(DamageSource.GENERIC);
    }

    public int getIncrementedStateId(Player player) {
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        return serverPlayer.containerMenu.incrementStateId();
    }

    public int getNewEntityId() {
        return this.getNewEntityId(true);
    }

    public int getNewEntityId(boolean increment) {
        try {
            Field entityCounter = net.minecraft.world.entity.Entity.class.getDeclaredField("b");
            entityCounter.setAccessible(true);
            AtomicInteger atomicInteger = (AtomicInteger)entityCounter.get(null);
            if (increment) {
                return atomicInteger.incrementAndGet();
            }
            return atomicInteger.get();
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public ServerGamePacketListenerImpl getPlayerConnectionOrPlayer(Player player) {
        return ((CraftPlayer)player).getHandle().connection;
    }

    public net.minecraft.world.entity.Entity createEntityInstance(String entityName) {
        Optional optional = EntityType.byString((String)entityName.toLowerCase(Locale.ROOT));
        if (optional.isPresent()) {
            net.minecraft.world.entity.Entity entity;
            EntityType entityType = (EntityType)optional.get();
            ServerLevel world = this.getWorldServer((World)Bukkit.getWorlds().get(0));
            if (entityType == EntityType.PLAYER) {
                WrappedGameProfile gameProfile = ReflectionManagerAbstract.getGameProfile((UUID)new UUID(0L, 0L), (String)"Steve");
                entity = new ServerPlayer((MinecraftServer)this.getMinecraftServer(), world, (GameProfile)gameProfile.getHandle());
            } else {
                entity = entityType.create((Level)world);
            }
            entity.setPos(1.0, 1.0, 1.0);
            entity.setPos(0.0, 0.0, 0.0);
            return entity;
        }
        return null;
    }

    public MobEffect getMobEffectList(int id) {
        return MobEffect.byId((int)id);
    }

    public MobEffectInstance createMobEffect(PotionEffect effect) {
        return this.createMobEffect(effect.getType().getId(), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles());
    }

    public MobEffectInstance createMobEffect(int id, int duration, int amplification, boolean ambient, boolean particles) {
        return new MobEffectInstance(this.getMobEffectList(id), duration, amplification, ambient, particles);
    }

    public AABB getBoundingBox(Entity entity) {
        return ((CraftEntity)entity).getHandle().getBoundingBox();
    }

    public double getXBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).maxX - this.getBoundingBox((Entity)entity).minX;
    }

    public double getYBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).maxY - this.getBoundingBox((Entity)entity).minY;
    }

    public double getZBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).maxZ - this.getBoundingBox((Entity)entity).minZ;
    }

    public ServerPlayer getPlayerFromPlayerConnection(Object nmsEntity) {
        return ((ServerPlayerConnection)nmsEntity).getPlayer();
    }

    public Entity getBukkitEntity(Object nmsEntity) {
        return ((net.minecraft.world.entity.Entity)nmsEntity).getBukkitEntity();
    }

    public ItemStack getBukkitItem(Object nmsItem) {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)nmsItem));
    }

    public ItemStack getCraftItem(ItemStack bukkitItem) {
        return CraftItemStack.asCraftCopy((ItemStack)bukkitItem);
    }

    public SoundEvent getCraftSound(Sound sound) {
        return CraftSound.getSoundEffect((Sound)sound);
    }

    public ServerEntity getEntityTrackerEntry(Entity target) throws Exception {
        ServerLevel world = ((CraftWorld)target.getWorld()).getHandle();
        ServerChunkCache chunkSource = world.getChunkSource();
        ChunkMap chunkMap = chunkSource.chunkMap;
        Int2ObjectMap entityMap = chunkMap.entityMap;
        ChunkMap.TrackedEntity trackedEntity = (ChunkMap.TrackedEntity)entityMap.get(target.getEntityId());
        if (trackedEntity == null) {
            return null;
        }
        Field field = ChunkMap.TrackedEntity.class.getDeclaredField("b");
        field.setAccessible(true);
        return (ServerEntity)field.get(trackedEntity);
    }

    public DedicatedServer getMinecraftServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    public String getEnumArt(Art art) {
        return Registry.MOTIVE.getKey((Object)CraftArt.BukkitToNotch((Art)art)).getPath();
    }

    public BlockPos getBlockPosition(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    public Direction getEnumDirection(int direction) {
        return Direction.from2DDataValue((int)direction);
    }

    public PacketContainer getTabListPacket(String displayName, WrappedGameProfile gameProfile, boolean nameVisible, EnumWrappers.PlayerInfoAction ... actions) {
        ClientboundPlayerInfoPacket.PlayerUpdate entry = new ClientboundPlayerInfoPacket.PlayerUpdate((GameProfile)gameProfile.getHandle(), 0, GameType.SURVIVAL, (Component)new TextComponent(displayName));
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
        StructureModifier modifier = packet.getModifier();
        modifier.write(0, (Object)ClientboundPlayerInfoPacket.Action.valueOf((String)actions[0].name()));
        modifier.write(1, Collections.singletonList(entry));
        return packet;
    }

    public Object getNmsEntity(Entity entity) {
        return ((CraftEntity)entity).getHandle();
    }

    public double getPing(Player player) {
        return player.getPing();
    }

    public float[] getSize(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        EntityDimensions dimensions = nmsEntity.getDimensions(Pose.STANDING);
        return new float[]{dimensions.width, nmsEntity.getEyeHeight()};
    }

    public WrappedGameProfile getSkullBlob(WrappedGameProfile gameProfile) {
        DedicatedServer minecraftServer = this.getMinecraftServer();
        MinecraftSessionService sessionService = minecraftServer.getSessionService();
        return WrappedGameProfile.fromHandle((Object)sessionService.fillProfileProperties((GameProfile)gameProfile.getHandle(), true));
    }

    public Float getSoundModifier(Object entity) {
        if (!(entity instanceof LivingEntity)) {
            return Float.valueOf(0.0f);
        }
        try {
            Method method = LivingEntity.class.getDeclaredMethod("eu", new Class[0]);
            method.setAccessible(true);
            return (Float)method.invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    public void injectCallback(String playername, ProfileLookupCallback callback) {
        Agent agent = Agent.MINECRAFT;
        this.getMinecraftServer().getProfileRepository().findProfilesByNames(new String[]{playername}, agent, callback);
    }

    public void setBoundingBox(Entity entity, double x, double y, double z) {
        Location loc = entity.getLocation();
        ((CraftEntity)entity).getHandle().setBoundingBox(new AABB(loc.getX() - x / 2.0, loc.getY() - y / 2.0, loc.getZ() - z / 2.0, loc.getX() + x / 2.0, loc.getY() + y / 2.0, loc.getZ() + z / 2.0));
    }

    public Enum getSoundCategory(String category) {
        return (Enum)Arrays.stream(SoundSource.values()).filter(soundSource -> category.equalsIgnoreCase(soundSource.getName())).findAny().get();
    }

    public Enum createEnumItemSlot(org.bukkit.inventory.EquipmentSlot slot) {
        switch (slot) {
            case HAND: {
                return EquipmentSlot.MAINHAND;
            }
            case OFF_HAND: {
                return EquipmentSlot.OFFHAND;
            }
            case FEET: {
                return EquipmentSlot.FEET;
            }
            case LEGS: {
                return EquipmentSlot.LEGS;
            }
            case CHEST: {
                return EquipmentSlot.CHEST;
            }
            case HEAD: {
                return EquipmentSlot.HEAD;
            }
        }
        return null;
    }

    public Object getSoundString(Sound sound) {
        return CraftSound.getSoundEffect((Sound)sound).getLocation().toString();
    }

    public Optional<?> convertOptional(Object val) {
        if (val instanceof BlockPosition) {
            BlockPosition pos = (BlockPosition)val;
            return Optional.of(this.getBlockPosition(pos.getX(), pos.getY(), pos.getZ()));
        }
        if (val instanceof WrappedBlockData) {
            Object obj = ((WrappedBlockData)val).getHandle();
            return Optional.of(obj);
        }
        if (val instanceof ItemStack) {
            net.minecraft.world.item.ItemStack obj = this.getNmsItem((ItemStack)val);
            return Optional.of(obj);
        }
        if (val instanceof WrappedChatComponent) {
            Object obj = ((WrappedChatComponent)val).getHandle();
            return Optional.of(obj);
        }
        return Optional.of(val);
    }

    public Vector3f convertVec3(Object object) {
        if (object instanceof Vector3F) {
            Vector3F vector3F = (Vector3F)object;
            return new Vector3f(vector3F.getX(), vector3F.getY(), vector3F.getZ());
        }
        if (object instanceof EulerAngle) {
            EulerAngle eulerAngle = (EulerAngle)object;
            return new Vector3f((float)eulerAngle.getX(), (float)eulerAngle.getY(), (float)eulerAngle.getZ());
        }
        return null;
    }

    public Direction convertDirection(EnumWrappers.Direction direction) {
        return Direction.from3DDataValue((int)direction.ordinal());
    }

    public Material getMaterial(String name) {
        return CraftMagicNumbers.INSTANCE.getMaterial(name, CraftMagicNumbers.INSTANCE.getDataVersion());
    }

    public String getItemName(Material material) {
        return Registry.ITEM.getKey((Object)CraftMagicNumbers.getItem((Material)material)).getPath();
    }

    public net.minecraft.world.item.ItemStack getNmsItem(ItemStack itemStack) {
        return CraftItemStack.asNMSCopy((ItemStack)itemStack);
    }

    public VillagerData getNmsVillagerData(Villager.Type villagerType, Villager.Profession villagerProfession) {
        VillagerType nmsVillagerType = (VillagerType)Registry.VILLAGER_TYPE.get(CraftNamespacedKey.toMinecraft((NamespacedKey)villagerType.getKey()));
        VillagerProfession nmsVillagerProfession = (VillagerProfession)Registry.VILLAGER_PROFESSION.get(CraftNamespacedKey.toMinecraft((NamespacedKey)villagerProfession.getKey()));
        return new VillagerData(nmsVillagerType, nmsVillagerProfession, 1);
    }

    public VillagerType getVillagerType(Villager.Type type) {
        return (VillagerType)Registry.VILLAGER_TYPE.get(CraftNamespacedKey.toMinecraft((NamespacedKey)type.getKey()));
    }

    public VillagerProfession getVillagerProfession(Villager.Profession profession) {
        return (VillagerProfession)Registry.VILLAGER_PROFESSION.get(CraftNamespacedKey.toMinecraft((NamespacedKey)profession.getKey()));
    }

    public <T> SynchedEntityData.DataItem<T> createDataWatcherItem(WrappedDataWatcher.WrappedDataWatcherObject wrappedDataWatcherObject, T metaItem) {
        return new SynchedEntityData.DataItem((EntityDataAccessor)wrappedDataWatcherObject.getHandle(), metaItem);
    }

    public ResourceLocation createMinecraftKey(String name) {
        return new ResourceLocation(name);
    }

    public Vec3 getVec3D(Vector vector) {
        return new Vec3(vector.getX(), vector.getY(), vector.getZ());
    }

    public EntityType getEntityType(org.bukkit.entity.EntityType entityType) {
        return EntityType.byString((String)(entityType.getName() == null ? entityType.name().toLowerCase(Locale.ENGLISH) : entityType.getName())).orElse(null);
    }

    public Object registerEntityType(NamespacedKey key) {
        EntityType newEntity = new EntityType(null, null, false, false, false, false, null, null, 0, 0);
        Registry.register((Registry)Registry.ENTITY_TYPE, (ResourceLocation)CraftNamespacedKey.toMinecraft((NamespacedKey)key), (Object)newEntity);
        newEntity.getDescriptionId();
        return newEntity;
    }

    public int getEntityTypeId(Object entityTypes) {
        EntityType entityType = (EntityType)entityTypes;
        return Registry.ENTITY_TYPE.getId((Object)entityType);
    }

    public int getEntityTypeId(org.bukkit.entity.EntityType entityType) {
        return this.getEntityTypeId(this.getEntityType(entityType));
    }

    public Object getEntityType(NamespacedKey name) {
        return Registry.ENTITY_TYPE.get(CraftNamespacedKey.toMinecraft((NamespacedKey)name));
    }

    public Object getNmsEntityPose(String enumPose) {
        return Pose.valueOf((String)enumPose);
    }

    public int getCombinedIdByBlockData(BlockData data) {
        BlockState state = ((CraftBlockData)data).getState();
        return Block.getId((BlockState)state);
    }

    public int getCombinedIdByItemStack(ItemStack itemStack) {
        Block block = CraftMagicNumbers.getBlock((Material)itemStack.getType());
        return Block.getId((BlockState)block.defaultBlockState());
    }

    public BlockData getBlockDataByCombinedId(int id) {
        return CraftBlockData.fromData((BlockState)Block.stateById((int)id));
    }

    public ItemStack getItemStackByCombinedId(int id) {
        return new ItemStack(CraftMagicNumbers.getMaterial((Block)Block.stateById((int)id).getBlock()));
    }

    public ServerLevel getWorldServer(World w) {
        return ((CraftWorld)w).getHandle();
    }

    public ItemMeta getDeserializedItemMeta(Map<String, Object> meta) {
        try {
            Class<?> aClass = Class.forName("org.bukkit.craftbukkit.v1_18_R1.inventory.CraftMetaItem$SerializableMeta");
            Method deserialize = aClass.getDeclaredMethod("deserialize", Map.class);
            Object itemMeta = deserialize.invoke(null, meta);
            return (ItemMeta)itemMeta;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

