/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection.v1_17;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManagerAbstract;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Vector3f;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.bukkit.craftbukkit.v1_17_R1.CraftArt;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftSound;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ReflectionManager
implements ReflectionManagerAbstract {
    public boolean hasInvul(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (nmsEntity instanceof EntityLiving) {
            return nmsEntity.W > 0;
        }
        return nmsEntity.isInvulnerable(DamageSource.n);
    }

    public int getIncrementedStateId(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        return serverPlayer.bV.incrementStateId();
    }

    public int getNewEntityId() {
        return this.getNewEntityId(true);
    }

    public int getNewEntityId(boolean increment) {
        try {
            Field entityCounter = net.minecraft.world.entity.Entity.class.getDeclaredField("b");
            entityCounter.setAccessible(true);
            AtomicInteger atomicInteger = (AtomicInteger)entityCounter.get(null);
            if (increment) {
                return atomicInteger.incrementAndGet();
            }
            return atomicInteger.get();
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public PlayerConnection getPlayerConnectionOrPlayer(Player player) {
        return ((CraftPlayer)player).getHandle().b;
    }

    public net.minecraft.world.entity.Entity createEntityInstance(String entityName) {
        Optional optional = EntityTypes.a((String)entityName.toLowerCase(Locale.ROOT));
        if (optional.isPresent()) {
            net.minecraft.world.entity.Entity entity;
            EntityTypes entityType = (EntityTypes)optional.get();
            WorldServer world = this.getWorldServer((World)Bukkit.getWorlds().get(0));
            if (entityType == EntityTypes.bi) {
                WrappedGameProfile gameProfile = ReflectionManagerAbstract.getGameProfile((UUID)new UUID(0L, 0L), (String)"Steve");
                entity = new EntityPlayer((MinecraftServer)this.getMinecraftServer(), world, (GameProfile)gameProfile.getHandle());
            } else {
                entity = entityType.a((net.minecraft.world.level.World)world);
            }
            entity.setPosition(1.0, 1.0, 1.0);
            entity.setPosition(0.0, 0.0, 0.0);
            return entity;
        }
        return null;
    }

    public MobEffectList getMobEffectList(int id) {
        return MobEffectList.fromId((int)id);
    }

    public MobEffect createMobEffect(PotionEffect effect) {
        return this.createMobEffect(effect.getType().getId(), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles());
    }

    public MobEffect createMobEffect(int id, int duration, int amplification, boolean ambient, boolean particles) {
        return new MobEffect(this.getMobEffectList(id), duration, amplification, ambient, particles);
    }

    public AxisAlignedBB getBoundingBox(Entity entity) {
        return ((CraftEntity)entity).getHandle().getBoundingBox();
    }

    public double getXBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).d - this.getBoundingBox((Entity)entity).a;
    }

    public double getYBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).e - this.getBoundingBox((Entity)entity).b;
    }

    public double getZBoundingBox(Entity entity) {
        return this.getBoundingBox((Entity)entity).f - this.getBoundingBox((Entity)entity).c;
    }

    public EntityPlayer getPlayerFromPlayerConnection(Object nmsEntity) {
        return ((ServerPlayerConnection)nmsEntity).d();
    }

    public Entity getBukkitEntity(Object nmsEntity) {
        return ((net.minecraft.world.entity.Entity)nmsEntity).getBukkitEntity();
    }

    public ItemStack getBukkitItem(Object nmsItem) {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)nmsItem));
    }

    public ItemStack getCraftItem(ItemStack bukkitItem) {
        return CraftItemStack.asCraftCopy((ItemStack)bukkitItem);
    }

    public SoundEffect getCraftSound(Sound sound) {
        return CraftSound.getSoundEffect((Sound)sound);
    }

    public EntityTrackerEntry getEntityTrackerEntry(Entity target) throws Exception {
        WorldServer world = ((CraftWorld)target.getWorld()).getHandle();
        ChunkProviderServer chunkSource = world.getChunkProvider();
        PlayerChunkMap chunkMap = chunkSource.a;
        Int2ObjectMap entityMap = chunkMap.G;
        PlayerChunkMap.EntityTracker trackedEntity = (PlayerChunkMap.EntityTracker)entityMap.get(target.getEntityId());
        if (trackedEntity == null) {
            return null;
        }
        Field field = PlayerChunkMap.EntityTracker.class.getDeclaredField("b");
        field.setAccessible(true);
        return (EntityTrackerEntry)field.get(trackedEntity);
    }

    public DedicatedServer getMinecraftServer() {
        return ((CraftServer)Bukkit.getServer()).getServer();
    }

    public String getEnumArt(Art art) {
        return IRegistry.ad.getKey((Object)CraftArt.BukkitToNotch((Art)art)).getKey();
    }

    public net.minecraft.core.BlockPosition getBlockPosition(int x, int y, int z) {
        return new net.minecraft.core.BlockPosition(x, y, z);
    }

    public EnumDirection getEnumDirection(int direction) {
        return EnumDirection.fromType2((int)direction);
    }

    public PacketContainer getTabListPacket(String displayName, WrappedGameProfile gameProfile, boolean nameVisible, EnumWrappers.PlayerInfoAction ... actions) {
        PacketPlayOutPlayerInfo.PlayerInfoData entry = new PacketPlayOutPlayerInfo.PlayerInfoData((GameProfile)gameProfile.getHandle(), 0, EnumGamemode.a, (IChatBaseComponent)new ChatComponentText(displayName));
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
        StructureModifier modifier = packet.getModifier();
        modifier.write(0, (Object)PacketPlayOutPlayerInfo.EnumPlayerInfoAction.valueOf((String)actions[0].name()));
        modifier.write(1, Collections.singletonList(entry));
        return packet;
    }

    public Object getNmsEntity(Entity entity) {
        return ((CraftEntity)entity).getHandle();
    }

    public double getPing(Player player) {
        return player.getPing();
    }

    public float[] getSize(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        EntitySize dimensions = nmsEntity.a(EntityPose.a);
        return new float[]{dimensions.a, nmsEntity.getHeadHeight()};
    }

    public WrappedGameProfile getSkullBlob(WrappedGameProfile gameProfile) {
        DedicatedServer minecraftServer = this.getMinecraftServer();
        MinecraftSessionService sessionService = minecraftServer.getMinecraftSessionService();
        return WrappedGameProfile.fromHandle((Object)sessionService.fillProfileProperties((GameProfile)gameProfile.getHandle(), true));
    }

    public Float getSoundModifier(Object entity) {
        if (!(entity instanceof EntityLiving)) {
            return Float.valueOf(0.0f);
        }
        try {
            Method method = EntityLiving.class.getDeclaredMethod("getSoundVolume", new Class[0]);
            method.setAccessible(true);
            return (Float)method.invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    public void injectCallback(String playername, ProfileLookupCallback callback) {
        Agent agent = Agent.MINECRAFT;
        this.getMinecraftServer().getGameProfileRepository().findProfilesByNames(new String[]{playername}, agent, callback);
    }

    public void setBoundingBox(Entity entity, double x, double y, double z) {
        Location loc = entity.getLocation();
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(loc.getX() - x / 2.0, loc.getY() - y / 2.0, loc.getZ() - z / 2.0, loc.getX() + x / 2.0, loc.getY() + y / 2.0, loc.getZ() + z / 2.0));
    }

    public Enum getSoundCategory(String category) {
        return (Enum)Arrays.stream(SoundCategory.values()).filter(soundSource -> category.equalsIgnoreCase(soundSource.a())).findAny().get();
    }

    public Enum createEnumItemSlot(EquipmentSlot slot) {
        switch (slot) {
            case HAND: {
                return EnumItemSlot.a;
            }
            case OFF_HAND: {
                return EnumItemSlot.b;
            }
            case FEET: {
                return EnumItemSlot.c;
            }
            case LEGS: {
                return EnumItemSlot.d;
            }
            case CHEST: {
                return EnumItemSlot.e;
            }
            case HEAD: {
                return EnumItemSlot.f;
            }
        }
        return null;
    }

    public Object getSoundString(Sound sound) {
        return CraftSound.getSoundEffect((Sound)sound).a().toString();
    }

    public Optional<?> convertOptional(Object val) {
        if (val instanceof BlockPosition) {
            BlockPosition pos = (BlockPosition)val;
            return Optional.of(this.getBlockPosition(pos.getX(), pos.getY(), pos.getZ()));
        }
        if (val instanceof WrappedBlockData) {
            Object obj = ((WrappedBlockData)val).getHandle();
            return Optional.of(obj);
        }
        if (val instanceof ItemStack) {
            net.minecraft.world.item.ItemStack obj = this.getNmsItem((ItemStack)val);
            return Optional.of(obj);
        }
        if (val instanceof WrappedChatComponent) {
            Object obj = ((WrappedChatComponent)val).getHandle();
            return Optional.of(obj);
        }
        return Optional.of(val);
    }

    public Vector3f convertVec3(Object object) {
        if (object instanceof Vector3F) {
            Vector3F vector3F = (Vector3F)object;
            return new Vector3f(vector3F.getX(), vector3F.getY(), vector3F.getZ());
        }
        if (object instanceof EulerAngle) {
            EulerAngle eulerAngle = (EulerAngle)object;
            return new Vector3f((float)eulerAngle.getX(), (float)eulerAngle.getY(), (float)eulerAngle.getZ());
        }
        return null;
    }

    public EnumDirection convertDirection(EnumWrappers.Direction direction) {
        return EnumDirection.fromType1((int)direction.ordinal());
    }

    public Material getMaterial(String name) {
        return CraftMagicNumbers.INSTANCE.getMaterial(name, CraftMagicNumbers.INSTANCE.getDataVersion());
    }

    public String getItemName(Material material) {
        return IRegistry.Z.getKey((Object)CraftMagicNumbers.getItem((Material)material)).getKey();
    }

    public net.minecraft.world.item.ItemStack getNmsItem(ItemStack itemStack) {
        return CraftItemStack.asNMSCopy((ItemStack)itemStack);
    }

    public VillagerData getNmsVillagerData(Villager.Type villagerType, Villager.Profession villagerProfession, int level) {
        VillagerType nmsVillagerType = (VillagerType)IRegistry.ao.get(CraftNamespacedKey.toMinecraft((NamespacedKey)villagerType.getKey()));
        VillagerProfession nmsVillagerProfession = (VillagerProfession)IRegistry.ap.get(CraftNamespacedKey.toMinecraft((NamespacedKey)villagerProfession.getKey()));
        return new VillagerData(nmsVillagerType, nmsVillagerProfession, level);
    }

    public VillagerType getVillagerType(Villager.Type type) {
        return (VillagerType)IRegistry.ao.get(CraftNamespacedKey.toMinecraft((NamespacedKey)type.getKey()));
    }

    public VillagerProfession getVillagerProfession(Villager.Profession profession) {
        return (VillagerProfession)IRegistry.ap.get(CraftNamespacedKey.toMinecraft((NamespacedKey)profession.getKey()));
    }

    public <T> DataWatcher.Item<T> createDataWatcherItem(WrappedDataWatcher.WrappedDataWatcherObject wrappedDataWatcherObject, T metaItem) {
        return new DataWatcher.Item((DataWatcherObject)wrappedDataWatcherObject.getHandle(), metaItem);
    }

    public MinecraftKey createMinecraftKey(String name) {
        return new MinecraftKey(name);
    }

    public Vec3D getVec3D(Vector vector) {
        return new Vec3D(vector.getX(), vector.getY(), vector.getZ());
    }

    public EntityTypes getEntityType(EntityType entityType) {
        return EntityTypes.a((String)(entityType.getName() == null ? entityType.name().toLowerCase(Locale.ENGLISH) : entityType.getName())).orElse(null);
    }

    public Object registerEntityType(NamespacedKey key) {
        EntityTypes newEntity = new EntityTypes(null, null, false, false, false, false, null, null, 0, 0);
        IRegistry.a((IRegistry)IRegistry.Y, (MinecraftKey)CraftNamespacedKey.toMinecraft((NamespacedKey)key), (Object)newEntity);
        newEntity.g();
        return newEntity;
    }

    public int getEntityTypeId(Object entityTypes) {
        EntityTypes entityType = (EntityTypes)entityTypes;
        return IRegistry.Y.getId((Object)entityType);
    }

    public int getEntityTypeId(EntityType entityType) {
        return this.getEntityTypeId(this.getEntityType(entityType));
    }

    public Object getEntityType(NamespacedKey name) {
        return IRegistry.Y.get(CraftNamespacedKey.toMinecraft((NamespacedKey)name));
    }

    public Object getNmsEntityPose(String enumPose) {
        return EntityPose.valueOf((String)enumPose);
    }

    public int getCombinedIdByBlockData(BlockData data) {
        IBlockData state = ((CraftBlockData)data).getState();
        return Block.getCombinedId((IBlockData)state);
    }

    public int getCombinedIdByItemStack(ItemStack itemStack) {
        Block block = CraftMagicNumbers.getBlock((Material)itemStack.getType());
        return Block.getCombinedId((IBlockData)block.getBlockData());
    }

    public BlockData getBlockDataByCombinedId(int id) {
        return CraftBlockData.fromData((IBlockData)Block.getByCombinedId((int)id));
    }

    public ItemStack getItemStackByCombinedId(int id) {
        return new ItemStack(CraftMagicNumbers.getMaterial((Block)Block.getByCombinedId((int)id).getBlock()));
    }

    public WorldServer getWorldServer(World w) {
        return ((CraftWorld)w).getHandle();
    }

    public ItemMeta getDeserializedItemMeta(Map<String, Object> meta) {
        try {
            Class<?> aClass = Class.forName("org.bukkit.craftbukkit.v1_17_R1.inventory.CraftMetaItem$SerializableMeta");
            Method deserialize = aClass.getDeclaredMethod("deserialize", Map.class);
            Object itemMeta = deserialize.invoke(null, meta);
            return (ItemMeta)itemMeta;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

