/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.updates;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.updates.DisguiseUpdate;
import org.bukkit.ChatColor;

public class BaseJenkins {
    private final String baseUrl;

    public BaseJenkins(String baseUrl) {
        this.baseUrl = baseUrl + (baseUrl.endsWith("/") ? "" : "/");
    }

    protected Map<String, Object> fetchLastSnapshotBuild() {
        try {
            Map jsonObject;
            URL url = new URL(this.baseUrl + "api/json?tree=builds[changeSet[items[msg]],id,result,artifacts[relativePath]]");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setUseCaches(false);
            con.setDefaultUseCaches(false);
            try (InputStream input = con.getInputStream();){
                String json = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                jsonObject = (Map)new Gson().fromJson(json, Map.class);
            }
            con.disconnect();
            return jsonObject;
        }
        catch (Exception ex) {
            LibsDisguises.getInstance().getLogger().warning("Failed to check for an update on jenkins.");
            ex.printStackTrace();
            return null;
        }
    }

    public DisguiseUpdate getLatestSnapshot() {
        Map<String, Object> lastBuild = this.fetchLastSnapshotBuild();
        if (lastBuild == null || !lastBuild.containsKey("builds")) {
            return null;
        }
        ArrayList<String> downloads = new ArrayList<String>();
        ArrayList<String> changelog = new ArrayList<String>();
        String version = null;
        for (Map map : (List)lastBuild.get("builds")) {
            String result;
            List artifacts = (List)map.get("artifacts");
            if (artifacts == null || artifacts.isEmpty()) continue;
            if (downloads.isEmpty()) {
                for (Map artifact : artifacts) {
                    String relative = (String)artifact.get("relativePath");
                    if (relative == null || !relative.endsWith(".jar")) continue;
                    downloads.add(this.baseUrl + map.get("id") + "/artifact/" + relative);
                }
            }
            if (((result = (String)map.get("result")) == null || result.equalsIgnoreCase("null")) && version == null) {
                LibsDisguises.getInstance().getLogger().info("Jenkins build is pending.. Sleeping and checking again in 10 seconds");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return this.getLatestSnapshot();
            }
            Object items = ((Map)map.get("changeSet")).get("items");
            boolean release = false;
            if (items instanceof List) {
                for (Map item : (List)items) {
                    String msg = (String)item.get("msg");
                    if (msg == null) continue;
                    changelog.add("#" + map.get("id") + ": " + ChatColor.YELLOW + msg);
                    release = release || msg.toLowerCase(Locale.ENGLISH).matches("(re)?.?release.? .*");
                }
            }
            if (!"SUCCESS".equalsIgnoreCase(result)) continue;
            if (version == null) {
                version = (String)map.get("id");
            }
            if (!release) continue;
            break;
        }
        if (downloads.isEmpty()) {
            return null;
        }
        return new JenkinsUpdate(version, changelog.toArray(new String[0]), downloads);
    }

    static class JenkinsUpdate
    implements DisguiseUpdate {
        private final Date fetched = new Date();
        private final String version;
        private final String[] changelog;
        private final List<String> downloads;

        @Override
        public String getDownload() {
            if (this.downloads.size() != 1) {
                throw new IllegalStateException("We don't have any download information!");
            }
            return this.downloads.get(0);
        }

        @Override
        public boolean isReleaseBuild() {
            return false;
        }

        public JenkinsUpdate(String version, String[] changelog, List<String> downloads) {
            this.version = version;
            this.changelog = changelog;
            this.downloads = downloads;
        }

        @Override
        public Date getFetched() {
            return this.fetched;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String[] getChangelog() {
            return this.changelog;
        }

        @Override
        public List<String> getDownloads() {
            return this.downloads;
        }
    }
}

