/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;

public class WatcherInfo {
    @SerializedName(value="a")
    private int added = -1;
    @SerializedName(value="b")
    private int removed = -1;
    @SerializedName(value="c")
    private boolean deprecated;
    @SerializedName(value="d")
    private String returnType;
    @SerializedName(value="e")
    private boolean randomDefault;
    @SerializedName(value="f")
    private String watcher;
    @SerializedName(value="g")
    private String method;
    @SerializedName(value="h")
    private String mappedAs;
    @SerializedName(value="i")
    private String param;
    @SerializedName(value="j")
    private String descriptor;
    @SerializedName(value="k")
    private String description;
    @SerializedName(value="l")
    private boolean noVisibleDifference;
    @SerializedName(value="m")
    private List<Integer> unusableBy = new ArrayList<Integer>();
    @SerializedName(value="n")
    private List<Integer> hiddenFor = new ArrayList<Integer>();

    public void setHiddenFor(DisguiseType[] types) {
        for (DisguiseType type : types) {
            this.hiddenFor.add(type.ordinal());
        }
    }

    public void setUnusableBy(DisguiseType[] types) {
        for (DisguiseType type : types) {
            this.unusableBy.add(type.ordinal());
        }
    }

    public boolean isSupported() {
        if (this.getAdded() >= 0 && this.added > ReflectionManager.getVersion().ordinal()) {
            return false;
        }
        return this.getRemoved() < 0 || this.removed > ReflectionManager.getVersion().ordinal();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WatcherInfo that = (WatcherInfo)object;
        return this.added == that.added && this.removed == that.removed && this.deprecated == that.deprecated && this.randomDefault == that.randomDefault && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.watcher, that.watcher) && Objects.equals(this.method, that.method) && Objects.equals(this.mappedAs, that.mappedAs) && Objects.equals(this.param, that.param) && Objects.equals(this.descriptor, that.descriptor) && Objects.equals(this.unusableBy, that.unusableBy) && Objects.equals(this.hiddenFor, that.hiddenFor);
    }

    public int getAdded() {
        return this.added;
    }

    public int getRemoved() {
        return this.removed;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean isRandomDefault() {
        return this.randomDefault;
    }

    public String getWatcher() {
        return this.watcher;
    }

    public String getMethod() {
        return this.method;
    }

    public String getMappedAs() {
        return this.mappedAs;
    }

    public String getParam() {
        return this.param;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isNoVisibleDifference() {
        return this.noVisibleDifference;
    }

    public List<Integer> getUnusableBy() {
        return this.unusableBy;
    }

    public List<Integer> getHiddenFor() {
        return this.hiddenFor;
    }

    public void setAdded(int added) {
        this.added = added;
    }

    public void setRemoved(int removed) {
        this.removed = removed;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setRandomDefault(boolean randomDefault) {
        this.randomDefault = randomDefault;
    }

    public void setWatcher(String watcher) {
        this.watcher = watcher;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setMappedAs(String mappedAs) {
        this.mappedAs = mappedAs;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setNoVisibleDifference(boolean noVisibleDifference) {
        this.noVisibleDifference = noVisibleDifference;
    }
}

