/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.modded;

import com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.listeners.ModdedListener;
import me.libraryaddict.disguise.utilities.modded.ModdedEntity;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ModdedManager {
    private static final HashMap<NamespacedKey, ModdedEntity> entities = new HashMap();
    private static byte[] fmlHandshake;
    private static byte[] fmlRegistries;
    private static final Cache<String, ArrayList<String>> forgeMods;

    public ModdedManager(ArrayList<String> channels) {
        if (ModdedManager.getEntities().isEmpty()) {
            return;
        }
        if (NmsVersion.v1_20_R2.isSupported()) {
            return;
        }
        if (fmlRegistries == null && DisguiseConfig.isLoginPayloadPackets()) {
            Bukkit.getPluginManager().registerEvents((Listener)new ModdedListener(), (Plugin)LibsDisguises.getInstance());
        }
        this.createPayloads(channels);
    }

    private void writeString(Object buff, String string) {
        ByteBufHelper.writeVarInt((Object)buff, (int)string.length());
        ByteBufHelper.writeBytes((Object)buff, (byte[])string.getBytes(StandardCharsets.UTF_8));
    }

    private void createPayloads(ArrayList<String> channels) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(stream);
        ByteBufHelper.writeVarInt((Object)output, (int)1);
        ByteBufHelper.writeVarInt((Object)output, (int)0);
        ByteBufHelper.writeVarInt((Object)output, (int)channels.size());
        for (String string : channels) {
            this.writeString(output, string.substring(0, string.indexOf("|")));
            this.writeString(output, string.substring(string.indexOf("|") + 1));
        }
        ByteBufHelper.writeVarInt((Object)output, (int)0);
        fmlHandshake = stream.toByteArray();
        stream = new ByteArrayOutputStream();
        output = new DataOutputStream(stream);
        ByteBufHelper.writeVarInt((Object)output, (int)3);
        this.writeString(output, "minecraft:entity_type");
        ByteBufHelper.writeVarInt((Object)output, (int)1);
        ByteBufHelper.writeVarInt((Object)output, (int)entities.size());
        for (Map.Entry entry : entities.entrySet()) {
            this.writeString(output, ((NamespacedKey)entry.getKey()).toString());
            ByteBufHelper.writeVarInt((Object)output, (int)((ModdedEntity)entry.getValue()).getTypeId());
        }
        ByteBufHelper.writeVarInt((Object)output, (int)0);
        ByteBufHelper.writeVarInt((Object)output, (int)0);
        ByteBufHelper.writeVarInt((Object)output, (int)0);
        ByteBufHelper.writeVarInt((Object)output, (int)0);
        fmlRegistries = stream.toByteArray();
    }

    public static void registerModdedEntity(NamespacedKey name, ModdedEntity entity, boolean register) {
        Object entityType;
        if (entities.keySet().stream().anyMatch(n -> n.toString().equalsIgnoreCase(name.toString()))) {
            throw new IllegalArgumentException(name + " has already been registered");
        }
        if (entities.values().stream().anyMatch(n -> n.getName().equalsIgnoreCase(entity.getName()))) {
            throw new IllegalArgumentException("Modded entity " + entity.getName() + " has already been registered");
        }
        if (register) {
            entityType = ReflectionManager.registerEntityType(name);
            int entityId = ReflectionManager.getEntityTypeId(entityType);
            entity.setTypeId(entityId);
        } else {
            entityType = ReflectionManager.getEntityType(name);
            int entityId = ReflectionManager.getEntityTypeId(entityType);
            entity.setTypeId(entityId);
        }
        entity.setEntityType(entityType);
        entities.put(name, entity);
    }

    public static ModdedEntity getModdedEntity(NamespacedKey name) {
        return entities.get(name);
    }

    public static ModdedEntity getModdedEntity(String name) {
        for (ModdedEntity entity : entities.values()) {
            if (!entity.getName().equalsIgnoreCase(name)) continue;
            return entity;
        }
        return null;
    }

    public static void doMods(Player player) {
        ArrayList mods = (ArrayList)ModdedManager.getForgeMods().getIfPresent((Object)player.getName());
        player.setMetadata("forge_mods", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)mods));
        for (ModdedEntity e : ModdedManager.getEntities().values()) {
            if (e.getMod() == null || mods.contains(e.getMod().toLowerCase(Locale.ENGLISH)) || e.getRequired() == null) continue;
            player.kickPlayer(e.getRequired());
            break;
        }
    }

    public static ArrayList<DisguisePerm> getDisguiseTypes() {
        ArrayList<DisguisePerm> perms = new ArrayList<DisguisePerm>();
        for (Map.Entry<NamespacedKey, ModdedEntity> entry : entities.entrySet()) {
            perms.add(new DisguisePerm(entry.getValue().isLiving() ? DisguiseType.MODDED_LIVING : DisguiseType.MODDED_MISC, entry.getValue().getName()));
        }
        return perms;
    }

    public static HashMap<NamespacedKey, ModdedEntity> getEntities() {
        return entities;
    }

    public static byte[] getFmlHandshake() {
        return fmlHandshake;
    }

    public static byte[] getFmlRegistries() {
        return fmlRegistries;
    }

    public static Cache<String, ArrayList<String>> getForgeMods() {
        return forgeMods;
    }

    static {
        forgeMods = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }
}

