/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.config;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.reflection.ClassGetter;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigLoader {
    private final List<String> configs = new ArrayList<String>();

    public ConfigLoader() {
        for (String s : ClassGetter.getEntriesForPackage(ConfigLoader.class, "configs")) {
            if (!s.endsWith(".yml") || s.endsWith("/disguises.yml") || s.endsWith("/sounds.yml")) continue;
            this.configs.add(s);
        }
    }

    public void saveMissingConfigs() {
        File oldFile = new File(LibsDisguises.getInstance().getDataFolder(), "config.yml");
        boolean migrated = oldFile.exists();
        for (String config : this.configs) {
            File f = new File(LibsDisguises.getInstance().getDataFolder(), config);
            if (f.exists()) {
                migrated = false;
                continue;
            }
            this.saveDefaultConfig(config);
        }
        if (migrated) {
            LibsDisguises.getInstance().getLogger().info("Migrated old config system to new config system");
            oldFile.delete();
        }
    }

    public YamlConfiguration loadDefaults() {
        YamlConfiguration globalConfig = new YamlConfiguration();
        for (String config : this.configs) {
            try {
                YamlConfiguration c = new YamlConfiguration();
                c.loadFromString(ReflectionManager.getResourceAsString(LibsDisguises.getInstance().getFile(), config));
                for (String k : c.getKeys(true)) {
                    if (c.isConfigurationSection(k)) continue;
                    globalConfig.set(k, c.get(k));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return globalConfig;
    }

    public YamlConfiguration load() {
        YamlConfiguration globalConfig = new YamlConfiguration();
        for (String config : this.configs) {
            YamlConfiguration c = YamlConfiguration.loadConfiguration((File)new File(LibsDisguises.getInstance().getDataFolder(), config));
            for (String k : c.getKeys(true)) {
                if (c.isConfigurationSection(k)) continue;
                globalConfig.set(k, c.get(k));
            }
        }
        return globalConfig;
    }

    public void saveDefaultConfigs() {
        for (String config : this.configs) {
            this.saveDefaultConfig(config);
        }
        File f = new File(LibsDisguises.getInstance().getDataFolder(), "config.yml");
        f.delete();
    }

    public void saveDefaultConfig(String name) {
        File loadFrom;
        LibsDisguises.getInstance().getLogger().info("Config " + name + " is out of date (Or missing)! Now refreshing it!");
        String ourConfig = ReflectionManager.getResourceAsString(LibsDisguises.getInstance().getFile(), name);
        YamlConfiguration savedConfig = null;
        File configFile = loadFrom = new File(LibsDisguises.getInstance().getDataFolder(), name);
        if (!loadFrom.exists()) {
            loadFrom = new File(LibsDisguises.getInstance().getDataFolder(), "config.yml");
        }
        if (loadFrom.exists()) {
            savedConfig = YamlConfiguration.loadConfiguration((File)loadFrom);
        } else {
            try {
                savedConfig = new YamlConfiguration();
                savedConfig.loadFromString(ourConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> strings = new ArrayList<String>();
        String[] string = ourConfig.split("\n");
        boolean loadingList = false;
        boolean useInternalList = false;
        StringBuilder section = new StringBuilder();
        for (String s : string) {
            String key;
            if (s.trim().startsWith("-") && loadingList) {
                if (!useInternalList) continue;
                strings.add(s);
                continue;
            }
            if (loadingList) {
                loadingList = false;
            }
            if (s.trim().startsWith("#") || !s.contains(":") || s.trim().startsWith("-")) {
                strings.add(s);
                continue;
            }
            String rawKey = s.split(":")[0];
            if (section.length() > 0) {
                int matches = StringUtils.countMatches((String)rawKey, (String)"  ");
                int allowed = 0;
                for (int a = 0; a < matches; ++a) {
                    allowed = section.indexOf(".", allowed) + 1;
                }
                section = new StringBuilder(section.substring(0, allowed));
            }
            if (savedConfig.isConfigurationSection(key = (rawKey.startsWith(" ") ? section.toString() : "") + rawKey.trim())) {
                section.append(key).append(".");
            } else {
                if (savedConfig.isList(key)) {
                    strings.add(s);
                    loadingList = true;
                    boolean bl = useInternalList = !savedConfig.isSet(key);
                    if (useInternalList) continue;
                    for (String a : savedConfig.getStringList(key)) {
                        strings.add(rawKey.substring(0, Math.max(0, rawKey.indexOf(" ") + 1)) + "  - " + a);
                    }
                    continue;
                }
                if (savedConfig.isSet(key)) {
                    String rawVal = s.split(":")[1].trim();
                    Object val = savedConfig.get(key);
                    if (savedConfig.isString(key) && !rawVal.equals("true") && !rawVal.equals("false")) {
                        val = "'" + StringEscapeUtils.escapeJava((String)val.toString().replace("\u00a7", "&")) + "'";
                    }
                    s = rawKey + ": " + val;
                }
            }
            strings.add(s);
        }
        try {
            if (!configFile.getParentFile().exists()) {
                configFile.mkdirs();
            }
            configFile.delete();
            configFile.createNewFile();
            try (PrintWriter out = new PrintWriter(configFile);){
                out.write(String.join((CharSequence)"\n", strings));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> getConfigs() {
        return this.configs;
    }
}

