/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.attribute.Attributes;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodGroupType;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodOnlyUsedBy;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class LivingWatcher
extends FlagWatcher {
    private double maxHealth;
    private boolean maxHealthSet;
    private HashSet<String> potionEffects = new HashSet();
    private boolean[] modifiedLivingAnimations = new boolean[3];
    private Double viewScale;
    private boolean isScaleSet;

    public LivingWatcher(Disguise disguise) {
        super(disguise);
    }

    @Override
    public LivingWatcher clone(Disguise disguise) {
        LivingWatcher clone = (LivingWatcher)super.clone(disguise);
        clone.potionEffects = (HashSet)this.potionEffects.clone();
        clone.maxHealth = this.maxHealth;
        clone.maxHealthSet = this.maxHealthSet;
        clone.modifiedLivingAnimations = Arrays.copyOf(this.modifiedLivingAnimations, this.modifiedLivingAnimations.length);
        clone.viewScale = this.viewScale;
        return clone;
    }

    @NmsAddedIn(value=NmsVersion.v1_21_R1)
    public Double getScale() {
        return this.viewScale;
    }

    @NmsAddedIn(value=NmsVersion.v1_21_R1)
    public void setScale(Double viewScale) {
        if (!NmsVersion.v1_21_R1.isSupported()) {
            return;
        }
        if (viewScale != null) {
            if (viewScale < 0.0) {
                viewScale = 0.0;
            } else if (viewScale > 100.0) {
                viewScale = 100.0;
            }
        }
        this.viewScale = viewScale;
        if (this.getDisguise() == null || !this.getDisguise().isDisguiseInUse() || this.getDisguise().getWatcher() != this) {
            return;
        }
        this.updateNameHeight();
        double scaleToSend = this.getScale() != null ? this.getScale() : DisguiseUtilities.getActualEntityScale(this.getDisguise().getEntity());
        Entity entity = this.getDisguise().getEntity();
        for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
            double toSend = player == entity && DisguiseConfig.isTallSelfDisguisesScaling() ? Math.min(this.getDisguise().getSelfDisguiseTallScaleMax(), scaleToSend) : scaleToSend;
            WrapperPlayServerUpdateAttributes.Property property = new WrapperPlayServerUpdateAttributes.Property(Attributes.GENERIC_SCALE, toSend, new ArrayList());
            WrapperPlayServerUpdateAttributes packet = new WrapperPlayServerUpdateAttributes(player == this.getDisguise().getEntity() ? DisguiseAPI.getSelfDisguiseId() : this.getDisguise().getEntity().getEntityId(), Collections.singletonList(property));
            if (player == this.getDisguise().getEntity()) {
                PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)packet);
                continue;
            }
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
        }
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public Vector3i getBedPosition() {
        return this.getData(MetaIndex.LIVING_BED_POSITION).orElse(null);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setBedPosition(Vector3i blockPosition) {
        Optional<Object> optional = blockPosition != null ? Optional.of(blockPosition) : Optional.empty();
        this.sendData(MetaIndex.LIVING_BED_POSITION, optional);
    }

    public float getHealth() {
        return this.getData(MetaIndex.LIVING_HEALTH).floatValue();
    }

    public void setHealth(float health) {
        this.sendData(MetaIndex.LIVING_HEALTH, Float.valueOf(health));
    }

    private boolean getHandFlag(int byteValue) {
        return (this.getData(MetaIndex.LIVING_META) & 1 << byteValue) != 0;
    }

    private void setHandFlag(int byteValue, boolean flag) {
        byte b0 = this.getData(MetaIndex.LIVING_META);
        this.modifiedLivingAnimations[byteValue] = true;
        b0 = flag ? (byte)(b0 | 1 << byteValue) : (byte)(b0 & ~(1 << byteValue));
        this.sendData(MetaIndex.LIVING_META, b0);
    }

    private boolean isMainHandUsed() {
        return !this.getHandFlag(1);
    }

    private void setHandInUse(boolean mainHand) {
        if (this.isMainHandUsed() == mainHand) {
            return;
        }
        this.setHandFlag(1, !mainHand);
    }

    @Override
    @NmsAddedIn(value=NmsVersion.v1_13)
    public boolean isMainHandRaised() {
        return this.isMainHandUsed() && this.getHandFlag(0);
    }

    @Override
    @NmsAddedIn(value=NmsVersion.v1_13)
    @MethodOnlyUsedBy(value={}, group=MethodGroupType.HOLDABLE)
    public void setMainHandRaised(boolean setRightClicking) {
        this.setHandInUse(true);
        this.setHandFlag(0, setRightClicking);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public boolean isOffhandRaised() {
        return !this.isMainHandUsed() && this.getHandFlag(0);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    @MethodOnlyUsedBy(value={}, group=MethodGroupType.HOLDABLE)
    public void setOffhandRaised(boolean setLeftClicking) {
        this.setHandInUse(false);
        this.setHandFlag(0, setLeftClicking);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public boolean isSpinning() {
        return this.getHandFlag(2);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public void setSpinning(boolean setSpinning) {
        this.setHandFlag(2, setSpinning);
    }

    public void setMaxHealth(double newHealth) {
        this.maxHealth = newHealth;
        this.maxHealthSet = true;
        if (!this.getDisguise().isDisguiseInUse() || this.getDisguise().getWatcher() != this) {
            return;
        }
        for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
            WrapperPlayServerUpdateAttributes.Property property = new WrapperPlayServerUpdateAttributes.Property(Attributes.GENERIC_MAX_HEALTH, this.getMaxHealth(), new ArrayList());
            WrapperPlayServerUpdateAttributes packet = new WrapperPlayServerUpdateAttributes(player == this.getDisguise().getEntity() ? DisguiseAPI.getSelfDisguiseId() : this.getDisguise().getEntity().getEntityId(), Collections.singletonList(property));
            if (player == this.getDisguise().getEntity()) {
                PacketEvents.getAPI().getPlayerManager().sendPacketSilently((Object)player, (PacketWrapper)packet);
                continue;
            }
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
        }
    }

    public boolean isPotionParticlesAmbient() {
        return this.getData(MetaIndex.LIVING_POTION_AMBIENT);
    }

    public void setPotionParticlesAmbient(boolean particles) {
        this.sendData(MetaIndex.LIVING_POTION_AMBIENT, particles);
    }

    public Color getParticlesColor() {
        int color = this.getData(MetaIndex.LIVING_POTIONS);
        return Color.fromRGB((int)color);
    }

    public void setParticlesColor(Color color) {
        this.potionEffects.clear();
        this.sendData(MetaIndex.LIVING_POTIONS, color.asRGB());
    }

    private int getPotions() {
        if (this.potionEffects.isEmpty()) {
            return 0;
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String typeId : this.potionEffects) {
            Color color;
            PotionEffectType type = PotionEffectType.getByName((String)typeId);
            if (type == null || (color = type.getColor()) == null) continue;
            colors.add(color);
        }
        if (colors.isEmpty()) {
            return 0;
        }
        Color color = (Color)colors.remove(0);
        return color.mixColors(colors.toArray(new Color[0])).asRGB();
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.potionEffects.contains(type.getName());
    }

    public PotionEffectType[] getPotionEffects() {
        PotionEffectType[] effects = new PotionEffectType[this.potionEffects.size()];
        int i = 0;
        Iterator<String> itel = this.potionEffects.iterator();
        while (itel.hasNext()) {
            PotionEffectType type = PotionEffectType.getByName((String)itel.next());
            effects[i++] = type;
        }
        return effects;
    }

    public void addPotionEffect(PotionEffectType potionEffect) {
        if (!this.hasPotionEffect(potionEffect)) {
            this.potionEffects.add(potionEffect.getName());
        }
        this.sendPotionEffects();
    }

    public void removePotionEffect(PotionEffectType potionEffect) {
        if (this.hasPotionEffect(potionEffect)) {
            this.potionEffects.remove(potionEffect.getId());
        }
        this.sendPotionEffects();
    }

    private void sendPotionEffects() {
        this.sendData(MetaIndex.LIVING_POTIONS, this.getPotions());
    }

    public int getArrowsSticking() {
        return this.getData(MetaIndex.LIVING_ARROWS);
    }

    @MethodOnlyUsedBy(value={DisguiseType.PLAYER})
    public void setArrowsSticking(int arrowsNo) {
        this.sendData(MetaIndex.LIVING_ARROWS, Math.max(0, Math.min(127, arrowsNo)));
    }

    @Override
    protected byte addEntityAnimations(MetaIndex index, byte originalValue, byte entityValue) {
        if (index != MetaIndex.LIVING_META) {
            return super.addEntityAnimations(index, originalValue, entityValue);
        }
        for (int i = 0; i < 3; ++i) {
            if ((entityValue & 1 << i) == 0 || this.modifiedLivingAnimations[i]) continue;
            originalValue = (byte)(originalValue | 1 << i);
        }
        return originalValue;
    }

    @Override
    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_12)
    public boolean isRightClicking() {
        return this.isMainHandRaised();
    }

    @Override
    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_12)
    @MethodOnlyUsedBy(value={}, group=MethodGroupType.HOLDABLE)
    public void setRightClicking(boolean rightClicking) {
        this.setMainHandRaised(rightClicking);
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public boolean isMaxHealthSet() {
        return this.maxHealthSet;
    }

    public boolean[] getModifiedLivingAnimations() {
        return this.modifiedLivingAnimations;
    }
}

