/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Material;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class HorseWatcher
extends AbstractHorseWatcher {
    public HorseWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setStyle(ReflectionManager.randomEnum(Horse.Style.class));
            this.setColor(ReflectionManager.randomEnum(Horse.Color.class));
        }
    }

    public Horse.Color getColor() {
        return ReflectionManager.fromEnum(Horse.Color.class, this.getData(MetaIndex.HORSE_COLOR_STYLE) & 0xFF);
    }

    @RandomDefaultValue
    public void setColor(Horse.Color color) {
        this.sendData(MetaIndex.HORSE_COLOR_STYLE, color.ordinal() & 0xFF | this.getStyle().ordinal() << 8);
    }

    public Horse.Style getStyle() {
        return ReflectionManager.fromEnum(Horse.Style.class, this.getData(MetaIndex.HORSE_COLOR_STYLE) >>> 8);
    }

    @RandomDefaultValue
    public void setStyle(Horse.Style style) {
        this.sendData(MetaIndex.HORSE_COLOR_STYLE, this.getColor().ordinal() & 0xFF | style.ordinal() << 8);
    }

    public ItemStack getHorseArmor() {
        if (NmsVersion.v1_20_R4.isSupported()) {
            return this.getEquipment().getItem(EquipmentSlot.BODY);
        }
        return this.getEquipment().getChestplate();
    }

    public void setHorseArmor(ItemStack item) {
        if (NmsVersion.v1_20_R4.isSupported()) {
            this.getEquipment().setItem(EquipmentSlot.BODY, item);
        } else {
            this.getEquipment().setChestplate(item);
        }
        if (NmsVersion.v1_14.isSupported()) {
            return;
        }
        int value = 0;
        if (item != null) {
            Material mat = item.getType();
            if (mat == Material.IRON_HORSE_ARMOR) {
                value = 1;
            } else if (mat == Material.GOLDEN_HORSE_ARMOR) {
                value = 2;
            } else if (mat == Material.DIAMOND_HORSE_ARMOR) {
                value = 3;
            }
        }
        this.sendData(MetaIndex.HORSE_ARMOR, value);
    }
}

