/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.updates;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.updates.DisguiseUpdate;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;

public class LDGithub {
    private UpdateChecker checker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public DisguiseUpdate getLatestRelease() {
        try {
            String ourVersion = LibsDisguises.getInstance().getDescription().getVersion();
            if (!this.getChecker().isQuiet()) {
                LibsDisguises.getInstance().getLogger().info("Now looking for update on Github..");
            }
            URL url = new URL("https://api.github.com/repos/libraryaddict/LibsDisguises/releases/latest");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            try {
                GithubData gitData;
                con.setRequestProperty("User-Agent", "libraryaddict/LibsDisguises");
                con.setRequestProperty("Accept", "application/vnd.github.v3+json");
                if (Objects.equals(ourVersion, DisguiseConfig.getLastPluginUpdateVersion()) && DisguiseConfig.getLastGithubUpdateETag() != null) {
                    con.setRequestProperty("If-None-Match", DisguiseConfig.getLastGithubUpdateETag());
                }
                if (con.getResponseCode() == 304) {
                    DisguiseUpdate disguiseUpdate = null;
                    return disguiseUpdate;
                }
                try (InputStream input = con.getInputStream();){
                    String json = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    gitData = (GithubData)new Gson().fromJson(json, GithubData.class);
                }
                catch (IOException ex) {
                    block34: {
                        InputStream error;
                        block32: {
                            DisguiseUpdate disguiseUpdate;
                            block33: {
                                error = con.getErrorStream();
                                String line = new BufferedReader(new InputStreamReader(error, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                                LibsDisguises.getInstance().getLogger().severe("Error with Github! " + line);
                                if (!line.contains("rate limit") || DisguiseConfig.isHittingRateLimit()) break block32;
                                DisguiseConfig.setHittingRateLimit(true);
                                LibsDisguises.getInstance().getLogger().severe("Changed update checker to be every 36 hours due to rate limiting from this IP");
                                disguiseUpdate = null;
                                if (error == null) break block33;
                                error.close();
                            }
                            con.disconnect();
                            return disguiseUpdate;
                        }
                        try {
                            if (error != null) {
                                error.close();
                            }
                            break block34;
                            {
                                catch (Throwable throwable) {
                                    if (error != null) {
                                        try {
                                            error.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                            }
                        }
                        catch (Exception ex1) {
                            LibsDisguises.getInstance().getLogger().severe("Error when trying to read error stream! Inception!");
                            ex1.printStackTrace();
                        }
                    }
                    DisguiseUpdate ex1 = null;
                    con.disconnect();
                    return ex1;
                }
                String download = null;
                for (GithubData.Asset asset : gitData.getAssets()) {
                    if (!asset.getName().endsWith(".jar")) continue;
                    download = asset.getBrowser_download_url();
                    break;
                }
                if (download == null) {
                    throw new IllegalStateException("Download url is missing");
                }
                GithubUpdate update = new GithubUpdate(gitData.getTag_name().replace("v", ""), gitData.getBody().split("(\\r|\\n)+"), download);
                if (Objects.equals(update.getVersion(), ourVersion)) {
                    DisguiseConfig.setLastGithubUpdateETag(con.getHeaderField("ETag"));
                    DisguiseConfig.setLastPluginUpdateVersion(ourVersion);
                    DisguiseConfig.saveInternalConfig();
                }
                GithubUpdate githubUpdate = update;
                return githubUpdate;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                con.disconnect();
            }
        }
        catch (Exception ex) {
            LibsDisguises.getInstance().getLogger().warning("Failed to check for a release on Github");
            ex.printStackTrace();
            return null;
        }
    }

    public LDGithub(UpdateChecker checker) {
        this.checker = checker;
    }

    public UpdateChecker getChecker() {
        return this.checker;
    }

    private class GithubData {
        String name;
        String tag_name;
        String body;
        Date published_at;
        Asset[] assets;

        private GithubData() {
        }

        public String getName() {
            return this.name;
        }

        public String getTag_name() {
            return this.tag_name;
        }

        public String getBody() {
            return this.body;
        }

        public Date getPublished_at() {
            return this.published_at;
        }

        public Asset[] getAssets() {
            return this.assets;
        }

        class Asset {
            String browser_download_url;
            String name;
            String content_type;

            Asset() {
            }

            public String getBrowser_download_url() {
                return this.browser_download_url;
            }

            public String getName() {
                return this.name;
            }

            public String getContent_type() {
                return this.content_type;
            }
        }
    }

    private class GithubUpdate
    implements DisguiseUpdate {
        private String version;
        private String[] changelog;
        private String download;
        private final Date fetched = new Date();

        @Override
        public boolean isReleaseBuild() {
            return true;
        }

        @Override
        public List<String> getDownloads() {
            throw new IllegalStateException("Not implemented");
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String[] getChangelog() {
            return this.changelog;
        }

        @Override
        public String getDownload() {
            return this.download;
        }

        @Override
        public Date getFetched() {
            return this.fetched;
        }

        public GithubUpdate(String version, String[] changelog, String download) {
            this.version = version;
            this.changelog = changelog;
            this.download = download;
        }
    }
}

