/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import java.util.Set;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.sounds.SoundGroup;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketListenerSounds
extends PacketAdapter {
    public PacketListenerSounds(LibsDisguises plugin) {
        super((Plugin)plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.NAMED_SOUND_EFFECT});
    }

    public void onPacketSending(PacketEvent event) {
        if (event.isCancelled() || event.isAsync() || event.isPlayerTemporary()) {
            return;
        }
        this.handleNamedSoundEffect(event);
    }

    private void handleNamedSoundEffect(PacketEvent event) {
        PacketContainer newPacket;
        StructureModifier mods = event.getPacket().getModifier();
        Player observer = event.getPlayer();
        SoundGroup.SoundType soundType = null;
        Entity disguisedEntity = null;
        SoundGroup soundGroup = null;
        Object soundEffectObj = mods.read(0);
        Disguise disguise = null;
        int[] soundCords = new int[]{(Integer)mods.read(2), (Integer)mods.read(3), (Integer)mods.read(4)};
        for (Set<TargetedDisguise> disguises : DisguiseUtilities.getDisguises().values()) {
            for (TargetedDisguise entityDisguise : disguises) {
                Entity entity = entityDisguise.getEntity();
                if (entity == null || entity.getWorld() != observer.getWorld() || !entityDisguise.canSee(observer)) continue;
                Location loc = entity.getLocation();
                int[] entCords = new int[]{(int)(loc.getX() * 8.0), (int)(loc.getY() * 8.0), (int)(loc.getZ() * 8.0)};
                if (soundCords[0] != entCords[0] || soundCords[1] != entCords[1] || soundCords[2] != entCords[2]) continue;
                disguise = entityDisguise;
                disguisedEntity = entity;
                soundGroup = SoundGroup.getGroup(entity.getType().name());
                if (soundGroup == null || soundGroup.getSound(soundEffectObj) == null) {
                    return;
                }
                if (!(entity instanceof LivingEntity) || ((LivingEntity)entity).getHealth() > 0.0) {
                    boolean hasInvun = ReflectionManager.hasInvul(entity);
                    soundType = soundGroup.getType(soundEffectObj, !hasInvun);
                    continue;
                }
                soundType = SoundGroup.SoundType.DEATH;
            }
            if (disguise == null) continue;
            break;
        }
        if (disguise == null || !disguise.isSoundsReplaced()) {
            return;
        }
        if (disguisedEntity == observer && !disguise.isSelfDisguiseSoundsReplaced()) {
            return;
        }
        SoundGroup disguiseSound = SoundGroup.getGroup(disguise);
        if (disguiseSound == null) {
            event.setCancelled(true);
            return;
        }
        Object sound = disguiseSound.getSound(soundType);
        if (sound == null) {
            event.setCancelled(true);
            return;
        }
        Enum soundCat = ReflectionManager.getSoundCategory(disguise.getType());
        float volume = ((Float)mods.read(5)).floatValue();
        float pitch = ((Float)mods.read(6)).floatValue();
        if (volume == soundGroup.getDamageAndIdleSoundVolume()) {
            volume = disguiseSound.getDamageAndIdleSoundVolume();
        }
        if (disguise instanceof MobDisguise && disguisedEntity instanceof LivingEntity && ((MobDisguise)disguise).doesDisguiseAge()) {
            pitch = ((MobDisguise)disguise).isAdult() ? (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.0f : (DisguiseUtilities.random.nextFloat() - DisguiseUtilities.random.nextFloat()) * 0.2f + 1.4f;
        }
        if (sound.getClass().getSimpleName().equals("MinecraftKey")) {
            newPacket = new PacketContainer(PacketType.Play.Server.CUSTOM_SOUND_EFFECT);
            StructureModifier newModifs = newPacket.getModifier();
            newModifs.write(2, mods.read(2));
            newModifs.write(3, mods.read(3));
            newModifs.write(4, mods.read(4));
            mods = newModifs;
        } else {
            newPacket = event.getPacket().shallowClone();
            mods = newPacket.getModifier();
        }
        mods.write(0, sound);
        mods.write(1, (Object)soundCat);
        mods.write(5, (Object)Float.valueOf(volume));
        mods.write(6, (Object)Float.valueOf(pitch));
        event.setPacket(newPacket);
    }
}

