/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params.types.custom;

import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedParticle;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.params.types.ParamInfoEnum;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoColor;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemStack;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.inventory.ItemStack;

public class ParamInfoParticle
extends ParamInfoEnum {
    private Material[] materials;

    public ParamInfoParticle(Class paramClass, String name, String description, Enum[] possibleValues, Material[] materials) {
        super(paramClass, name, description, possibleValues);
        this.materials = materials;
    }

    @Override
    public Set<String> getEnums(String tabComplete) {
        Set<String> enums = this.getValues().keySet();
        if (tabComplete.isEmpty()) {
            return enums;
        }
        enums = new HashSet<String>(enums);
        tabComplete = tabComplete.toUpperCase(Locale.ENGLISH);
        for (Particle particle : new Particle[]{Particle.BLOCK_CRACK, Particle.BLOCK_DUST, Particle.ITEM_CRACK}) {
            for (Material mat : this.materials) {
                String name;
                if (particle != Particle.ITEM_CRACK && !mat.isBlock() || !(name = particle.name() + ":" + mat.name()).startsWith(tabComplete)) continue;
                enums.add(name);
            }
        }
        return enums;
    }

    @Override
    public String toString(Object object) {
        WrappedParticle particle = (WrappedParticle)object;
        Object data = particle.getData();
        String returns = particle.getParticle().name();
        if (data != null) {
            if (data instanceof ItemStack) {
                returns = returns + "," + ((ItemStack)data).getType().name();
            } else if (data instanceof WrappedBlockData) {
                returns = returns + "," + ((WrappedBlockData)data).getType().name();
            } else if (data instanceof Particle.DustOptions) {
                returns = returns + "," + ParamInfoManager.getParamInfo(Color.class).toString(((Particle.DustOptions)data).getColor());
                if (((Particle.DustOptions)data).getSize() != 1.0f) {
                    returns = returns + "," + ((Particle.DustOptions)data).getSize();
                }
            }
        }
        return returns;
    }

    @Override
    public Object fromString(String string) throws DisguiseParseException {
        String[] split = string.split("[:,]");
        Particle particle = (Particle)super.fromString(split[0]);
        if (particle == null) {
            return null;
        }
        ItemStack data = null;
        switch (particle) {
            case BLOCK_CRACK: 
            case BLOCK_DUST: 
            case FALLING_DUST: {
                Material material;
                if (split.length != 2 || (material = Material.getMaterial((String)split[1])) == null || !material.isBlock()) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_BLOCK, particle.name(), string);
                }
                data = WrappedBlockData.createData((Material)material);
                break;
            }
            case ITEM_CRACK: {
                if (split.length != 1) {
                    data = ParamInfoItemStack.parseToItemstack(Arrays.copyOfRange(split, 1, split.length));
                }
                if (data != null) break;
                throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_ITEM, particle.name(), string);
            }
            case REDSTONE: {
                float size;
                if (split.length < 2 || split.length > 5) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_REDSTONE, particle.name(), string);
                }
                Color color = ((ParamInfoColor)ParamInfoManager.getParamInfo(Color.class)).parseToColor(StringUtils.join((Object[])Arrays.copyOfRange(split, 1, split.length - split.length % 2), (String)","));
                if (color == null) {
                    throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_REDSTONE, particle.name(), string);
                }
                if (split.length % 2 == 0) {
                    size = 1.0f;
                } else {
                    if (!split[split.length - 1].matches("[0-9.]+")) {
                        throw new DisguiseParseException(LibsMsg.PARSE_PARTICLE_REDSTONE, particle.name(), string);
                    }
                    size = Math.max(0.2f, Float.parseFloat(split[split.length - 1]));
                    if (size > 100.0f) {
                        size = 100.0f;
                    }
                }
                data = new Particle.DustOptions(color, size);
            }
        }
        if (data == null && split.length > 1) {
            return null;
        }
        return WrappedParticle.create((Particle)particle, data);
    }

    @Override
    public boolean isCustomValues() {
        return true;
    }
}

