/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import ld-shaded.net.kyori.adventure.key.Key;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.format.Style;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class FontTransformation
extends Transformation {
    private final Key font;

    public static FontTransformation create(String name, List<TagPart> args) {
        Key font;
        if (args.size() == 1) {
            String fontKey = args.get(0).value();
            font = Key.key(fontKey);
        } else if (args.size() == 2) {
            String namespaceKey = args.get(0).value();
            String fontKey = args.get(1).value();
            font = Key.key(namespaceKey, fontKey);
        } else {
            throw new ParsingException("Don't know how to turn " + args + " into a font", args);
        }
        return new FontTransformation(font);
    }

    private FontTransformation(Key font) {
        this.font = font;
    }

    @Override
    public Component apply() {
        return Component.empty().style(Style.style().font(this.font));
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("font", this.font));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FontTransformation that = (FontTransformation)other;
        return Objects.equals(this.font, that.font);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.font);
    }
}

