/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.watchers;

import com.google.gson.Gson;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.WatcherMethod;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.WatcherInfo;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;

public class DisguiseMethods {
    private HashMap<Class<? extends FlagWatcher>, List<WatcherMethod>> watcherMethods = new HashMap();
    private HashMap<Class<? extends Disguise>, List<WatcherMethod>> disguiseMethods = new HashMap();
    private ArrayList<WatcherMethod> methods = new ArrayList();

    public ArrayList<WatcherMethod> getMethods(Class c) {
        ArrayList<WatcherMethod> methods = new ArrayList<WatcherMethod>();
        if (this.watcherMethods.containsKey(c)) {
            methods.addAll((Collection<WatcherMethod>)this.watcherMethods.get(c));
        }
        if (c != FlagWatcher.class) {
            methods.addAll(this.getMethods(c.getSuperclass()));
        }
        return methods;
    }

    public DisguiseMethods() {
        this.loadMethods();
    }

    /*
     * WARNING - void declaration
     */
    private void loadMethods() {
        try (InputStream stream = LibsDisguises.getInstance().getResource("ANTI_PIRACY_ENCRYPTION");){
            void var7_17;
            String[] lines = new String(ReflectionManager.readFuzzyFully(stream), StandardCharsets.UTF_8).split("\n");
            HashMap<String, Object> classes = new HashMap<String, Object>();
            classes.put(FlagWatcher.class.getSimpleName(), FlagWatcher.class);
            block29: for (DisguiseType disguiseType : DisguiseType.values()) {
                void var8_18;
                if (disguiseType.getWatcherClass() == null) continue;
                Class<? extends FlagWatcher> clazz = disguiseType.getWatcherClass();
                while (!classes.containsKey(var8_18.getSimpleName())) {
                    classes.put(var8_18.getSimpleName(), var8_18);
                    if (var8_18 == FlagWatcher.class) continue block29;
                    Class clazz2 = ReflectionManager.getSuperClass((Class)var8_18);
                }
            }
            for (String string : lines) {
                Class watcher;
                WatcherInfo watcherInfo = (WatcherInfo)new Gson().fromJson(string, WatcherInfo.class);
                if (!watcherInfo.isSupported() || watcherInfo.isDeprecated() && watcherInfo.getAdded() != 0 && watcherInfo.getRemoved() < 0 || (watcher = (Class)classes.get(watcherInfo.getWatcher())) == null) continue;
                Class<?> param = DisguiseMethods.parseType(watcherInfo.getParam());
                Class<?> returnType = DisguiseMethods.parseType(watcherInfo.getReturnType());
                String paramName = watcherInfo.getParam();
                MethodType type = param == null || param == Void.TYPE ? MethodType.methodType(returnType) : MethodType.methodType(returnType, param);
                MethodHandle method = MethodHandles.publicLookup().findVirtual(watcher, watcherInfo.getMethod(), type);
                WatcherMethod m = new WatcherMethod(watcher, method, watcherInfo.getMethod(), returnType, param, watcherInfo.isRandomDefault(), watcherInfo.isDeprecated() && watcherInfo.getAdded() == 0);
                this.methods.add(m);
                if (m.getName().startsWith("get") || m.getName().startsWith("has") || param == null || param == Void.TYPE || ParamInfoManager.getParamInfo(m) == null) continue;
                this.watcherMethods.computeIfAbsent(watcher, a -> new ArrayList()).add(m);
            }
            PlayerDisguise playerDisguise = new PlayerDisguise("");
            String[] stringArray = new String[]{"setSelfDisguiseVisible", "setHideHeldItemFromSelf", "setHideArmorFromSelf", "setHearSelfDisguise", "setHidePlayer", "setExpires", "setNotifyBar", "setBossBarColor", "setBossBarStyle", "setTallDisguisesVisible", "setDynamicName", "setSoundGroup", "setDisguiseName", "setDeadmau5Ears"};
            int n = stringArray.length;
            boolean bl = false;
            while (var7_17 < n) {
                Class[] classArray = stringArray[var7_17];
                try {
                    Class<Object> cl = Boolean.TYPE;
                    Class<Disguise> disguiseClass = Disguise.class;
                    boolean randomDefault = false;
                    switch (classArray) {
                        case "setExpires": {
                            cl = Long.TYPE;
                            break;
                        }
                        case "setNotifyBar": {
                            cl = DisguiseConfig.NotifyBar.class;
                            break;
                        }
                        case "setBossBarColor": {
                            cl = BarColor.class;
                            break;
                        }
                        case "setBossBarStyle": {
                            cl = BarStyle.class;
                            break;
                        }
                        case "setDisguiseName": {
                            randomDefault = true;
                        }
                        case "setSoundGroup": {
                            cl = String.class;
                            break;
                        }
                        case "setDeadmau5Ears": {
                            disguiseClass = PlayerDisguise.class;
                            break;
                        }
                    }
                    for (Class returnType : new Class[]{Void.TYPE, disguiseClass}) {
                        try {
                            WatcherMethod method = new WatcherMethod(disguiseClass, MethodHandles.publicLookup().findVirtual(disguiseClass, (String)classArray, MethodType.methodType(returnType, cl)), (String)classArray, null, cl, randomDefault, false);
                            this.methods.add(method);
                            this.watcherMethods.computeIfAbsent(disguiseClass == Disguise.class ? FlagWatcher.class : PlayerWatcher.class, a -> new ArrayList()).add(method);
                            String getName = (cl == Boolean.TYPE ? "is" : "get") + classArray.substring(3);
                            WatcherMethod getMethod = new WatcherMethod(disguiseClass, MethodHandles.publicLookup().findVirtual(disguiseClass, getName, MethodType.methodType(cl)), getName, cl, null, randomDefault, false);
                            this.methods.add(getMethod);
                            break;
                        }
                        catch (NoSuchMethodException ex) {
                            if (returnType != disguiseClass) continue;
                            ex.printStackTrace();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ++var7_17;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static Class<?> parseType(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (className.contains(".")) {
            return Class.forName(className);
        }
        switch (className) {
            case "void": {
                return Void.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "[I": {
                return int[].class;
            }
            case "[Z": {
                return boolean[].class;
            }
        }
        throw new IllegalArgumentException("Class not found: " + className);
    }

    public ArrayList<WatcherMethod> getMethods() {
        return this.methods;
    }
}

