/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class LDScoreboard
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("teams", "scoreboard", "board", "pushing");
    }

    @Override
    public String getPermission() {
        return "libsdisguises.scoreboard";
    }

    @Override
    public void onCommand(CommandSender sender, String[] args) {
        Scoreboard board;
        Team team;
        Player player;
        if (DisguiseConfig.isScoreboardNames()) {
            int issuesFound = 0;
            int unexpected = 0;
            for (Set<TargetedDisguise> set : DisguiseUtilities.getDisguises().values()) {
                for (Disguise disguise : set) {
                    if (!disguise.isPlayerDisguise()) continue;
                    if (!((PlayerDisguise)disguise).hasScoreboardName()) {
                        if (unexpected++ >= 3) continue;
                        sender.sendMessage("The player disguise " + ((PlayerDisguise)disguise).getName() + " isn't using a scoreboard name? This is unexpected");
                        continue;
                    }
                    DisguiseUtilities.DScoreTeam scoreboardName = ((PlayerDisguise)disguise).getScoreboardName();
                    if (scoreboardName.getTeamName() == null) continue;
                    ArrayList<Scoreboard> checked = new ArrayList<Scoreboard>();
                    for (Player player2 : Bukkit.getOnlinePlayers()) {
                        Scoreboard board2 = player2.getScoreboard();
                        if (checked.contains(board2)) continue;
                        checked.add(board2);
                        Team team2 = board2.getTeam(scoreboardName.getTeamName());
                        if (team2 == null) {
                            if (issuesFound++ >= 5) continue;
                            sender.sendMessage("The player disguise " + ((PlayerDisguise)disguise).getName().replace('\u00a7', '&') + " is missing a scoreboard team '" + scoreboardName.getTeamName() + "' on " + player2.getName() + " and possibly more players!");
                            continue;
                        }
                        if (!(team2.getPrefix().equals("Colorize") || team2.getPrefix().equals(scoreboardName.getPrefix()) && team2.getSuffix().equals(scoreboardName.getSuffix()))) {
                            if (issuesFound++ >= 5) continue;
                            sender.sendMessage("The player disguise " + ((PlayerDisguise)disguise).getName().replace('\u00a7', '&') + " on scoreboard team '" + scoreboardName.getTeamName() + "' on " + player2.getName() + " has an unexpected prefix/suffix of '" + team2.getPrefix().replace('\u00a7', '&') + "' & '" + team2.getSuffix().replace('\u00a7', '&') + "'! Expected '" + scoreboardName.getPrefix().replace('\u00a7', '&') + "' & '" + scoreboardName.getSuffix().replace('\u00a7', '&') + "'");
                            continue;
                        }
                        if (team2.hasEntry(scoreboardName.getPlayer()) || issuesFound++ >= 5) continue;
                        sender.sendMessage("The player disguise " + ((PlayerDisguise)disguise).getName().replace('\u00a7', '&') + " on scoreboard team '" + scoreboardName.getTeamName() + "' on " + player2.getName() + " does not have the player entry expected! Instead has '" + StringUtils.join((Collection)team2.getEntries(), (String)", ").replace('\u00a7', '&') + "'");
                    }
                }
            }
            if (issuesFound == 0) {
                LibsMsg.LIBS_SCOREBOARD_NO_ISSUES.send(sender, new Object[0]);
            } else {
                LibsMsg.LIBS_SCOREBOARD_ISSUES.send(sender, issuesFound);
            }
        } else {
            LibsMsg.LIBS_SCOREBOARD_NAMES_DISABLED.send(sender, new Object[0]);
        }
        List listeners = ProtocolLibrary.getProtocolManager().getPacketListeners().stream().filter(listener -> listener.getPlugin() != LibsDisguises.getInstance() && listener.getSendingWhitelist().getTypes().contains(PacketType.Play.Server.SCOREBOARD_TEAM)).collect(Collectors.toList());
        if (!listeners.isEmpty()) {
            ComponentBuilder builder = new ComponentBuilder("");
            builder.append("The following plugins are listening for scoreboard teams using ProtocolLib, and could be modifying collisions: ");
            builder.color(net.md_5.bungee.api.ChatColor.BLUE);
            boolean comma = false;
            for (PacketListener listener2 : listeners) {
                if (comma) {
                    builder.reset();
                    builder.append(", ");
                    builder.color(net.md_5.bungee.api.ChatColor.BLUE);
                }
                comma = true;
                builder.reset();
                builder.append(listener2.getPlugin().getName());
                builder.color(net.md_5.bungee.api.ChatColor.AQUA);
                String plugin = ChatColor.GOLD + "Plugin: " + ChatColor.YELLOW + listener2.getPlugin().getName() + " v" + listener2.getPlugin().getDescription().getVersion();
                String listenerClass = ChatColor.GOLD + "Listener: " + ChatColor.YELLOW + listener2.getClass().toString();
                String packets = ChatColor.GOLD + "Packets: " + ChatColor.YELLOW + StringUtils.join((Collection)listener2.getSendingWhitelist().getTypes(), (String)", ");
                String priority = ChatColor.GOLD + "Priority: " + ChatColor.YELLOW + listener2.getSendingWhitelist().getPriority();
                String options = ChatColor.GOLD + "Options: " + ChatColor.YELLOW + StringUtils.join((Collection)listener2.getSendingWhitelist().getOptions(), (String)", ");
                builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)(plugin + "\n" + listenerClass + "\n" + packets + "\n" + priority + "\n" + options))));
            }
            sender.spigot().sendMessage(builder.create());
        }
        LibsMsg.LIBS_SCOREBOARD_IGNORE_TEST.send(sender, new Object[0]);
        sender.sendMessage(ChatColor.RED + "This command is somewhat outdated and needs to be changed, pushing is now disabled on the entities themselves and not players");
        if (args.length > 1) {
            player = Bukkit.getPlayer((String)args[1]);
            if (player == null) {
                LibsMsg.CANNOT_FIND_PLAYER.send(sender, args[1]);
                return;
            }
            if (!DisguiseAPI.isDisguised((Entity)player)) {
                LibsMsg.DMODPLAYER_NODISGUISE.send(sender, player.getName());
                LibsMsg.DISGUISE_REQUIRED.send(sender, new Object[0]);
                return;
            }
        } else if (sender instanceof Player) {
            player = (Player)sender;
            if (!DisguiseAPI.isDisguised((Entity)player)) {
                LibsMsg.DISGUISE_REQUIRED.send(sender, new Object[0]);
                return;
            }
        } else {
            LibsMsg.NO_CONSOLE.send(sender, new Object[0]);
            return;
        }
        if ((team = (board = player.getScoreboard()).getEntryTeam(sender.getName())) == null) {
            LibsMsg.LIBS_SCOREBOARD_NO_TEAM.send(sender, new Object[0]);
            return;
        }
        LibsMsg.LIBS_SCOREBOARD_SUCCESS.send(sender, team.getName());
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission(this.getPermission());
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_SCOREBOARD;
    }
}

