/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.template;

import java.util.function.Predicate;
import ld-shaded.net.kyori.adventure.text.minimessage.Template;
import ld-shaded.net.kyori.adventure.text.minimessage.template.TemplateResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FilteringTemplateResolver
implements TemplateResolver {
    private final TemplateResolver templateResolver;
    private final Predicate<Template> filter;

    FilteringTemplateResolver(TemplateResolver templateResolver, Predicate<Template> filter) {
        this.templateResolver = templateResolver;
        this.filter = filter;
    }

    @Override
    public boolean canResolve(@NotNull String key) {
        return this.resolve(key) != null;
    }

    @Override
    @Nullable
    public Template resolve(@NotNull String key) {
        Template template = this.templateResolver.resolve(key);
        if (template == null || this.filter.test(template)) {
            return null;
        }
        return template;
    }
}

