/*
 * Decompiled with CFR 0.152.
 */
package ld-shaded.net.kyori.adventure.text.minimessage.transformation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ld-shaded.net.kyori.adventure.text.minimessage.Context;
import ld-shaded.net.kyori.adventure.text.minimessage.Template;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.ParsingException;
import ld-shaded.net.kyori.adventure.text.minimessage.parser.node.TagPart;
import ld-shaded.net.kyori.adventure.text.minimessage.template.TemplateResolver;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.Transformation;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationFactory;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationRegistry;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.TransformationType;
import ld-shaded.net.kyori.adventure.text.minimessage.transformation.inbuild.TemplateTransformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TransformationRegistryImpl
implements TransformationRegistry {
    private static final List<TransformationType<? extends Transformation>> DEFAULT_TRANSFORMATIONS = new ArrayList<TransformationType<? extends Transformation>>();
    static final TransformationRegistry EMPTY;
    static final TransformationRegistry STANDARD;
    private final List<TransformationType<? extends Transformation>> types;

    TransformationRegistryImpl(List<TransformationType<? extends Transformation>> types) {
        this.types = Collections.unmodifiableList(types);
    }

    private Transformation tryLoad(TransformationFactory<?> factory, String name, List<TagPart> inners, Context context) {
        try {
            Object xform = factory.parse(context, name, inners.subList(1, inners.size()));
            ((Transformation)xform).context(context);
            ((Transformation)xform).load(name, inners.subList(1, inners.size()));
            return xform;
        }
        catch (ParsingException exception) {
            exception.originalText(context.originalMessage());
            throw exception;
        }
    }

    @Override
    @Nullable
    public Transformation get(String name, List<TagPart> inners, TemplateResolver templateResolver, Context context) {
        Template template = templateResolver.resolve(name);
        if (template != null && template instanceof Template.ComponentTemplate) {
            return this.tryLoad(TemplateTransformation.factory(new Template.ComponentTemplate(name, ((Template.ComponentTemplate)template).value())), name, inners, context);
        }
        for (TransformationType<? extends Transformation> type : this.types) {
            if (!type.canParse.test(name)) continue;
            return this.tryLoad(type.factory, name, inners, context);
        }
        return null;
    }

    @Override
    public boolean exists(String name, TemplateResolver templateResolver) {
        if (templateResolver.canResolve(name)) {
            return true;
        }
        for (TransformationType<? extends Transformation> type : this.types) {
            if (!type.canParse.test(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public TransformationRegistry.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static {
        DEFAULT_TRANSFORMATIONS.add(TransformationType.COLOR);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.DECORATION);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.HOVER_EVENT);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.CLICK_EVENT);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.KEYBIND);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.TRANSLATABLE);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.INSERTION);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.FONT);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.GRADIENT);
        DEFAULT_TRANSFORMATIONS.add(TransformationType.RAINBOW);
        EMPTY = new TransformationRegistryImpl(Collections.emptyList());
        STANDARD = (TransformationRegistry)TransformationRegistry.builder().build();
    }

    static final class BuilderImpl
    implements TransformationRegistry.Builder {
        private final List<TransformationType<? extends Transformation>> types;

        BuilderImpl() {
            this.types = new ArrayList<TransformationType<? extends Transformation>>(DEFAULT_TRANSFORMATIONS);
        }

        BuilderImpl(TransformationRegistryImpl registry) {
            this.types = new ArrayList<TransformationType<? extends Transformation>>(registry.types);
        }

        @Override
        @NotNull
        public TransformationRegistry.Builder clear() {
            this.types.clear();
            return this;
        }

        @Override
        @NotNull
        public TransformationRegistry.Builder add(@NotNull TransformationType<? extends Transformation> transformation) {
            this.types.add(transformation);
            return this;
        }

        @Override
        @SafeVarargs
        @NotNull
        public final TransformationRegistry.Builder add(TransformationType<? extends Transformation> ... transformations) {
            Collections.addAll(this.types, transformations);
            return this;
        }

        @Override
        @NotNull
        public TransformationRegistry build() {
            return new TransformationRegistryImpl(this.types);
        }
    }
}

