/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.Optional;
import java.util.UUID;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;

public class TameableWatcher
extends AgeableWatcher {
    public TameableWatcher(Disguise disguise) {
        super(disguise);
    }

    public Optional<UUID> getOwner() {
        return this.getData(MetaIndex.TAMEABLE_OWNER);
    }

    public boolean isSitting() {
        return this.isTameableFlag(1);
    }

    public boolean isTamed() {
        return this.isTameableFlag(4);
    }

    protected boolean isTameableFlag(int no) {
        return (this.getData(MetaIndex.TAMEABLE_META) & no) != 0;
    }

    protected void setTameableFlag(int no, boolean flag) {
        byte value = this.getData(MetaIndex.TAMEABLE_META);
        if (flag) {
            this.setData(MetaIndex.TAMEABLE_META, (byte)(value | no));
        } else {
            this.setData(MetaIndex.TAMEABLE_META, (byte)(value & -(no + 1)));
        }
        this.sendData(MetaIndex.TAMEABLE_META);
    }

    public void setOwner(UUID owner) {
        this.setData(MetaIndex.TAMEABLE_OWNER, Optional.of(owner));
        this.sendData(MetaIndex.TAMEABLE_OWNER);
    }

    public void setSitting(boolean sitting) {
        this.setTameableFlag(1, sitting);
    }

    public void setTamed(boolean tamed) {
        this.setTameableFlag(4, tamed);
    }
}

