/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.DisguiseListener;
import me.libraryaddict.disguise.commands.LibsDisguisesCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseEntityCommand;
import me.libraryaddict.disguise.commands.disguise.DisguisePlayerCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseRadiusCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyEntityCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyPlayerCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyRadiusCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguiseCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguiseEntityCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguisePlayerCommand;
import me.libraryaddict.disguise.commands.undisguise.UndisguiseRadiusCommand;
import me.libraryaddict.disguise.commands.utils.CopyDisguiseCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseCloneCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseHelpCommand;
import me.libraryaddict.disguise.commands.utils.DisguiseViewSelfCommand;
import me.libraryaddict.disguise.commands.utils.GrabSkinCommand;
import me.libraryaddict.disguise.commands.utils.SaveDisguiseCommand;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.metrics.MetricsInitalizer;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.asm.WatcherSanitizer;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LibsDisguises
extends JavaPlugin {
    private static LibsDisguises instance;
    private DisguiseListener listener;
    private String buildNumber;
    private boolean reloaded;

    public void onLoad() {
        instance = this;
        if (!Bukkit.getServer().getWorlds().isEmpty()) {
            this.reloaded = true;
            this.getLogger().severe("Lib's Disguises was reloaded! Please do not report any bugs! This plugin can't handle reloads gracefully!");
            return;
        }
        WatcherSanitizer.init();
    }

    public void onEnable() {
        if (this.reloaded) {
            this.getLogger().severe("Lib's Disguises was reloaded! Please do not report any bugs! This plugin can't handle reloads gracefully!");
        }
        if (!new File(this.getDataFolder(), "disguises.yml").exists()) {
            this.saveResource("disguises.yml", false);
        }
        YamlConfiguration pluginYml = ReflectionManager.getPluginYaml(this.getClassLoader());
        this.buildNumber = StringUtils.stripToNull((String)pluginYml.getString("build-number"));
        this.getLogger().info("Discovered nms version: " + ReflectionManager.getBukkitVersion());
        this.getLogger().info("Jenkins Build: " + (this.isNumberedBuild() ? "#" : "") + this.getBuildNo());
        this.getLogger().info("Build Date: " + pluginYml.getString("build-date"));
        LibsPremium.check(this.getDescription().getVersion(), this.getFile());
        if (!LibsPremium.isPremium().booleanValue()) {
            this.getLogger().info("You are running the free version, commands limited to non-players and operators. (Console, Command Blocks, Admins)");
        }
        if (ReflectionManager.getVersion() == null) {
            this.getLogger().severe("You're using the wrong version of Lib's Disguises for your server! This is intended for " + StringUtils.join((Collection)Arrays.stream(NmsVersion.values()).map(v -> v.name().replace("_", ".")).collect(Collectors.toList()), (String)" & ") + "!");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        ReflectionManager.init();
        PacketsManager.init();
        DisguiseUtilities.init();
        ReflectionManager.registerValues();
        DisguiseConfig.loadConfig();
        DisguiseParser.createDefaultMethods();
        PacketsManager.addPacketListeners();
        this.listener = new DisguiseListener(this);
        this.registerCommand("libsdisguises", new LibsDisguisesCommand());
        if (!DisguiseConfig.isDisableCommands()) {
            this.registerCommand("disguise", new DisguiseCommand());
            this.registerCommand("undisguise", new UndisguiseCommand());
            this.registerCommand("disguiseplayer", new DisguisePlayerCommand());
            this.registerCommand("undisguiseplayer", new UndisguisePlayerCommand());
            this.registerCommand("undisguiseentity", new UndisguiseEntityCommand());
            this.registerCommand("disguiseentity", new DisguiseEntityCommand());
            this.registerCommand("disguiseradius", new DisguiseRadiusCommand(this.getConfig().getInt("DisguiseRadiusMax")));
            this.registerCommand("undisguiseradius", new UndisguiseRadiusCommand(this.getConfig().getInt("UndisguiseRadiusMax")));
            this.registerCommand("disguisehelp", new DisguiseHelpCommand());
            this.registerCommand("disguiseclone", new DisguiseCloneCommand());
            this.registerCommand("disguiseviewself", new DisguiseViewSelfCommand());
            this.registerCommand("disguisemodify", new DisguiseModifyCommand());
            this.registerCommand("disguisemodifyentity", new DisguiseModifyEntityCommand());
            this.registerCommand("disguisemodifyplayer", new DisguiseModifyPlayerCommand());
            this.registerCommand("disguisemodifyradius", new DisguiseModifyRadiusCommand(this.getConfig().getInt("DisguiseRadiusMax")));
            this.registerCommand("copydisguise", new CopyDisguiseCommand());
            this.registerCommand("grabskin", new GrabSkinCommand());
            this.registerCommand("savedisguise", new SaveDisguiseCommand());
        } else {
            this.getLogger().info("Commands has been disabled, as per config");
        }
        new MetricsInitalizer();
    }

    public void onDisable() {
        DisguiseUtilities.saveDisguises();
        for (Player player : Bukkit.getOnlinePlayers()) {
            DisguiseUtilities.removeSelfDisguiseScoreboard(player);
        }
    }

    public boolean isReleaseBuild() {
        return !this.getDescription().getVersion().contains("-SNAPSHOT");
    }

    public String getBuildNo() {
        return this.buildNumber;
    }

    public boolean isNumberedBuild() {
        return this.getBuildNo() != null && this.getBuildNo().matches("[0-9]+");
    }

    private void registerCommand(String commandName, CommandExecutor executioner) {
        PluginCommand command = this.getCommand(commandName);
        command.setExecutor(executioner);
        if (executioner instanceof TabCompleter) {
            command.setTabCompleter((TabCompleter)executioner);
        }
    }

    @Deprecated
    public void reload() {
        DisguiseConfig.loadConfig();
    }

    public DisguiseListener getListener() {
        return this.listener;
    }

    public static LibsDisguises getInstance() {
        return instance;
    }
}

