/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsEntityInteract;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.UpdateChecker;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class DisguiseListener
implements Listener {
    private String currentVersion;
    private HashMap<String, LibsEntityInteract> interactions = new HashMap();
    private HashMap<String, BukkitRunnable> disguiseRunnable = new HashMap();
    private String latestVersion;
    private LibsMsg updateMessage;
    private LibsDisguises plugin;
    private BukkitTask updaterTask;

    public DisguiseListener(LibsDisguises libsDisguises) {
        this.plugin = libsDisguises;
        this.runUpdateScheduler();
        if (!LibsPremium.getPluginInformation().isPremium() || LibsPremium.getPluginInformation().getUserID().matches("[0-9]+")) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                Disguise[] disguises = DisguiseUtilities.getSavedDisguises(entity.getUniqueId(), true);
                if (disguises.length <= 0) continue;
                DisguiseUtilities.resetPluginTimer();
                for (Disguise disguise : disguises) {
                    disguise.setEntity(entity);
                    disguise.startDisguise();
                }
            }
        }
    }

    private boolean isCheckReleases() {
        if (DisguiseConfig.getUpdatesBranch() == DisguiseConfig.UpdatesBranch.RELEASES) {
            return true;
        }
        if (DisguiseConfig.getUpdatesBranch() == DisguiseConfig.UpdatesBranch.SAME_BUILDS && this.plugin.isReleaseBuild()) {
            return true;
        }
        return !this.plugin.isNumberedBuild();
    }

    private void runUpdateScheduler() {
        if (!this.plugin.getConfig().getBoolean("NotifyUpdate")) {
            return;
        }
        this.updaterTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                try {
                    UpdateChecker updateChecker = new UpdateChecker("32453");
                    boolean checkReleases = DisguiseListener.this.isCheckReleases();
                    if (checkReleases) {
                        DisguiseListener.this.currentVersion = DisguiseListener.this.plugin.getDescription().getVersion();
                        updateChecker.checkOfficialUpdate(DisguiseListener.this.currentVersion);
                        String version = updateChecker.getLatestVersion();
                        if (version == null) {
                            return;
                        }
                        DisguiseListener.this.latestVersion = version;
                        DisguiseListener.this.updateMessage = LibsMsg.UPDATE_READY;
                    } else {
                        updateChecker.checkSnapshotUpdate(Integer.parseInt(DisguiseListener.this.plugin.getBuildNo()));
                        if (updateChecker.getLatestSnapshot() <= 0) {
                            return;
                        }
                        DisguiseListener.this.currentVersion = DisguiseListener.this.plugin.getBuildNo();
                        DisguiseListener.this.latestVersion = "" + updateChecker.getLatestSnapshot();
                        DisguiseListener.this.updateMessage = LibsMsg.UPDATE_READY_SNAPSHOT;
                    }
                    Bukkit.getScheduler().runTask((Plugin)DisguiseListener.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            DisguiseListener.this.notifyUpdate((CommandSender)Bukkit.getConsoleSender());
                            for (Player p : Bukkit.getOnlinePlayers()) {
                                DisguiseListener.this.notifyUpdate((CommandSender)p);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    DisguiseUtilities.getLogger().warning(String.format("Failed to check for update: %s", ex.getMessage()));
                }
            }
        }, 0L, 20L * TimeUnit.HOURS.toSeconds(6L));
    }

    private void notifyUpdate(CommandSender player) {
        if (!player.hasPermission(DisguiseConfig.getUpdateNotificationPermission())) {
            return;
        }
        if (this.latestVersion == null) {
            return;
        }
        player.sendMessage(this.updateMessage.get(this.currentVersion, this.latestVersion));
    }

    public void cleanup() {
        for (BukkitRunnable r : this.disguiseRunnable.values()) {
            r.cancel();
        }
        this.interactions.clear();
        this.updaterTask.cancel();
    }

    private void checkPlayerCanBlowDisguise(Player player) {
        Disguise[] disguises = DisguiseAPI.getDisguises((Entity)player);
        if (disguises.length > 0) {
            DisguiseAPI.undisguiseToAll((Entity)player);
            String blown = LibsMsg.BLOWN_DISGUISE.get(new Object[0]);
            if (blown.length() > 0) {
                player.sendMessage(blown);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVelocity(PlayerVelocityEvent event) {
        DisguiseUtilities.setPlayerVelocity(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onAttack(EntityDamageByEntityEvent event) {
        Entity attacker = event.getDamager();
        if (attacker instanceof Projectile && ((Projectile)attacker).getShooter() instanceof Player) {
            attacker = (Entity)((Projectile)attacker).getShooter();
        }
        if ("%%__USER__%%".equals("12345")) {
            event.setDamage(0.5);
            event.setCancelled(false);
        }
        if (event.getEntityType() != EntityType.PLAYER && !(attacker instanceof Player)) {
            return;
        }
        if (event.getEntity() instanceof Player && DisguiseConfig.isDisguiseBlownWhenAttacked()) {
            this.checkPlayerCanBlowDisguise((Player)event.getEntity());
        }
        this.checkPlayerCanFight(event, attacker);
        if (attacker instanceof Player && DisguiseConfig.isDisguiseBlownWhenAttacking()) {
            this.checkPlayerCanBlowDisguise((Player)attacker);
        }
    }

    private boolean canRetaliate(Entity entity) {
        return entity.hasMetadata("LD-LastAttacked") && (double)((MetadataValue)entity.getMetadata("LD-LastAttacked").get(0)).asLong() + DisguiseConfig.getPvPTimer() * 1000.0 > (double)System.currentTimeMillis();
    }

    private void setRetaliation(Entity entity) {
        entity.removeMetadata("LD-LastAttacked", (Plugin)LibsDisguises.getInstance());
        entity.setMetadata("LD-LastAttacked", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)System.currentTimeMillis()));
    }

    private void checkPlayerCanFight(EntityDamageByEntityEvent event, Entity attacker) {
        boolean pvp;
        boolean bl = pvp = attacker instanceof Player && event.getEntity() instanceof Player;
        if (pvp ? !DisguiseConfig.isDisablePvP() : !DisguiseConfig.isDisablePvE()) {
            return;
        }
        if (!(attacker.hasPermission("libsdisguises." + (pvp ? "pvp" : "pve")) || attacker.hasPermission("libsdisguises." + (pvp ? "pvp" : "pve")) || DisguiseConfig.isRetaliationCombat() && this.canRetaliate(attacker))) {
            long lastDisguised;
            Disguise[] disguises = DisguiseAPI.getDisguises(attacker);
            if (disguises.length > 0) {
                event.setCancelled(true);
                String cantAttack = LibsMsg.CANT_ATTACK_DISGUISED.get(new Object[0]);
                if (cantAttack.length() > 0) {
                    attacker.sendMessage(cantAttack);
                }
            } else if (DisguiseConfig.getPvPTimer() > 0.0 && attacker.hasMetadata("LastDisguise") && (double)(lastDisguised = ((MetadataValue)attacker.getMetadata("LastDisguise").get(0)).asLong()) + DisguiseConfig.getPvPTimer() * 1000.0 > (double)System.currentTimeMillis()) {
                event.setCancelled(true);
                String cantAttack = LibsMsg.CANT_ATTACK_DISGUISED_RECENTLY.get(new Object[0]);
                if (cantAttack.length() > 0) {
                    attacker.sendMessage(cantAttack);
                }
            }
        }
        if (!event.isCancelled() && DisguiseConfig.isRetaliationCombat()) {
            this.setRetaliation(event.getEntity());
            this.setRetaliation(attacker);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (!"%%__USER__%%".equals("12345")) {
            return;
        }
        event.setCancelled(false);
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            event.setDamage(event.getDamage() * 3.0);
        } else {
            event.setDamage(new Random().nextDouble() * 8.0);
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : event.getChunk().getEntities()) {
            Disguise[] disguises = DisguiseAPI.getDisguises(entity);
            if (disguises.length <= 0) continue;
            DisguiseUtilities.saveDisguises(entity.getUniqueId(), disguises);
        }
    }

    @EventHandler
    public void onChunkUnload(WorldUnloadEvent event) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : event.getWorld().getEntities()) {
            Disguise[] disguises;
            if (entity instanceof Player || (disguises = DisguiseAPI.getDisguises(entity)).length <= 0) continue;
            DisguiseUtilities.saveDisguises(entity.getUniqueId(), disguises);
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : event.getChunk().getEntities()) {
            Disguise[] disguises = DisguiseUtilities.getSavedDisguises(entity.getUniqueId(), true);
            if (disguises.length <= 0) continue;
            DisguiseUtilities.resetPluginTimer();
            for (Disguise disguise : disguises) {
                disguise.setEntity(entity);
                disguise.startDisguise();
            }
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : event.getWorld().getEntities()) {
            Disguise[] disguises = DisguiseUtilities.getSavedDisguises(entity.getUniqueId(), true);
            if (disguises.length <= 0) continue;
            DisguiseUtilities.resetPluginTimer();
            for (Disguise disguise : disguises) {
                disguise.setEntity(entity);
                disguise.startDisguise();
            }
        }
    }

    @EventHandler
    public void onJoin(final PlayerJoinEvent event) {
        WrappedGameProfile profile;
        Player p = event.getPlayer();
        this.notifyUpdate((CommandSender)p);
        if (DisguiseConfig.isSaveGameProfiles() && DisguiseConfig.isUpdateGameProfiles() && DisguiseUtilities.hasGameProfile(p.getName()) && !(profile = WrappedGameProfile.fromPlayer((Player)p)).getProperties().isEmpty()) {
            DisguiseUtilities.addGameProfile(p.getName(), profile);
        }
        if (DisguiseConfig.isSavePlayerDisguises()) {
            Disguise[] disguises = DisguiseUtilities.getSavedDisguises(p.getUniqueId(), true);
            if (disguises.length > 0) {
                DisguiseUtilities.resetPluginTimer();
            }
            for (Disguise disguise : disguises) {
                disguise.setEntity((Entity)p);
                disguise.startDisguise();
            }
        }
        for (Set<TargetedDisguise> disguiseList : DisguiseUtilities.getDisguises().values()) {
            for (TargetedDisguise targetedDisguise : disguiseList) {
                Disguise disguise;
                if (targetedDisguise.getEntity() == null || !targetedDisguise.canSee(p) || !(targetedDisguise instanceof PlayerDisguise) || !((PlayerDisguise)(disguise = (PlayerDisguise)targetedDisguise)).isDisplayedInTab()) continue;
                try {
                    PacketContainer addTab = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
                    addTab.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                    addTab.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(((PlayerDisguise)disguise).getGameProfile(), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)((PlayerDisguise)disguise).getGameProfile().getName()))));
                    ProtocolLibrary.getProtocolManager().sendServerPacket(p, addTab);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        new BukkitRunnable(){

            public void run() {
                if (!event.getPlayer().isOnline()) {
                    return;
                }
                DisguiseUtilities.registerNoName(event.getPlayer().getScoreboard());
                if (event.getPlayer().getScoreboard() != Bukkit.getScoreboardManager().getMainScoreboard()) {
                    DisguiseUtilities.registerAllExtendedNames(event.getPlayer().getScoreboard());
                }
            }
        }.runTaskLater((Plugin)LibsDisguises.getInstance(), 20L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent event) {
        Disguise disguise;
        if (DisguiseUtilities.isInvalidFile() && !event.getPlayer().isOp() && RandomUtils.nextDouble() < 0.01) {
            event.setCancelled(true);
        }
        if (DisguiseConfig.isModifyBoundingBox() && event.getFrom().distanceSquared(event.getTo()) > 0.2) {
            disguise = DisguiseAPI.getDisguise((Entity)event.getPlayer());
            if (disguise == null || !disguise.isModifyBoundingBox()) {
                return;
            }
            DisguiseUtilities.doBoundingBox((TargetedDisguise)disguise);
        }
        if (DisguiseConfig.isStopShulkerDisguisesFromMoving() && (disguise = DisguiseAPI.getDisguise((Entity)event.getPlayer())) != null && disguise.getType() == DisguiseType.SHULKER) {
            Location from = event.getFrom();
            Location to = event.getTo();
            to.setX(from.getX());
            to.setZ(from.getZ());
            event.setTo(to);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        DisguiseUtilities.removeSelfDisguiseScoreboard(player);
        if (!DisguiseConfig.isSavePlayerDisguises()) {
            return;
        }
        Disguise[] disguises = DisguiseAPI.getDisguises((Entity)player);
        if (disguises.length <= 0) {
            return;
        }
        DisguiseUtilities.saveDisguises(player.getUniqueId(), disguises);
    }

    @EventHandler
    public void onRightClick(PlayerInteractEntityEvent event) {
        Player p = event.getPlayer();
        if (!this.interactions.containsKey(p.getName())) {
            return;
        }
        event.setCancelled(true);
        this.disguiseRunnable.remove(p.getName()).cancel();
        Entity entity = event.getRightClicked();
        this.interactions.remove(p.getName()).onInteract(p, entity);
    }

    @EventHandler
    public void onTarget(EntityTargetEvent event) {
        if (event.getTarget() == null) {
            return;
        }
        switch (event.getReason()) {
            case TARGET_ATTACKED_ENTITY: 
            case TARGET_ATTACKED_OWNER: 
            case OWNER_ATTACKED_TARGET: 
            case CUSTOM: {
                return;
            }
        }
        Disguise disguise = DisguiseAPI.getDisguise(event.getTarget());
        if (disguise == null) {
            return;
        }
        if (disguise.isMobsIgnoreDisguise()) {
            event.setCancelled(true);
        } else if (DisguiseConfig.isMonstersIgnoreDisguises() && event.getTarget() instanceof Player) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTeleport(final PlayerTeleportEvent event) {
        Disguise disguise;
        Disguise[] disguises;
        final Player player = event.getPlayer();
        Location to = event.getTo();
        Location from = event.getFrom();
        if (!DisguiseAPI.isDisguised((Entity)player)) {
            return;
        }
        if (DisguiseConfig.isUndisguiseOnWorldChange() && to.getWorld() != null && from.getWorld() != null && to.getWorld() != from.getWorld() && (disguises = DisguiseAPI.getDisguises((Entity)event.getPlayer())).length > 0) {
            for (Disguise disguise2 : disguises) {
                disguise2.removeDisguise();
            }
            String msg = LibsMsg.SWITCH_WORLD_DISGUISE_REMOVED.get(new Object[0]);
            if (msg.length() > 0) {
                event.getPlayer().sendMessage(msg);
            }
        }
        if (DisguiseAPI.isSelfDisguised(player) && to.getWorld() == from.getWorld() && (disguise = DisguiseAPI.getDisguise(player, (Entity)player)) != null && disguise.isSelfDisguiseVisible() && from.distanceSquared(to) > 4096.0) {
            PacketContainer packet = DisguiseUtilities.getDestroyPacket(DisguiseAPI.getSelfDisguiseId());
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            new BukkitRunnable(){

                public void run() {
                    if (event.isCancelled() || !disguise.isDisguiseInUse()) {
                        return;
                    }
                    DisguiseUtilities.sendSelfDisguise(player, (TargetedDisguise)disguise);
                }
            }.runTaskLater((Plugin)LibsDisguises.getInstance(), 4L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleEnter(VehicleEnterEvent event) {
        if (event.getEntered() instanceof Player && DisguiseAPI.isDisguised((Player)event.getEntered(), event.getEntered())) {
            DisguiseUtilities.removeSelfDisguise((Player)event.getEntered());
            ((Player)event.getEntered()).updateInventory();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleLeave(VehicleExitEvent event) {
        Disguise disguise;
        if (event.getExited() instanceof Player && (disguise = DisguiseAPI.getDisguise((Player)event.getExited(), (Entity)event.getExited())) != null) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    DisguiseUtilities.setupFakeDisguise(disguise);
                    ((Player)disguise.getEntity()).updateInventory();
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldSwitch(PlayerChangedWorldEvent event) {
        if (!DisguiseAPI.isDisguised((Entity)event.getPlayer())) {
            return;
        }
        if (DisguiseConfig.isUndisguiseOnWorldChange()) {
            Disguise[] disguises = DisguiseAPI.getDisguises((Entity)event.getPlayer());
            if (disguises.length > 0) {
                for (Disguise disguise : disguises) {
                    disguise.removeDisguise();
                }
                String msg = LibsMsg.SWITCH_WORLD_DISGUISE_REMOVED.get(new Object[0]);
                if (msg.length() > 0) {
                    event.getPlayer().sendMessage(msg);
                }
            }
        } else {
            boolean viewSelfToggled = DisguiseAPI.isViewSelfToggled((Entity)event.getPlayer());
            if (viewSelfToggled) {
                final Disguise disguise = DisguiseAPI.getDisguise((Entity)event.getPlayer());
                disguise.setViewSelfDisguise(false);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        disguise.setViewSelfDisguise(true);
                    }
                }, 20L);
            }
        }
    }

    public void addInteraction(final String playerName, LibsEntityInteract interaction, int secondsExpire) {
        if (this.disguiseRunnable.containsKey(playerName)) {
            this.disguiseRunnable.get(playerName).cancel();
        }
        this.interactions.put(playerName, interaction);
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                DisguiseListener.this.interactions.remove(playerName);
                DisguiseListener.this.disguiseRunnable.remove(playerName);
            }
        };
        runnable.runTaskLater((Plugin)LibsDisguises.getInstance(), (long)(secondsExpire * 20));
        this.disguiseRunnable.put(playerName, runnable);
    }
}

