/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class DisguiseConfig {
    private static DisguisePushing pushingOption = DisguisePushing.MODIFY_SCOREBOARD;
    private static HashMap<DisguisePerm, String> customDisguises = new HashMap();
    private static String updateNotificationPermission;
    private static UpdatesBranch updatesBranch;
    private static boolean addEntityAnimations;
    private static boolean animationPacketsEnabled;
    private static boolean catDyeable;
    private static boolean collectPacketsEnabled;
    private static boolean disableCommands;
    private static boolean disableFriendlyInvisibles;
    private static boolean disabledInvisibility;
    private static boolean disguiseBlownWhenAttacked;
    private static boolean disguiseBlownWhenAttacking;
    private static boolean dynamicExpiry;
    private static boolean entityStatusPacketsEnabled;
    private static boolean equipmentPacketsEnabled;
    private static boolean explicitDisguisePermissions;
    private static boolean extendedDisguiseNames;
    private static boolean hideDisguisedPlayers;
    private static boolean hidingArmorFromSelf;
    private static boolean hidingHeldItemFromSelf;
    private static boolean horseSaddleable;
    private static boolean keepDisguiseOnPlayerDeath;
    private static boolean llamaCarpetable;
    private static boolean maxHealthDeterminedByDisguisedEntity;
    private static boolean metaPacketsEnabled;
    private static boolean miscDisguisesForLivingEnabled;
    private static boolean modifyBoundingBox;
    private static boolean modifyCollisions;
    private static boolean monstersIgnoreDisguises;
    private static boolean movementPacketsEnabled;
    private static boolean nameAboveHeadAlwaysVisible;
    private static boolean nameOfPlayerShownAboveDisguise;
    private static boolean playerHideArmor;
    private static boolean saveEntityDisguises;
    private static boolean saveGameProfiles;
    private static boolean savePlayerDisguises;
    private static boolean selfDisguisesSoundsReplaced;
    private static boolean sheepDyeable;
    private static boolean showDisguisedPlayersInTab;
    private static boolean stopShulkerDisguisesFromMoving;
    private static boolean undisguiseOnWorldChange;
    private static boolean updateGameProfiles;
    private static boolean useTranslations;
    private static boolean velocitySent;
    private static boolean viewDisguises;
    private static boolean warnScoreboardConflict;
    private static boolean witherSkullPacketsEnabled;
    private static boolean wolfDyeable;
    private static int disguiseCloneExpire;
    private static int disguiseEntityExpire;
    private static int maxClonedDisguises;
    private static int playerDisguisesTablistExpires;
    private static int uuidGeneratedVersion;
    private static boolean disablePvP;
    private static boolean disablePvE;
    private static double pvPTimer;
    private static boolean retaliationCombat;
    private static NotifyBar notifyBar;
    private static BarStyle bossBarStyle;
    private static BarColor bossBarColor;
    private static PermissionDefault commandVisibility;
    private static boolean scoreboardDisguiseNames;

    public static PermissionDefault getCommandVisibility() {
        return commandVisibility;
    }

    public static void setCommandVisibility(PermissionDefault permissionDefault) {
        if (permissionDefault == null || DisguiseConfig.getCommandVisibility() == permissionDefault) {
            return;
        }
        commandVisibility = permissionDefault;
        for (Permission perm : LibsDisguises.getInstance().getDescription().getPermissions()) {
            if (!perm.getName().startsWith("libsdisguises.seecmd")) continue;
            perm.setDefault(DisguiseConfig.getCommandVisibility());
        }
    }

    private DisguiseConfig() {
    }

    public static int getUUIDGeneratedVersion() {
        return uuidGeneratedVersion;
    }

    public static void setUUIDGeneratedVersion(int uuidVersion) {
        uuidGeneratedVersion = uuidVersion;
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(String disguise) {
        Map.Entry<DisguisePerm, String> entry;
        if (!Bukkit.isPrimaryThread()) {
            DisguiseUtilities.getLogger().warning("Custom Disguises should not be called async! This operation will become impossible in the future!");
        }
        if ((entry = DisguiseConfig.getRawCustomDisguise(disguise)) == null) {
            return null;
        }
        try {
            return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise(entry.getValue()));
        }
        catch (IllegalAccessException | InvocationTargetException | DisguiseParseException e) {
            DisguiseUtilities.getLogger().warning("Error when attempting to grab the custom disguise " + disguise);
            e.printStackTrace();
            return null;
        }
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(Entity target, String disguise) throws IllegalAccessException, DisguiseParseException, InvocationTargetException {
        Map.Entry<DisguisePerm, String> entry;
        if (!Bukkit.isPrimaryThread()) {
            DisguiseUtilities.getLogger().warning("Custom Disguises should not be called async! This operation will become impossible in the future!");
        }
        if ((entry = DisguiseConfig.getRawCustomDisguise(disguise)) == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise((CommandSender)Bukkit.getConsoleSender(), target, entry.getValue()));
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(CommandSender invoker, Entity target, String disguise) throws IllegalAccessException, DisguiseParseException, InvocationTargetException {
        Map.Entry<DisguisePerm, String> entry;
        if (!Bukkit.isPrimaryThread()) {
            DisguiseUtilities.getLogger().warning("Custom Disguises should not be called async! This operation will become impossible in the future!");
        }
        if ((entry = DisguiseConfig.getRawCustomDisguise(disguise)) == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise(invoker, target, entry.getValue()));
    }

    public static void removeCustomDisguise(String disguise) {
        for (DisguisePerm entry : customDisguises.keySet()) {
            String name = entry.toReadable();
            if (!name.equalsIgnoreCase(disguise) && !name.replaceAll("_", "").equalsIgnoreCase(disguise)) continue;
            customDisguises.remove(entry);
            break;
        }
    }

    public static Map.Entry<DisguisePerm, String> getRawCustomDisguise(String disguise) {
        for (Map.Entry<DisguisePerm, String> entry : customDisguises.entrySet()) {
            String name = entry.getKey().toReadable();
            if (!name.equalsIgnoreCase(disguise) && !name.replaceAll("_", "").equalsIgnoreCase(disguise)) continue;
            return entry;
        }
        return null;
    }

    public static void setUseTranslations(boolean setUseTranslations) {
        useTranslations = setUseTranslations;
        TranslateType.refreshTranslations();
    }

    public static void loadConfig() {
        ArrayList<String> returns;
        boolean verbose;
        LibsDisguises.getInstance().saveDefaultConfig();
        LibsDisguises.getInstance().reloadConfig();
        File skinsFolder = new File(LibsDisguises.getInstance().getDataFolder(), "Skins");
        if (!skinsFolder.exists()) {
            skinsFolder.mkdir();
            File explain = new File(skinsFolder, "README");
            try {
                explain.createNewFile();
                try (PrintWriter out = new PrintWriter(explain);){
                    out.println("This folder is used to store .png files for uploading with the /savedisguise or /grabskin commands");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfiguration config = LibsDisguises.getInstance().getConfig();
        PacketsManager.setViewDisguisesListener(true);
        disableCommands = config.getBoolean("DisableCommands");
        DisguiseConfig.setAddEntityAnimations(config.getBoolean("AddEntityAnimations"));
        DisguiseConfig.setAnimationPacketsEnabled(config.getBoolean("PacketsEnabled.Animation"));
        DisguiseConfig.setCatDyeable(config.getBoolean("DyeableCat"));
        DisguiseConfig.setCollectPacketsEnabled(config.getBoolean("PacketsEnabled.Collect"));
        DisguiseConfig.setDisableFriendlyInvisibles(config.getBoolean("Scoreboard.DisableFriendlyInvisibles"));
        DisguiseConfig.setDisabledInvisibility(config.getBoolean("DisableInvisibility"));
        DisguiseConfig.setDisablePvP(config.getBoolean("DisablePvP"));
        DisguiseConfig.setDisablePvE(config.getBoolean("DisablePvE"));
        DisguiseConfig.setPvPTimer(config.getDouble("PvPTimer"));
        DisguiseConfig.setDisguiseBlownWhenAttacked(config.getBoolean("BlowDisguises", config.getBoolean("BlowDisguisesWhenAttacked")));
        DisguiseConfig.setDisguiseBlownWhenAttacking(config.getBoolean("BlowDisguises", config.getBoolean("BlowDisguisesWhenAttacking")));
        DisguiseConfig.setDisguiseCloneExpire(config.getInt("DisguiseCloneExpire"));
        DisguiseConfig.setDisguiseEntityExpire(config.getInt("DisguiseEntityExpire"));
        DisguiseConfig.setDynamicExpiry(config.getBoolean("DynamicExpiry"));
        DisguiseConfig.setEntityStatusPacketsEnabled(config.getBoolean("PacketsEnabled.EntityStatus"));
        DisguiseConfig.setEquipmentPacketsEnabled(config.getBoolean("PacketsEnabled.Equipment"));
        DisguiseConfig.setExplicitDisguisePermissions(config.getBoolean("Permissions.ExplicitDisguises"));
        DisguiseConfig.setExtendedDisguiseNames(config.contains("ScoreboardNames") && config.getBoolean("ExtendedNames"));
        DisguiseConfig.setHideArmorFromSelf(config.getBoolean("RemoveArmor"));
        DisguiseConfig.setHideDisguisedPlayers(config.getBoolean("HideDisguisedPlayersFromTab"));
        DisguiseConfig.setHideHeldItemFromSelf(config.getBoolean("RemoveHeldItem"));
        DisguiseConfig.setHorseSaddleable(config.getBoolean("SaddleableHorse"));
        DisguiseConfig.setKeepDisguiseOnPlayerDeath(config.getBoolean("KeepDisguises.PlayerDeath"));
        DisguiseConfig.setLlamaCarpetable(config.getBoolean("CarpetableLlama"));
        DisguiseConfig.setMaxClonedDisguises(config.getInt("DisguiseCloneSize"));
        DisguiseConfig.setMaxHealthDeterminedByDisguisedEntity(config.getBoolean("MaxHealthDeterminedByEntity"));
        DisguiseConfig.setMetaPacketsEnabled(config.getBoolean("PacketsEnabled.Metadata"));
        DisguiseConfig.setMiscDisguisesForLivingEnabled(config.getBoolean("MiscDisguisesForLiving"));
        DisguiseConfig.setModifyBoundingBox(config.getBoolean("ModifyBoundingBox"));
        DisguiseConfig.setModifyCollisions(config.getBoolean("Scoreboard.Collisions"));
        DisguiseConfig.setMonstersIgnoreDisguises(config.getBoolean("MonstersIgnoreDisguises"));
        DisguiseConfig.setMovementPacketsEnabled(config.getBoolean("PacketsEnabled.Movement"));
        DisguiseConfig.setNameAboveHeadAlwaysVisible(config.getBoolean("NameAboveHeadAlwaysVisible"));
        DisguiseConfig.setNameOfPlayerShownAboveDisguise(config.getBoolean("ShowNamesAboveDisguises"));
        DisguiseConfig.setPlayerDisguisesTablistExpires(config.getInt("PlayerDisguisesTablistExpires"));
        DisguiseConfig.setPlayerHideArmor(config.getBoolean("PlayerHideArmor"));
        DisguiseConfig.setRetaliationCombat(config.getBoolean("RetaliationCombat"));
        DisguiseConfig.setSaveEntityDisguises(config.getBoolean("SaveDisguises.Entities"));
        DisguiseConfig.setSaveGameProfiles(config.getBoolean("SaveGameProfiles"));
        DisguiseConfig.setSavePlayerDisguises(config.getBoolean("SaveDisguises.Players"));
        DisguiseConfig.setSelfDisguisesSoundsReplaced(config.getBoolean("HearSelfDisguise"));
        DisguiseConfig.setSheepDyeable(config.getBoolean("DyeableSheep"));
        DisguiseConfig.setShowDisguisedPlayersInTab(config.getBoolean("ShowPlayerDisguisesInTab"));
        DisguiseConfig.setSoundsEnabled(config.getBoolean("DisguiseSounds"));
        DisguiseConfig.setStopShulkerDisguisesFromMoving(config.getBoolean("StopShulkerDisguisesFromMoving", true));
        DisguiseConfig.setUUIDGeneratedVersion(config.getInt("UUIDVersion"));
        DisguiseConfig.setUndisguiseOnWorldChange(config.getBoolean("UndisguiseOnWorldChange"));
        DisguiseConfig.setUpdateGameProfiles(config.getBoolean("UpdateGameProfiles"));
        DisguiseConfig.setUpdateNotificationPermission(config.getString("Permission"));
        DisguiseConfig.setUseTranslations(config.getBoolean("Translations"));
        DisguiseConfig.setVelocitySent(config.getBoolean("SendVelocity"));
        DisguiseConfig.setViewDisguises(config.getBoolean("ViewSelfDisguises"));
        DisguiseConfig.setWarnScoreboardConflict(config.getBoolean("Scoreboard.WarnConflict"));
        DisguiseConfig.setWitherSkullPacketsEnabled(config.getBoolean("PacketsEnabled.WitherSkull"));
        DisguiseConfig.setWolfDyeable(config.getBoolean("DyeableWolf"));
        DisguiseConfig.setScoreboardDisguiseNames(config.getBoolean("ScoreboardNames"));
        if (!LibsPremium.isPremium().booleanValue() && (DisguiseConfig.isSavePlayerDisguises() || DisguiseConfig.isSaveEntityDisguises())) {
            DisguiseUtilities.getLogger().warning("You must purchase the plugin to use saved disguises!");
        }
        try {
            DisguiseConfig.setNotifyBar(NotifyBar.valueOf(config.getString("NotifyBar").toUpperCase()));
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + config.getString("NotifyBar") + "' to a valid option for NotifyBar");
        }
        try {
            DisguiseConfig.setBossBarColor(BarColor.valueOf((String)config.getString("BossBarColor").toUpperCase()));
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + config.getString("BossBarColor") + "' to a valid option for BossBarColor");
        }
        try {
            DisguiseConfig.setBossBarStyle(BarStyle.valueOf((String)config.getString("BossBarStyle").toUpperCase()));
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + config.getString("BossBarStyle") + "' to a valid option for BossBarStyle");
        }
        try {
            DisguiseConfig.setUpdatesBranch(UpdatesBranch.valueOf(config.getString("UpdatesBranch").toUpperCase()));
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + config.getString("UpdatesBranch") + "' to a valid option for UpdatesBranch");
        }
        try {
            String option = config.getString("SelfDisguisesScoreboard", DisguisePushing.MODIFY_SCOREBOARD.name()).toUpperCase();
            if (!option.endsWith("_SCOREBOARD")) {
                option = option + "_SCOREBOARD";
            }
            pushingOption = DisguisePushing.valueOf(option);
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + config.getString("SelfDisguisesScoreboard") + "' to a valid option for SelfDisguisesScoreboard");
        }
        PermissionDefault commandVisibility = PermissionDefault.getByName((String)config.getString("Permissions.SeeCommands"));
        if (commandVisibility == null) {
            DisguiseUtilities.getLogger().warning("Invalid option '" + config.getString("Permissions.SeeCommands") + "' for Permissions.SeeCommands when loading config!");
        } else {
            DisguiseConfig.setCommandVisibility(commandVisibility);
        }
        DisguiseConfig.loadCustomDisguises();
        if ("%%__USER__%%".equals("12345") && DisguiseConfig.getCustomDisguises().size() > 10) {
            DisguiseConfig.setSoundsEnabled(false);
            Iterator<Map.Entry<DisguisePerm, String>> itel = DisguiseConfig.getCustomDisguises().entrySet().iterator();
            boolean i = false;
            while (itel.hasNext()) {
                itel.next();
                if (!new Random().nextBoolean()) continue;
                itel.remove();
            }
        }
        if (config.contains("VerboseConfig")) {
            verbose = config.getBoolean("VerboseConfig");
        } else {
            DisguiseUtilities.getLogger().info("As 'VerboseConfig' hasn't been set, it is assumed true. Set it in your config to remove these messages!");
            verbose = true;
        }
        boolean changed = config.getBoolean("ChangedConfig");
        if (!verbose) {
            int missingConfigs = 0;
            for (String key : config.getDefaultSection().getKeys(true)) {
                if (config.contains(key, true)) continue;
                ++missingConfigs;
            }
            if (missingConfigs > 0) {
                DisguiseUtilities.getLogger().warning("Your config is missing " + missingConfigs + " options! Please consider regenerating your config!");
            }
        }
        if ((verbose || changed) && !(returns = DisguiseConfig.doOutput((ConfigurationSection)config, changed, verbose)).isEmpty()) {
            DisguiseUtilities.getLogger().info("This is not an error! Now outputting " + (verbose ? "missing " : "") + (changed ? (verbose ? "and " : "") + "changed/invalid " : "") + "config values");
            for (String v : returns) {
                DisguiseUtilities.getLogger().info(v);
            }
        }
    }

    public static ArrayList<String> doOutput(ConfigurationSection config, boolean informChangedUnknown, boolean informMissing) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        ConfigurationSection defaultSection = config.getDefaultSection();
        ArrayList<String> returns = new ArrayList<String>();
        for (String string : defaultSection.getKeys(true)) {
            if (defaultSection.isConfigurationSection(string)) continue;
            configs.put(string, defaultSection.get(string));
        }
        for (String string : config.getKeys(true)) {
            if (config.isConfigurationSection(string)) continue;
            if (!configs.containsKey(string)) {
                if (!informChangedUnknown) continue;
                returns.add("Unknown config option '" + string + ": " + config.get(string) + "'");
                continue;
            }
            if (!configs.get(string).equals(config.get(string)) && informChangedUnknown) {
                returns.add("Modified config: '" + string + ": " + config.get(string) + "'");
            }
            configs.remove(string);
        }
        if (informMissing) {
            for (Map.Entry entry : configs.entrySet()) {
                returns.add("Missing '" + (String)entry.getKey() + ": " + entry.getValue() + "'");
            }
        }
        return returns;
    }

    static void loadCustomDisguises() {
        customDisguises.clear();
        File disguisesFile = new File("plugins/LibsDisguises/disguises.yml");
        if (!disguisesFile.exists()) {
            return;
        }
        YamlConfiguration disguisesConfig = YamlConfiguration.loadConfiguration((File)disguisesFile);
        ConfigurationSection section = disguisesConfig.getConfigurationSection("Disguises");
        if (section == null) {
            return;
        }
        int failedCustomDisguises = 0;
        for (String key : section.getKeys(false)) {
            String toParse = section.getString(key);
            if (!NmsVersion.v1_13.isSupported() && key.equals("libraryaddict")) {
                toParse = toParse.replace("GOLDEN_BOOTS,GOLDEN_LEGGINGS,GOLDEN_CHESTPLATE,GOLDEN_HELMET", "GOLD_BOOTS,GOLD_LEGGINGS,GOLD_CHESTPLATE,GOLD_HELMET");
            }
            try {
                DisguiseConfig.addCustomDisguise(key, toParse);
            }
            catch (DisguiseParseException e) {
                ++failedCustomDisguises;
                if (e.getMessage() != null) {
                    DisguiseUtilities.getLogger().severe(e.getMessage());
                }
                if (e.getCause() == null) continue;
                e.printStackTrace();
            }
        }
        if (failedCustomDisguises > 0) {
            DisguiseUtilities.getLogger().severe("Failed to load " + failedCustomDisguises + " custom disguises");
        }
        DisguiseUtilities.getLogger().info("Loaded " + customDisguises.size() + " custom disguise" + (customDisguises.size() == 1 ? "" : "s"));
    }

    public static void addCustomDisguise(String disguiseName, String toParse) throws DisguiseParseException {
        if (!Bukkit.isPrimaryThread()) {
            DisguiseUtilities.getLogger().warning("Custom Disguises should not be called async! This operation will become impossible in the future!");
        }
        if (DisguiseConfig.getRawCustomDisguise(toParse) != null) {
            throw new DisguiseParseException(LibsMsg.CUSTOM_DISGUISE_NAME_CONFLICT, disguiseName);
        }
        try {
            String[] disguiseArgs = DisguiseUtilities.split(toParse);
            Disguise disguise = DisguiseParser.parseTestDisguise((CommandSender)Bukkit.getConsoleSender(), "disguise", disguiseArgs, DisguiseParser.getPermissions((CommandSender)Bukkit.getConsoleSender(), "disguise"));
            DisguisePerm perm = new DisguisePerm(disguise.getType(), disguiseName);
            customDisguises.put(perm, toParse);
            DisguiseUtilities.getLogger().info("Loaded custom disguise " + disguiseName);
        }
        catch (DisguiseParseException e) {
            throw new DisguiseParseException(LibsMsg.ERROR_LOADING_CUSTOM_DISGUISE, disguiseName, e.getMessage() == null ? "" : ": " + e.getMessage());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            throw new DisguiseParseException(LibsMsg.ERROR_LOADING_CUSTOM_DISGUISE, disguiseName, "");
        }
    }

    public static boolean isSoundEnabled() {
        return PacketsManager.isHearDisguisesEnabled();
    }

    public static void setAnimationPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isAnimationPacketsEnabled()) {
            animationPacketsEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setCollectPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isCollectPacketsEnabled()) {
            collectPacketsEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setEntityStatusPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isEntityStatusPacketsEnabled()) {
            entityStatusPacketsEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setEquipmentPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isEquipmentPacketsEnabled()) {
            equipmentPacketsEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setHideArmorFromSelf(boolean hideArmor) {
        if (hidingArmorFromSelf != hideArmor) {
            hidingArmorFromSelf = hideArmor;
            PacketsManager.setInventoryListenerEnabled(DisguiseConfig.isHidingHeldItemFromSelf() || DisguiseConfig.isHidingArmorFromSelf());
        }
    }

    public static void setHideHeldItemFromSelf(boolean hideHelditem) {
        if (hidingHeldItemFromSelf != hideHelditem) {
            hidingHeldItemFromSelf = hideHelditem;
            PacketsManager.setInventoryListenerEnabled(DisguiseConfig.isHidingHeldItemFromSelf() || DisguiseConfig.isHidingArmorFromSelf());
        }
    }

    public static void setMiscDisguisesForLivingEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
            miscDisguisesForLivingEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setMovementPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isMovementPacketsEnabled()) {
            movementPacketsEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setSoundsEnabled(boolean isSoundsEnabled) {
        PacketsManager.setHearDisguisesListener(isSoundsEnabled);
    }

    public static DisguisePushing getPushingOption() {
        return pushingOption;
    }

    public static void setPushingOption(DisguisePushing pushingOption) {
        DisguiseConfig.pushingOption = pushingOption;
    }

    public static HashMap<DisguisePerm, String> getCustomDisguises() {
        return customDisguises;
    }

    public static void setCustomDisguises(HashMap<DisguisePerm, String> customDisguises) {
        DisguiseConfig.customDisguises = customDisguises;
    }

    public static String getUpdateNotificationPermission() {
        return updateNotificationPermission;
    }

    public static void setUpdateNotificationPermission(String updateNotificationPermission) {
        DisguiseConfig.updateNotificationPermission = updateNotificationPermission;
    }

    public static UpdatesBranch getUpdatesBranch() {
        return updatesBranch;
    }

    public static void setUpdatesBranch(UpdatesBranch updatesBranch) {
        DisguiseConfig.updatesBranch = updatesBranch;
    }

    public static boolean isAddEntityAnimations() {
        return addEntityAnimations;
    }

    public static void setAddEntityAnimations(boolean addEntityAnimations) {
        DisguiseConfig.addEntityAnimations = addEntityAnimations;
    }

    public static boolean isAnimationPacketsEnabled() {
        return animationPacketsEnabled;
    }

    public static boolean isCatDyeable() {
        return catDyeable;
    }

    public static void setCatDyeable(boolean catDyeable) {
        DisguiseConfig.catDyeable = catDyeable;
    }

    public static boolean isCollectPacketsEnabled() {
        return collectPacketsEnabled;
    }

    private static void setDisableCommands(boolean disableCommands) {
        DisguiseConfig.disableCommands = disableCommands;
    }

    public static boolean isDisableCommands() {
        return disableCommands;
    }

    public static boolean isDisableFriendlyInvisibles() {
        return disableFriendlyInvisibles;
    }

    public static void setDisableFriendlyInvisibles(boolean disableFriendlyInvisibles) {
        DisguiseConfig.disableFriendlyInvisibles = disableFriendlyInvisibles;
    }

    public static boolean isDisabledInvisibility() {
        return disabledInvisibility;
    }

    public static void setDisabledInvisibility(boolean disabledInvisibility) {
        DisguiseConfig.disabledInvisibility = disabledInvisibility;
    }

    public static boolean isDisguiseBlownWhenAttacked() {
        return disguiseBlownWhenAttacked;
    }

    public static void setDisguiseBlownWhenAttacked(boolean disguiseBlownWhenAttacked) {
        DisguiseConfig.disguiseBlownWhenAttacked = disguiseBlownWhenAttacked;
    }

    public static boolean isDisguiseBlownWhenAttacking() {
        return disguiseBlownWhenAttacking;
    }

    public static void setDisguiseBlownWhenAttacking(boolean disguiseBlownWhenAttacking) {
        DisguiseConfig.disguiseBlownWhenAttacking = disguiseBlownWhenAttacking;
    }

    public static boolean isDynamicExpiry() {
        return dynamicExpiry;
    }

    public static void setDynamicExpiry(boolean dynamicExpiry) {
        DisguiseConfig.dynamicExpiry = dynamicExpiry;
    }

    public static boolean isEntityStatusPacketsEnabled() {
        return entityStatusPacketsEnabled;
    }

    public static boolean isEquipmentPacketsEnabled() {
        return equipmentPacketsEnabled;
    }

    public static boolean isExplicitDisguisePermissions() {
        return explicitDisguisePermissions;
    }

    public static void setExplicitDisguisePermissions(boolean explicitDisguisePermissions) {
        DisguiseConfig.explicitDisguisePermissions = explicitDisguisePermissions;
    }

    public static boolean isExtendedDisguiseNames() {
        return extendedDisguiseNames;
    }

    public static void setExtendedDisguiseNames(boolean extendedDisguiseNames) {
        DisguiseConfig.extendedDisguiseNames = extendedDisguiseNames;
    }

    public static boolean isHideDisguisedPlayers() {
        return hideDisguisedPlayers;
    }

    public static void setHideDisguisedPlayers(boolean hideDisguisedPlayers) {
        DisguiseConfig.hideDisguisedPlayers = hideDisguisedPlayers;
    }

    public static boolean isHidingArmorFromSelf() {
        return hidingArmorFromSelf;
    }

    public static void setHidingArmorFromSelf(boolean hidingArmorFromSelf) {
        DisguiseConfig.hidingArmorFromSelf = hidingArmorFromSelf;
    }

    public static boolean isHidingHeldItemFromSelf() {
        return hidingHeldItemFromSelf;
    }

    public static void setHidingHeldItemFromSelf(boolean hidingHeldItemFromSelf) {
        DisguiseConfig.hidingHeldItemFromSelf = hidingHeldItemFromSelf;
    }

    public static boolean isHorseSaddleable() {
        return horseSaddleable;
    }

    public static void setHorseSaddleable(boolean horseSaddleable) {
        DisguiseConfig.horseSaddleable = horseSaddleable;
    }

    public static boolean isKeepDisguiseOnPlayerDeath() {
        return keepDisguiseOnPlayerDeath;
    }

    public static void setKeepDisguiseOnPlayerDeath(boolean keepDisguiseOnPlayerDeath) {
        DisguiseConfig.keepDisguiseOnPlayerDeath = keepDisguiseOnPlayerDeath;
    }

    public static boolean isLlamaCarpetable() {
        return llamaCarpetable;
    }

    public static void setLlamaCarpetable(boolean llamaCarpetable) {
        DisguiseConfig.llamaCarpetable = llamaCarpetable;
    }

    public static boolean isMaxHealthDeterminedByDisguisedEntity() {
        return maxHealthDeterminedByDisguisedEntity;
    }

    public static void setMaxHealthDeterminedByDisguisedEntity(boolean maxHealthDeterminedByDisguisedEntity) {
        DisguiseConfig.maxHealthDeterminedByDisguisedEntity = maxHealthDeterminedByDisguisedEntity;
    }

    public static boolean isMetaPacketsEnabled() {
        return metaPacketsEnabled;
    }

    public static void setMetaPacketsEnabled(boolean metaPacketsEnabled) {
        DisguiseConfig.metaPacketsEnabled = metaPacketsEnabled;
    }

    public static boolean isMiscDisguisesForLivingEnabled() {
        return miscDisguisesForLivingEnabled;
    }

    public static boolean isModifyBoundingBox() {
        return modifyBoundingBox;
    }

    public static void setModifyBoundingBox(boolean modifyBoundingBox) {
        DisguiseConfig.modifyBoundingBox = modifyBoundingBox;
    }

    public static boolean isModifyCollisions() {
        return modifyCollisions;
    }

    public static void setModifyCollisions(boolean modifyCollisions) {
        DisguiseConfig.modifyCollisions = modifyCollisions;
    }

    public static boolean isMonstersIgnoreDisguises() {
        return monstersIgnoreDisguises;
    }

    public static void setMonstersIgnoreDisguises(boolean monstersIgnoreDisguises) {
        DisguiseConfig.monstersIgnoreDisguises = monstersIgnoreDisguises;
    }

    public static boolean isMovementPacketsEnabled() {
        return movementPacketsEnabled;
    }

    public static boolean isNameAboveHeadAlwaysVisible() {
        return nameAboveHeadAlwaysVisible;
    }

    public static void setNameAboveHeadAlwaysVisible(boolean nameAboveHeadAlwaysVisible) {
        DisguiseConfig.nameAboveHeadAlwaysVisible = nameAboveHeadAlwaysVisible;
    }

    public static boolean isNameOfPlayerShownAboveDisguise() {
        return nameOfPlayerShownAboveDisguise;
    }

    public static void setNameOfPlayerShownAboveDisguise(boolean nameOfPlayerShownAboveDisguise) {
        DisguiseConfig.nameOfPlayerShownAboveDisguise = nameOfPlayerShownAboveDisguise;
    }

    public static boolean isPlayerHideArmor() {
        return playerHideArmor;
    }

    public static void setPlayerHideArmor(boolean playerHideArmor) {
        DisguiseConfig.playerHideArmor = playerHideArmor;
    }

    public static boolean isSaveEntityDisguises() {
        return saveEntityDisguises;
    }

    public static void setSaveEntityDisguises(boolean saveEntityDisguises) {
        DisguiseConfig.saveEntityDisguises = saveEntityDisguises;
    }

    public static boolean isSaveGameProfiles() {
        return saveGameProfiles;
    }

    public static void setSaveGameProfiles(boolean saveGameProfiles) {
        DisguiseConfig.saveGameProfiles = saveGameProfiles;
    }

    public static boolean isSavePlayerDisguises() {
        return savePlayerDisguises;
    }

    public static void setSavePlayerDisguises(boolean savePlayerDisguises) {
        DisguiseConfig.savePlayerDisguises = savePlayerDisguises;
    }

    public static boolean isSelfDisguisesSoundsReplaced() {
        return selfDisguisesSoundsReplaced;
    }

    public static void setSelfDisguisesSoundsReplaced(boolean selfDisguisesSoundsReplaced) {
        DisguiseConfig.selfDisguisesSoundsReplaced = selfDisguisesSoundsReplaced;
    }

    public static boolean isSheepDyeable() {
        return sheepDyeable;
    }

    public static void setSheepDyeable(boolean sheepDyeable) {
        DisguiseConfig.sheepDyeable = sheepDyeable;
    }

    public static boolean isShowDisguisedPlayersInTab() {
        return showDisguisedPlayersInTab;
    }

    public static void setShowDisguisedPlayersInTab(boolean showDisguisedPlayersInTab) {
        DisguiseConfig.showDisguisedPlayersInTab = showDisguisedPlayersInTab;
    }

    public static boolean isStopShulkerDisguisesFromMoving() {
        return stopShulkerDisguisesFromMoving;
    }

    public static void setStopShulkerDisguisesFromMoving(boolean stopShulkerDisguisesFromMoving) {
        DisguiseConfig.stopShulkerDisguisesFromMoving = stopShulkerDisguisesFromMoving;
    }

    public static boolean isUndisguiseOnWorldChange() {
        return undisguiseOnWorldChange;
    }

    public static void setUndisguiseOnWorldChange(boolean undisguiseOnWorldChange) {
        DisguiseConfig.undisguiseOnWorldChange = undisguiseOnWorldChange;
    }

    public static boolean isUpdateGameProfiles() {
        return updateGameProfiles;
    }

    public static void setUpdateGameProfiles(boolean updateGameProfiles) {
        DisguiseConfig.updateGameProfiles = updateGameProfiles;
    }

    public static boolean isUseTranslations() {
        return useTranslations;
    }

    public static boolean isVelocitySent() {
        return velocitySent;
    }

    public static void setVelocitySent(boolean velocitySent) {
        DisguiseConfig.velocitySent = velocitySent;
    }

    public static boolean isViewDisguises() {
        return viewDisguises;
    }

    public static void setViewDisguises(boolean viewDisguises) {
        DisguiseConfig.viewDisguises = viewDisguises;
    }

    public static boolean isWarnScoreboardConflict() {
        return warnScoreboardConflict;
    }

    public static void setWarnScoreboardConflict(boolean warnScoreboardConflict) {
        DisguiseConfig.warnScoreboardConflict = warnScoreboardConflict;
    }

    public static boolean isWitherSkullPacketsEnabled() {
        return witherSkullPacketsEnabled;
    }

    public static void setWitherSkullPacketsEnabled(boolean witherSkullPacketsEnabled) {
        DisguiseConfig.witherSkullPacketsEnabled = witherSkullPacketsEnabled;
    }

    public static boolean isWolfDyeable() {
        return wolfDyeable;
    }

    public static void setWolfDyeable(boolean wolfDyeable) {
        DisguiseConfig.wolfDyeable = wolfDyeable;
    }

    public static int getDisguiseCloneExpire() {
        return disguiseCloneExpire;
    }

    public static void setDisguiseCloneExpire(int disguiseCloneExpire) {
        DisguiseConfig.disguiseCloneExpire = disguiseCloneExpire;
    }

    public static int getDisguiseEntityExpire() {
        return disguiseEntityExpire;
    }

    public static void setDisguiseEntityExpire(int disguiseEntityExpire) {
        DisguiseConfig.disguiseEntityExpire = disguiseEntityExpire;
    }

    public static int getMaxClonedDisguises() {
        return maxClonedDisguises;
    }

    public static void setMaxClonedDisguises(int maxClonedDisguises) {
        DisguiseConfig.maxClonedDisguises = maxClonedDisguises;
    }

    public static int getPlayerDisguisesTablistExpires() {
        return playerDisguisesTablistExpires;
    }

    public static void setPlayerDisguisesTablistExpires(int playerDisguisesTablistExpires) {
        DisguiseConfig.playerDisguisesTablistExpires = playerDisguisesTablistExpires;
    }

    public static boolean isDisablePvP() {
        return disablePvP;
    }

    public static void setDisablePvP(boolean disablePvP) {
        DisguiseConfig.disablePvP = disablePvP;
    }

    public static boolean isDisablePvE() {
        return disablePvE;
    }

    public static void setDisablePvE(boolean disablePvE) {
        DisguiseConfig.disablePvE = disablePvE;
    }

    public static double getPvPTimer() {
        return pvPTimer;
    }

    public static void setPvPTimer(double pvPTimer) {
        DisguiseConfig.pvPTimer = pvPTimer;
    }

    public static boolean isRetaliationCombat() {
        return retaliationCombat;
    }

    public static void setRetaliationCombat(boolean retaliationCombat) {
        DisguiseConfig.retaliationCombat = retaliationCombat;
    }

    public static NotifyBar getNotifyBar() {
        return notifyBar;
    }

    public static void setNotifyBar(NotifyBar notifyBar) {
        DisguiseConfig.notifyBar = notifyBar;
    }

    public static BarStyle getBossBarStyle() {
        return bossBarStyle;
    }

    public static void setBossBarStyle(BarStyle bossBarStyle) {
        DisguiseConfig.bossBarStyle = bossBarStyle;
    }

    public static BarColor getBossBarColor() {
        return bossBarColor;
    }

    public static void setBossBarColor(BarColor bossBarColor) {
        DisguiseConfig.bossBarColor = bossBarColor;
    }

    public static boolean isScoreboardDisguiseNames() {
        return scoreboardDisguiseNames;
    }

    public static void setScoreboardDisguiseNames(boolean scoreboardDisguiseNames) {
        DisguiseConfig.scoreboardDisguiseNames = scoreboardDisguiseNames;
    }

    static {
        updatesBranch = UpdatesBranch.SAME_BUILDS;
        notifyBar = NotifyBar.ACTION_BAR;
        bossBarStyle = BarStyle.SOLID;
        bossBarColor = BarColor.GREEN;
        commandVisibility = PermissionDefault.TRUE;
    }

    public static enum NotifyBar {
        NONE,
        BOSS_BAR,
        ACTION_BAR;

    }

    public static enum UpdatesBranch {
        SAME_BUILDS,
        SNAPSHOTS,
        RELEASES;

    }

    public static enum DisguisePushing {
        MODIFY_SCOREBOARD,
        IGNORE_SCOREBOARD,
        CREATE_SCOREBOARD;

    }
}

