/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.watchers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.reflection.asm.WatcherInfo;

public class DisguiseMethods {
    private HashMap<Class<? extends FlagWatcher>, List<Method>> watcherMethods = new HashMap();

    public ArrayList<Method> getMethods(Class c) {
        ArrayList<Method> methods = new ArrayList<Method>();
        if (this.watcherMethods.containsKey(c)) {
            methods.addAll((Collection<Method>)this.watcherMethods.get(c));
        }
        if (c != FlagWatcher.class) {
            methods.addAll(this.getMethods(c.getSuperclass()));
        }
        return methods;
    }

    public ArrayList<Method> getMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        this.watcherMethods.values().forEach(methods::addAll);
        return methods;
    }

    public DisguiseMethods() {
        try (InputStream stream = LibsDisguises.getInstance().getResource("ANTI_PIRACY_ENCRYPTION");){
            List lines = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
            HashMap<String, Class> classes = new HashMap<String, Class>();
            classes.put(FlagWatcher.class.getSimpleName(), FlagWatcher.class);
            for (DisguiseType t : DisguiseType.values()) {
                if (t.getWatcherClass() == null) continue;
                Class c = t.getWatcherClass();
                while (!classes.containsKey(c.getSimpleName())) {
                    classes.put(c.getSimpleName(), c);
                    c = ReflectionManager.getSuperClass(c);
                }
            }
            for (String line : lines) {
                Class watcher;
                WatcherInfo info = new WatcherInfo(line);
                if (!info.isSupported() || info.getParam().isEmpty() || (watcher = (Class)classes.get(info.getWatcher())) == null) continue;
                String paramName = info.getParam();
                Class<?> param = !paramName.contains(".") ? this.parseType(paramName) : Class.forName(paramName);
                Method method = watcher.getMethod(info.getMethod(), param);
                if (method.getParameterCount() != 1 || method.getName().startsWith("get") || method.isAnnotationPresent(Deprecated.class) || !method.getReturnType().equals(Void.TYPE) || ParamInfoManager.getParamInfo(method) == null) continue;
                this.watcherMethods.computeIfAbsent(watcher, a -> new ArrayList()).add(method);
            }
        }
        catch (IOException | ClassNotFoundException | NoClassDefFoundError | NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private Class<?> parseType(String className) {
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "[I": {
                return int[].class;
            }
        }
        throw new IllegalArgumentException("Class not found: " + className);
    }
}

