/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.mineskin;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.SkinUtils;
import me.libraryaddict.disguise.utilities.mineskin.MineSkinResponse;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;

public class MineSkinAPI {
    private long nextRequest;
    private final ReentrantLock lock = new ReentrantLock();

    public boolean isInUse() {
        return this.lock.isLocked();
    }

    public int nextRequestIn() {
        long timeTillNext = this.nextRequest - System.currentTimeMillis();
        if (timeTillNext < 0L) {
            return 0;
        }
        return (int)Math.ceil((double)timeTillNext / 1000.0);
    }

    public MineSkinResponse generateFromUrl(SkinUtils.SkinCallback callback, String url) {
        return this.doPost(callback, "/generate/url", url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MineSkinResponse doPost(SkinUtils.SkinCallback callback, String path, String skinUrl, File file) {
        MineSkinResponse mineSkinResponse;
        InputStream input;
        Throwable throwable;
        HttpURLConnection connection;
        block61: {
            block62: {
                block59: {
                    APIError error;
                    block60: {
                        block55: {
                            block58: {
                                block57: {
                                    block56: {
                                        this.lock.lock();
                                        connection = null;
                                        URL url = new URL("https://api.mineskin.org" + path);
                                        connection = (HttpURLConnection)url.openConnection();
                                        connection.setRequestProperty("User-Agent", "LibsDisguises");
                                        connection.setConnectTimeout(19000);
                                        connection.setReadTimeout(19000);
                                        String boundary = Long.toHexString(System.currentTimeMillis());
                                        connection.setDoOutput(true);
                                        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                                        String charset = "UTF-8";
                                        String CRLF = "\r\n";
                                        throwable = null;
                                        try (OutputStream output = connection.getOutputStream();
                                             PrintWriter writer2 = new PrintWriter((Writer)new OutputStreamWriter(output, charset), true);){
                                            writer2.append("--").append(boundary).append(CRLF);
                                            writer2.append("Content-Disposition: form-data; name=\"visibility\"").append(CRLF);
                                            writer2.append("Content-Type: text/plain; charset=").append(charset).append(CRLF);
                                            writer2.append(CRLF).append("1").append(CRLF).flush();
                                            if (file != null) {
                                                writer2.append("--").append(boundary).append(CRLF);
                                                writer2.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(file.getName()).append("\"").append(CRLF);
                                                writer2.append("Content-Type: image/png").append(CRLF);
                                                writer2.append("Content-Transfer-Encoding: binary").append(CRLF);
                                                writer2.append(CRLF).flush();
                                                Files.copy(file.toPath(), output);
                                                output.flush();
                                                writer2.append(CRLF).flush();
                                            } else if (skinUrl != null) {
                                                writer2.append("--").append(boundary).append(CRLF);
                                                writer2.append("Content-Disposition: form-data; name=\"url\"").append(CRLF);
                                                writer2.append(CRLF).append(skinUrl).append(CRLF).flush();
                                            }
                                            writer2.append("--").append(boundary).append("--").append(CRLF).flush();
                                        }
                                        catch (Throwable writer2) {
                                            throwable = writer2;
                                            throw writer2;
                                        }
                                        if (connection.getResponseCode() != 500) break block55;
                                        error = (APIError)new Gson().fromJson(new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")), APIError.class);
                                        if (error.code != 403) break block56;
                                        callback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + error.code, LibsMsg.SKIN_API_403.get(new Object[0]));
                                        throwable = null;
                                        this.lock.unlock();
                                        return throwable;
                                    }
                                    if (error.code != 404) break block57;
                                    callback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + error.code, LibsMsg.SKIN_API_404.get(new Object[0]));
                                    throwable = null;
                                    this.lock.unlock();
                                    return throwable;
                                }
                                if (error.code != 408 && error.code != 504 && error.code != 599) break block58;
                                callback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + error.code, LibsMsg.SKIN_API_TIMEOUT.get(new Object[0]));
                                throwable = null;
                                this.lock.unlock();
                                return throwable;
                            }
                            callback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + error.code, LibsMsg.SKIN_API_IMAGE_HAS_ERROR.get(error.error));
                            throwable = null;
                            this.lock.unlock();
                            return throwable;
                        }
                        if (connection.getResponseCode() != 400) break block59;
                        if (skinUrl == null) break block60;
                        callback.onError(LibsMsg.SKIN_API_BAD_URL, new Object[0]);
                        error = null;
                        this.lock.unlock();
                        return error;
                    }
                    if (file == null) break block59;
                    callback.onError(LibsMsg.SKIN_API_BAD_FILE, new Object[0]);
                    error = null;
                    this.lock.unlock();
                    return error;
                }
                input = connection.getInputStream();
                throwable = null;
                String response = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                MineSkinResponse skinResponse = (MineSkinResponse)new Gson().fromJson(response, MineSkinResponse.class);
                this.nextRequest = System.currentTimeMillis() + (long)(skinResponse.getNextRequest() * 1000.0);
                mineSkinResponse = skinResponse;
                if (input == null) break block61;
                if (throwable == null) break block62;
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block61;
            }
            input.close();
        }
        this.lock.unlock();
        return mineSkinResponse;
        catch (Throwable throwable3) {
            MineSkinResponse mineSkinResponse2;
            try {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (input == null) throw throwable4;
                    if (throwable != null) {
                        try {
                            input.close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    } else {
                        input.close();
                    }
                    throw throwable4;
                }
            }
            catch (SocketTimeoutException ex) {
                callback.onError(skinUrl == null ? LibsMsg.SKIN_API_TIMEOUT_ERROR : LibsMsg.SKIN_API_IMAGE_TIMEOUT, new Object[0]);
                mineSkinResponse2 = null;
                this.lock.unlock();
                return mineSkinResponse2;
            }
            catch (Exception ex) {
                block63: {
                    this.nextRequest = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
                    if (connection == null || connection.getResponseCode() != 524 && connection.getResponseCode() != 408 && connection.getResponseCode() != 504 && connection.getResponseCode() != 599) break block63;
                    callback.onError(LibsMsg.SKIN_API_TIMEOUT_ERROR, new Object[0]);
                    mineSkinResponse2 = null;
                    this.lock.unlock();
                    return mineSkinResponse2;
                }
                try {
                    block64: {
                        break block64;
                        {
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    DisguiseUtilities.getLogger().warning("Failed to access MineSkin.org");
                    ex.printStackTrace();
                    callback.onError(LibsMsg.SKIN_API_FAIL, new Object[0]);
                    return null;
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public MineSkinResponse generateFromUUID(UUID uuid) throws IllegalArgumentException {
        this.lock.lock();
        try {
            MineSkinResponse mineSkinResponse;
            Throwable throwable;
            InputStream input;
            block18: {
                block19: {
                    URL url = new URL("https://api.mineskin.org/generate/user/:" + uuid.toString());
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    con.setRequestProperty("User-Agent", "LibsDisguises");
                    con.setDoOutput(true);
                    input = con.getInputStream();
                    throwable = null;
                    String response = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    MineSkinResponse skinResponse = (MineSkinResponse)new Gson().fromJson(response, MineSkinResponse.class);
                    this.nextRequest = System.currentTimeMillis() + (long)(skinResponse.getNextRequest() * 1000.0);
                    mineSkinResponse = skinResponse;
                    if (input == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                input.close();
            }
            return mineSkinResponse;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (input != null) {
                            if (throwable != null) {
                                try {
                                    input.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                input.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception ex) {
                    this.nextRequest = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
                    if (ex.getMessage() != null && ex.getMessage().contains("Server returned HTTP response code: 400 for URL")) {
                        throw new IllegalArgumentException();
                    }
                    DisguiseUtilities.getLogger().warning("Failed to access MineSkin.org");
                    ex.printStackTrace();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    public MineSkinResponse generateFromFile(SkinUtils.SkinCallback callback, File file) {
        return this.doPost(callback, "/generate/upload", null, file);
    }

    private class APIError {
        int code;
        String error;

        private APIError() {
        }
    }
}

