/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import java.lang.reflect.InvocationTargetException;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FallingBlockWatcher
extends FlagWatcher {
    private ItemStack block = new ItemStack(Material.STONE);
    private boolean gridLocked;

    public FallingBlockWatcher(Disguise disguise) {
        super(disguise);
    }

    @Override
    public FallingBlockWatcher clone(Disguise disguise) {
        FallingBlockWatcher watcher = (FallingBlockWatcher)super.clone(disguise);
        watcher.setBlock(this.getBlock().clone());
        return watcher;
    }

    public boolean isGridLocked() {
        return this.gridLocked;
    }

    public void setGridLocked(boolean gridLocked) {
        if (this.isGridLocked() == gridLocked) {
            return;
        }
        this.gridLocked = gridLocked;
        if (this.getDisguise().isDisguiseInUse() && this.getDisguise().getEntity() != null) {
            PacketContainer relMove = new PacketContainer(PacketType.Play.Server.REL_ENTITY_MOVE);
            StructureModifier shorts = relMove.getShorts();
            Location loc = this.getDisguise().getEntity().getLocation();
            relMove.getModifier().write(0, (Object)this.getDisguise().getEntity().getEntityId());
            shorts.write(0, (Object)this.conRel(loc.getX(), (double)loc.getBlockX() + 0.5));
            shorts.write(1, (Object)this.conRel(loc.getY(), loc.getBlockY()));
            shorts.write(2, (Object)this.conRel(loc.getZ(), (double)loc.getBlockZ() + 0.5));
            try {
                for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                    if (player == this.getDisguise().getEntity()) {
                        PacketContainer temp = relMove.shallowClone();
                        temp.getModifier().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, temp, this.isGridLocked());
                        continue;
                    }
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, relMove, this.isGridLocked());
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private short conRel(double oldCord, double newCord) {
        return (short)((oldCord - newCord) * 4096.0 * (double)(this.isGridLocked() ? -1 : 1));
    }

    public ItemStack getBlock() {
        return this.block;
    }

    public void setBlock(ItemStack block) {
        if (block == null || block.getType() == null || block.getType() == Material.AIR || !block.getType().isBlock()) {
            block = new ItemStack(Material.STONE);
        }
        this.block = block;
        if (DisguiseAPI.isDisguiseInUse(this.getDisguise()) && this.getDisguise().getWatcher() == this) {
            DisguiseUtilities.refreshTrackers(this.getDisguise());
        }
    }
}

