/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import me.libraryaddict.disguise.LibsDisguises;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class BisectHosting {
    public boolean isBisectHosted(String pluginName) {
        YamlConfiguration configuration;
        File configFile = new File("plugins/" + pluginName + "/internal-config.yml");
        boolean claimedHosted = false;
        if (configFile.exists() && (configuration = YamlConfiguration.loadConfiguration((File)configFile)).contains("Bisect-Hosted") && !(claimedHosted = configuration.getBoolean("Bisect-Hosted"))) {
            return false;
        }
        String ip = Bukkit.getIp();
        boolean hostedBy = false;
        if (ip.matches("((25[0-5]|(2[0-4]|1[0-9]|[1-9]|)[0-9])(\\.(?!$)|$)){4}")) {
            try {
                ip = this.getFinalURL("http://" + ip);
                if (ip.startsWith("https://www.bisecthosting.com/")) {
                    hostedBy = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!configFile.exists()) {
            if (!configFile.getParentFile().exists()) {
                configFile.getParentFile().mkdirs();
            }
            try (PrintWriter writer = new PrintWriter(configFile, "UTF-8");){
                writer.write("# If you're using Bisect Hosting, this will tell the server to enable premium for free!");
                writer.write("\n# However if you're not using Bisect Hosting, this is false so the server won't waste time");
                writer.write("\n# Coupon 'libraryaddict' for 25% off your first invoice on any of their gaming servers");
                writer.write("\nBisect-Hosted: " + hostedBy);
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (claimedHosted) {
            LibsDisguises.getInstance().getLogger().severe("Check for Bisect Hosting failed! Connection error?");
        }
        return hostedBy;
    }

    private String getFinalURL(String url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
        con.setInstanceFollowRedirects(false);
        con.setReadTimeout(2500);
        con.setConnectTimeout(2500);
        con.connect();
        con.getInputStream();
        if (con.getResponseCode() == 301 || con.getResponseCode() == 302) {
            return con.getHeaderField("Location");
        }
        return url;
    }
}

