/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.params;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.ParamInfoTypes;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoItemBlock;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.watchers.DisguiseMethods;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public class ParamInfoManager {
    private static List<ParamInfo> paramList;
    private static DisguiseMethods disguiseMethods;
    private static ParamInfoItemBlock paramInfoItemBlock;

    public static List<ParamInfo> getParamInfos() {
        return paramList;
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        ParamInfo info = ParamInfoManager.getParamInfo(object.getClass());
        if (info == null) {
            throw new IllegalArgumentException(object.getClass() + " is not handled by ParamInfo!");
        }
        return info.toString(object);
    }

    public static ParamInfo getParamInfo(Method method) {
        if (method.getDeclaringClass() == FallingBlockWatcher.class && method.getParameterTypes()[0] == ItemStack.class) {
            return ParamInfoManager.getParamInfoItemBlock();
        }
        return ParamInfoManager.getParamInfo(method.getParameterTypes()[0]);
    }

    public static ParamInfo getParamInfo(Class c) {
        for (ParamInfo info : ParamInfoManager.getParamInfos()) {
            if (!info.isParam(c)) continue;
            return info;
        }
        return null;
    }

    public static ParamInfo getParamInfo(DisguisePerm disguiseType, String methodName) {
        return ParamInfoManager.getParamInfo(disguiseType.getType(), methodName);
    }

    public static ParamInfo getParamInfo(DisguiseType disguiseType, String methodName) {
        for (Method method : ParamInfoManager.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
            if (!method.getName().toLowerCase().equals(methodName.toLowerCase())) continue;
            return ParamInfoManager.getParamInfo(method);
        }
        return null;
    }

    public static Method[] getDisguiseWatcherMethods(@Nullable Class<? extends FlagWatcher> watcherClass) {
        if (watcherClass == null) {
            return new Method[0];
        }
        ArrayList<Method> methods = new ArrayList<Method>(disguiseMethods.getMethods(watcherClass));
        methods.sort((m1, m2) -> {
            int v2;
            int v1 = ParamInfoManager.getValue(m1);
            if (v1 != (v2 = ParamInfoManager.getValue(m2))) {
                return v1 - v2;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(m1.getName(), m2.getName());
        });
        for (String methodName : new String[]{"setSelfDisguiseVisible", "setHideHeldItemFromSelf", "setHideArmorFromSelf", "setHearSelfDisguise", "setHidePlayer", "setExpires"}) {
            try {
                methods.add(Disguise.class.getMethod(methodName, methodName.equals("setExpires") ? Long.TYPE : Boolean.TYPE));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (watcherClass == PlayerWatcher.class) {
            try {
                methods.add(PlayerDisguise.class.getMethod("setNameVisible", Boolean.TYPE));
                methods.add(PlayerDisguise.class.getMethod("setDynamicName", Boolean.TYPE));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return methods.toArray(new Method[0]);
    }

    public static int getValue(Method method) {
        ChatColor methodColor = ChatColor.YELLOW;
        Class<?> declaring = method.getDeclaringClass();
        if (declaring == LivingWatcher.class) {
            return 1;
        }
        if (!FlagWatcher.class.isAssignableFrom(declaring) || declaring == FlagWatcher.class) {
            return 2;
        }
        return 0;
    }

    public static ParamInfoItemBlock getParamInfoItemBlock() {
        return paramInfoItemBlock;
    }

    static {
        ParamInfoTypes infoTypes = new ParamInfoTypes();
        paramList = infoTypes.getParamInfos();
        paramInfoItemBlock = infoTypes.getParamInfoBlock();
        disguiseMethods = new DisguiseMethods();
    }
}

