/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packethandlers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PacketHandlerMovement
implements IPacketHandler {
    @Override
    public PacketType[] getHandledPackets() {
        return new PacketType[]{PacketType.Play.Server.REL_ENTITY_MOVE_LOOK, PacketType.Play.Server.ENTITY_LOOK, PacketType.Play.Server.ENTITY_TELEPORT, PacketType.Play.Server.REL_ENTITY_MOVE};
    }

    private short conRel(int oldCord, int newCord) {
        return (short)((oldCord - newCord) * 4096);
    }

    @Override
    public void handle(Disguise disguise, PacketContainer sentPacket, LibsPackets packets, Player observer, Entity entity) {
        if (sentPacket.getType() != PacketType.Play.Server.ENTITY_LOOK && disguise.getType() == DisguiseType.FALLING_BLOCK && ((FallingBlockWatcher)disguise.getWatcher()).isGridLocked()) {
            packets.clear();
            PacketContainer movePacket = sentPacket.shallowClone();
            if (sentPacket.getType() != PacketType.Play.Server.ENTITY_TELEPORT) {
                boolean sameBlock;
                StructureModifier shorts = movePacket.getShorts();
                Location current = entity.getLocation();
                Vector diff = new Vector((double)((Short)shorts.read(0)).shortValue() / 4096.0, (double)((Short)shorts.read(1)).shortValue() / 4096.0, (double)((Short)shorts.read(2)).shortValue() / 4096.0);
                Location newLoc = current.clone().subtract(diff);
                boolean bl = sameBlock = current.getBlockX() == newLoc.getBlockX() && current.getBlockY() == newLoc.getBlockY() && current.getBlockZ() == newLoc.getBlockZ();
                if (sameBlock) {
                    return;
                }
                shorts.write(0, (Object)this.conRel(current.getBlockX(), newLoc.getBlockX()));
                shorts.write(1, (Object)this.conRel(current.getBlockY(), newLoc.getBlockY()));
                shorts.write(2, (Object)this.conRel(current.getBlockZ(), newLoc.getBlockZ()));
            } else {
                Location loc = entity.getLocation();
                StructureModifier doubles = movePacket.getDoubles();
                doubles.write(0, (Object)((double)loc.getBlockX() + 0.5));
                doubles.write(1, (Object)loc.getBlockY());
                doubles.write(2, (Object)((double)loc.getBlockZ() + 0.5));
            }
            packets.addPacket(movePacket);
            StructureModifier bytes = movePacket.getBytes();
            byte yawValue = (Byte)bytes.read(0);
            byte pitchValue = (Byte)bytes.read(1);
            bytes.write(0, (Object)DisguiseUtilities.getYaw(disguise.getType(), entity.getType(), yawValue));
            bytes.write(1, (Object)DisguiseUtilities.getPitch(disguise.getType(), entity.getType(), pitchValue));
        } else if (disguise.getType() == DisguiseType.RABBIT && (sentPacket.getType() == PacketType.Play.Server.REL_ENTITY_MOVE || sentPacket.getType() == PacketType.Play.Server.REL_ENTITY_MOVE_LOOK)) {
            long lastHop = 999999L;
            if (!entity.getMetadata("LibsRabbitHop").isEmpty()) {
                lastHop = System.currentTimeMillis() - ((MetadataValue)entity.getMetadata("LibsRabbitHop").get(0)).asLong();
            }
            if (lastHop < 100L || lastHop > 500L) {
                if (lastHop > 500L) {
                    entity.removeMetadata("LibsRabbitHop", (Plugin)LibsDisguises.getInstance());
                    entity.setMetadata("LibsRabbitHop", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)System.currentTimeMillis()));
                }
                PacketContainer statusPacket = new PacketContainer(PacketType.Play.Server.ENTITY_STATUS);
                packets.addPacket(statusPacket);
                statusPacket.getIntegers().write(0, (Object)entity.getEntityId());
                statusPacket.getBytes().write(0, (Object)1);
            }
        } else if (sentPacket.getType() == PacketType.Play.Server.ENTITY_LOOK && disguise.getType() == DisguiseType.WITHER_SKULL) {
            packets.clear();
        } else if (sentPacket.getType() != PacketType.Play.Server.REL_ENTITY_MOVE) {
            packets.clear();
            PacketContainer movePacket = sentPacket.shallowClone();
            packets.addPacket(movePacket);
            StructureModifier bytes = movePacket.getBytes();
            byte yawValue = (Byte)bytes.read(0);
            byte pitchValue = (Byte)bytes.read(1);
            bytes.write(0, (Object)DisguiseUtilities.getYaw(disguise.getType(), entity.getType(), yawValue));
            bytes.write(1, (Object)DisguiseUtilities.getPitch(disguise.getType(), entity.getType(), pitchValue));
            if (sentPacket.getType() == PacketType.Play.Server.ENTITY_TELEPORT && disguise.getType() == DisguiseType.ITEM_FRAME) {
                double y;
                StructureModifier doubles = movePacket.getDoubles();
                Location loc = entity.getLocation();
                double data = (loc.getYaw() % 360.0f + 720.0f + 45.0f) / 90.0f % 4.0f;
                if (data % 2.0 == 0.0) {
                    if (data % 2.0 == 0.0) {
                        doubles.write(3, (Object)loc.getZ());
                    } else {
                        doubles.write(1, (Object)loc.getZ());
                    }
                }
                if ((y = DisguiseUtilities.getYModifier(entity, disguise)) != 0.0) {
                    doubles.write(2, (Object)((Double)doubles.read(2) + y));
                }
            }
        }
    }
}

