/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.util.Arrays;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CopyDisguiseCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        Disguise disguise;
        Entity target;
        if (!(!(sender instanceof Player) || sender.isOp() || LibsPremium.isPremium().booleanValue() && LibsPremium.getPaidInformation() != LibsPremium.getPluginInformation())) {
            sender.sendMessage(ChatColor.RED + "Please purchase Lib's Disguises to enable player commands");
            return true;
        }
        if (!sender.hasPermission("libsdisguises.copydisguise")) {
            sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
            return true;
        }
        Entity entity = target = sender instanceof Player ? (Entity)sender : null;
        if (args.length > 0) {
            target = Bukkit.getPlayer((String)args[0]);
            if (target == null && args[0].contains("-")) {
                try {
                    target = Bukkit.getEntity((UUID)UUID.fromString(args[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (target == null) {
                sender.sendMessage(LibsMsg.CANNOT_FIND_PLAYER.get(args[0]));
                return true;
            }
        }
        if ((disguise = DisguiseAPI.getDisguise(target)) == null) {
            sender.sendMessage((sender == target ? LibsMsg.NOT_DISGUISED : LibsMsg.TARGET_NOT_DISGUISED).get(new Object[0]));
            return true;
        }
        String disguiseString = DisguiseParser.parseToString(disguise, false);
        this.sendMessage(sender, LibsMsg.CLICK_TO_COPY, LibsMsg.COPY_DISGUISE_NO_COPY, disguiseString, false);
        if (disguise instanceof PlayerDisguise) {
            this.sendMessage(sender, LibsMsg.CLICK_TO_COPY_WITH_SKIN, LibsMsg.CLICK_TO_COPY_WITH_SKIN_NO_COPY, DisguiseParser.parseToString(disguise), true);
        }
        DisguiseUtilities.setCopyDisguiseCommandUsed();
        return true;
    }

    private void sendMessage(CommandSender sender, LibsMsg msg, LibsMsg oldVer, String string, boolean forceAbbrev) {
        if (!NmsVersion.v1_13.isSupported()) {
            sender.sendMessage(oldVer.get(string));
            return;
        }
        ComponentBuilder builder = new ComponentBuilder("").appendLegacy(msg.get(new Object[0])).append(" ");
        if (string.length() > 256 || forceAbbrev) {
            String[] split = DisguiseUtilities.split(string);
            for (int i = 0; i < split.length; ++i) {
                if (split[i].length() <= 256) continue;
                split = Arrays.copyOf(split, split.length + 1);
                for (int a = split.length - 1; a > i; --a) {
                    split[a] = split[a - 1];
                }
                split[i + 1] = split[i].substring(256);
                split[i] = split[i].substring(0, 256);
            }
            int sections = 0;
            StringBuilder current = new StringBuilder();
            for (int i = 0; i < split.length; ++i) {
                if (current.length() > 0) {
                    current.append(" ");
                }
                current.append(split[i]);
                if (split.length > i + 1 && split[i + 1].length() + current.length() + 1 <= 256) continue;
                if (sections != 0) {
                    builder.append(" ");
                    builder.reset();
                }
                builder.appendLegacy(LibsMsg.CLICK_COPY.get(++sections));
                builder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, current.toString()));
                builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(LibsMsg.CLICK_TO_COPY_HOVER.get(new Object[0]) + " " + sections).create()));
                current = new StringBuilder();
            }
        } else {
            builder.appendLegacy(LibsMsg.CLICK_COPY.get(string));
            builder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, string));
            builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(LibsMsg.CLICK_TO_COPY_HOVER.get(new Object[0])).create()));
        }
        sender.spigot().sendMessage(builder.create());
    }
}

