/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedParticle;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.EntityPose;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.VillagerData;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.GuardianWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.IllagerWizardWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MinecartWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.OcelotWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PufferFishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SkeletonWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SpiderWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TNTWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TameableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TippedArrowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.DisguiseSound;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookupCaller;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsRemovedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fish;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class ReflectionManager {
    private static String bukkitVersion;
    private static Class<?> craftItemClass;
    private static Method damageAndIdleSoundMethod;
    private static Constructor<?> boundingBoxConstructor;
    private static Method setBoundingBoxMethod;
    private static Field pingField;
    private static Field entityCountField;
    private static Field chunkMapField;
    private static Field chunkProviderField;
    private static Field entityTrackerField;
    private static Field trackedEntitiesField;
    @NmsRemovedIn(val=NmsVersion.v1_14)
    private static Method ihmGet;
    @NmsRemovedIn(val=NmsVersion.v1_14)
    private static Field trackerField;
    @NmsRemovedIn(val=NmsVersion.v1_14)
    private static Field entitiesField;
    private static NmsVersion version;

    public static void init() {
        try {
            Object entity = ReflectionManager.createEntityInstance(DisguiseType.COW, "Cow");
            for (Method method : ReflectionManager.getNmsClass("EntityLiving").getDeclaredMethods()) {
                if (method.getReturnType() != Float.TYPE || !Modifier.isProtected(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
                method.setAccessible(true);
                float value = ((Float)method.invoke(entity, new Object[0])).floatValue();
                if (((Float)method.invoke(entity, new Object[0])).floatValue() != 0.4f) continue;
                damageAndIdleSoundMethod = method;
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        craftItemClass = ReflectionManager.getCraftClass("inventory.CraftItemStack");
        pingField = ReflectionManager.getNmsField("EntityPlayer", "ping");
        if (NmsVersion.v1_14.isSupported()) {
            chunkProviderField = ReflectionManager.getNmsField("World", "chunkProvider");
            chunkMapField = ReflectionManager.getNmsField("ChunkProviderServer", "playerChunkMap");
            trackedEntitiesField = ReflectionManager.getNmsField("PlayerChunkMap", "trackedEntities");
            entityTrackerField = ReflectionManager.getNmsField("PlayerChunkMap$EntityTracker", "trackerEntry");
        } else {
            trackerField = ReflectionManager.getNmsField("WorldServer", "tracker");
            entitiesField = ReflectionManager.getNmsField("EntityTracker", "trackedEntities");
            ihmGet = ReflectionManager.getNmsMethod("IntHashMap", "get", Integer.TYPE);
        }
        boundingBoxConstructor = ReflectionManager.getNmsConstructor("AxisAlignedBB", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
        setBoundingBoxMethod = ReflectionManager.getNmsMethod("Entity", "a", ReflectionManager.getNmsClass("AxisAlignedBB"));
        entityCountField = ReflectionManager.getNmsField("Entity", "entityCount");
        entityCountField.setAccessible(true);
    }

    public static boolean isSupported(AccessibleObject obj) {
        NmsRemovedIn removed;
        NmsAddedIn added;
        if (obj.isAnnotationPresent(NmsAddedIn.class) && !(added = obj.getAnnotation(NmsAddedIn.class)).val().isSupported()) {
            return false;
        }
        return !obj.isAnnotationPresent(NmsRemovedIn.class) || !(removed = obj.getAnnotation(NmsRemovedIn.class)).val().isSupported();
    }

    public static boolean isSupported(Class cl, String name) {
        try {
            for (Field field : cl.getFields()) {
                if (!field.getName().equals(name)) continue;
                return ReflectionManager.isSupported(field);
            }
            for (AccessibleObject accessibleObject : cl.getMethods()) {
                if (!((Method)accessibleObject).getName().equals(name)) continue;
                return ReflectionManager.isSupported(accessibleObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static YamlConfiguration getPluginYaml(ClassLoader loader) {
        try (InputStream stream = loader.getResourceAsStream("plugin.yml");){
            YamlConfiguration config = new YamlConfiguration();
            config.loadFromString(new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")));
            YamlConfiguration yamlConfiguration = config;
            return yamlConfiguration;
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getNewEntityId() {
        return ReflectionManager.getNewEntityId(true);
    }

    public static int getNewEntityId(boolean increment) {
        try {
            Number entityCount = (Number)entityCountField.get(null);
            if (increment) {
                if (NmsVersion.v1_14.isSupported()) {
                    return ((AtomicInteger)entityCount).getAndIncrement();
                }
                int id = entityCount.intValue();
                entityCountField.set(null, id + 1);
                return id;
            }
            return entityCount.intValue();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static Object createEntityInstance(DisguiseType disguiseType, String entityName) {
        try {
            Object entityObject;
            Class entityClass = ReflectionManager.getNmsClass("Entity" + entityName);
            Object world = ReflectionManager.getWorldServer((World)Bukkit.getWorlds().get(0));
            if (entityName.equals("Player")) {
                Object minecraftServer = ReflectionManager.getNmsMethod("MinecraftServer", "getServer", new Class[0]).invoke(null, new Object[0]);
                Object playerinteractmanager = ReflectionManager.getNmsClass("PlayerInteractManager").getDeclaredConstructor(ReflectionManager.getNmsClass(NmsVersion.v1_14.isSupported() ? "WorldServer" : "World")).newInstance(world);
                WrappedGameProfile gameProfile = ReflectionManager.getGameProfile(new UUID(0L, 0L), "Steve");
                entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("MinecraftServer"), ReflectionManager.getNmsClass("WorldServer"), gameProfile.getHandleType(), playerinteractmanager.getClass()).newInstance(minecraftServer, world, gameProfile.getHandle(), playerinteractmanager);
            } else {
                entityObject = entityName.equals("EnderPearl") ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), ReflectionManager.getNmsClass("EntityLiving")).newInstance(world, ReflectionManager.createEntityInstance(DisguiseType.COW, "Cow")) : (entityName.equals("FishingHook") ? (NmsVersion.v1_14.isSupported() ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("EntityHuman"), ReflectionManager.getNmsClass("World"), Integer.TYPE, Integer.TYPE).newInstance(ReflectionManager.createEntityInstance(DisguiseType.PLAYER, "Player"), world, 0, 0) : entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), ReflectionManager.getNmsClass("EntityHuman")).newInstance(world, ReflectionManager.createEntityInstance(DisguiseType.PLAYER, "Player"))) : (!NmsVersion.v1_14.isSupported() && entityName.equals("Potion") ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), Double.TYPE, Double.TYPE, Double.TYPE, ReflectionManager.getNmsClass("ItemStack")).newInstance(world, 0.0, 0.0, 0.0, ReflectionManager.getNmsItem(new ItemStack(Material.SPLASH_POTION))) : (NmsVersion.v1_14.isSupported() ? entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("EntityTypes"), ReflectionManager.getNmsClass("World")).newInstance(ReflectionManager.getEntityType(disguiseType.getEntityType()), world) : entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World")).newInstance(world))));
            }
            return entityObject;
        }
        catch (Exception e) {
            DisguiseUtilities.getLogger().warning("Error while attempting to create entity instance for " + disguiseType.name());
            e.printStackTrace();
            return null;
        }
    }

    public static Object getMobEffectList(int id) {
        Method nmsMethod = ReflectionManager.getNmsMethod("MobEffectList", "fromId", Integer.TYPE);
        try {
            return nmsMethod.invoke(null, id);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object createMobEffect(PotionEffect effect) {
        return ReflectionManager.createMobEffect(effect.getType().getId(), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles());
    }

    public static Object createMobEffect(int id, int duration, int amplification, boolean ambient, boolean particles) {
        try {
            return ReflectionManager.getNmsClass("MobEffect").getDeclaredConstructor(ReflectionManager.getNmsClass("MobEffectList"), Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE).newInstance(ReflectionManager.getMobEffectList(id), duration, amplification, ambient, particles);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FakeBoundingBox getBoundingBox(Entity entity) {
        try {
            Object boundingBox = ReflectionManager.getNmsMethod("Entity", "getBoundingBox", new Class[0]).invoke(ReflectionManager.getNmsEntity(entity), new Object[0]);
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            int stage = 0;
            block10: for (Field field : boundingBox.getClass().getDeclaredFields()) {
                if (!field.getType().getSimpleName().equals("double")) continue;
                switch (++stage) {
                    case 1: {
                        x -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 2: {
                        y -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 3: {
                        z -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 4: {
                        x += field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 5: {
                        y += field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 6: {
                        z += field.getDouble(boundingBox);
                        continue block10;
                    }
                    default: {
                        throw new Exception("Error while setting the bounding box, more doubles than I thought??");
                    }
                }
            }
            return new FakeBoundingBox(x, y, z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Entity getBukkitEntity(Object nmsEntity) {
        try {
            return (Entity)ReflectionManager.getNmsMethod("Entity", "getBukkitEntity", new Class[0]).invoke(nmsEntity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ItemStack getBukkitItem(Object nmsItem) {
        try {
            return (ItemStack)craftItemClass.getMethod("asBukkitCopy", ReflectionManager.getNmsClass("ItemStack")).invoke(null, nmsItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NmsVersion getVersion() {
        if (version == null) {
            ReflectionManager.getBukkitVersion();
        }
        return version;
    }

    public static String getBukkitVersion() {
        if (bukkitVersion == null) {
            bukkitVersion = Bukkit.getServer().getClass().getName().split("\\.")[3];
            for (NmsVersion v : NmsVersion.values()) {
                if (!ReflectionManager.getBukkitVersion().startsWith(v.name())) continue;
                version = v;
                break;
            }
        }
        return bukkitVersion;
    }

    public static Class<?> getCraftClass(String className) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + ReflectionManager.getBukkitVersion() + "." + className);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getCraftConstructor(Class clazz, Class<?> ... parameters) {
        try {
            Constructor declaredConstructor = clazz.getDeclaredConstructor(parameters);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getCraftConstructor(String className, Class<?> ... parameters) {
        return ReflectionManager.getCraftConstructor(ReflectionManager.getCraftClass(className), parameters);
    }

    public static Object getCraftSound(Sound sound) {
        try {
            return ReflectionManager.getCraftClass("CraftSound").getMethod("getSoundEffect", String.class).invoke(null, ReflectionManager.getSoundString(sound));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getEntityTrackerEntry(Entity target) throws Exception {
        Object world = ReflectionManager.getWorldServer(target.getWorld());
        if (NmsVersion.v1_14.isSupported()) {
            Object chunkProvider = chunkProviderField.get(world);
            Object chunkMap = chunkMapField.get(chunkProvider);
            Map trackedEntities = (Map)trackedEntitiesField.get(chunkMap);
            Object entityTracker = trackedEntities.get(target.getEntityId());
            if (entityTracker == null) {
                return null;
            }
            return entityTrackerField.get(entityTracker);
        }
        Object tracker = trackerField.get(world);
        Object trackedEntities = entitiesField.get(tracker);
        return ihmGet.invoke(trackedEntities, target.getEntityId());
    }

    public static Object getMinecraftServer() {
        try {
            return ReflectionManager.getCraftMethod("CraftServer", "getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getEnumArt(Art art) {
        try {
            Object enumArt = ReflectionManager.getCraftClass("CraftArt").getMethod("BukkitToNotch", Art.class).invoke(null, art);
            for (Field field : enumArt.getClass().getDeclaredFields()) {
                if (field.getType() != String.class) continue;
                return (String)field.get(enumArt);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static Object getBlockPosition(int x, int y, int z) {
        try {
            return ReflectionManager.getNmsClass("BlockPosition").getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(x, y, z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Enum getEnumDirection(int direction) {
        try {
            return (Enum)ReflectionManager.getNmsMethod("EnumDirection", "fromType2", Integer.TYPE).invoke(null, direction);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Enum getEnumPlayerInfoAction(int action) {
        try {
            return (Enum)ReflectionManager.getNmsClass("PacketPlayOutPlayerInfo$EnumPlayerInfoAction").getEnumConstants()[action];
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerInfoData(Object playerInfoPacket, WrappedGameProfile gameProfile) {
        try {
            Object playerListName = ReflectionManager.getNmsClass("ChatComponentText").getDeclaredConstructor(String.class).newInstance(gameProfile.getName());
            return ReflectionManager.getNmsClass("PacketPlayOutPlayerInfo$PlayerInfoData").getDeclaredConstructor(ReflectionManager.getNmsClass("PacketPlayOutPlayerInfo"), gameProfile.getHandleType(), Integer.TYPE, ReflectionManager.getNmsClass("EnumGamemode"), ReflectionManager.getNmsClass("IChatBaseComponent")).newInstance(playerInfoPacket, gameProfile.getHandle(), 0, ReflectionManager.getNmsClass("EnumGamemode").getEnumConstants()[1], playerListName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getGameProfile(Player player) {
        return WrappedGameProfile.fromPlayer((Player)player);
    }

    public static WrappedGameProfile getGameProfile(UUID uuid, String playerName) {
        try {
            return new WrappedGameProfile(uuid != null ? uuid : ReflectionManager.getRandomUUID(), playerName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getClonedProfile(WrappedGameProfile gameProfile) {
        return ReflectionManager.getGameProfileWithThisSkin(null, gameProfile.getName(), gameProfile);
    }

    public static WrappedGameProfile getGameProfileWithThisSkin(UUID uuid, String playerName, WrappedGameProfile profileWithSkin) {
        try {
            WrappedGameProfile gameProfile = new WrappedGameProfile(uuid != null ? uuid : ReflectionManager.getRandomUUID(), playerName);
            if (profileWithSkin != null) {
                gameProfile.getProperties().putAll(profileWithSkin.getProperties());
            }
            return gameProfile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static UUID getRandomUUID() {
        UUID uuid = UUID.randomUUID();
        if (DisguiseConfig.getUUIDGeneratedVersion() == 4) {
            return uuid;
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        bb.put(6, (byte)(bb.get(6) & 0xF));
        bb.put(6, (byte)(bb.get(6) | DisguiseConfig.getUUIDGeneratedVersion()));
        bb.position(0);
        long firstLong = bb.getLong();
        long secondLong = bb.getLong();
        return new UUID(firstLong, secondLong);
    }

    public static Class getNmsClass(String className) {
        try {
            return Class.forName("net.minecraft.server." + ReflectionManager.getBukkitVersion() + "." + className);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getNmsClassIgnoreErrors(String className) {
        try {
            return Class.forName("net.minecraft.server." + ReflectionManager.getBukkitVersion() + "." + className);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Constructor getNmsConstructor(Class clazz, Class<?> ... parameters) {
        try {
            Constructor declaredConstructor = clazz.getDeclaredConstructor(parameters);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getNmsConstructor(String className, Class<?> ... parameters) {
        return ReflectionManager.getNmsConstructor(ReflectionManager.getNmsClass(className), parameters);
    }

    public static Object getNmsEntity(Entity entity) {
        try {
            return ReflectionManager.getCraftClass("entity.CraftEntity").getMethod("getHandle", new Class[0]).invoke((Object)entity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Field getNmsField(Class clazz, String fieldName) {
        try {
            Field declaredField = clazz.getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            return declaredField;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Field getNmsField(String className, String fieldName) {
        return ReflectionManager.getNmsField(ReflectionManager.getNmsClass(className), fieldName);
    }

    public static Object getNmsItem(ItemStack itemstack) {
        try {
            return craftItemClass.getMethod("asNMSCopy", ItemStack.class).invoke(null, itemstack);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getCraftMethod(String className, String methodName, Class<?> ... parameters) {
        return ReflectionManager.getCraftMethod(ReflectionManager.getCraftClass(className), methodName, parameters);
    }

    public static Method getCraftMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Method declaredMethod = clazz.getDeclaredMethod(methodName, parameters);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Method declaredMethod = clazz.getDeclaredMethod(methodName, parameters);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(String className, String methodName, Class<?> ... parameters) {
        return ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass(className), methodName, parameters);
    }

    public static double getPing(Player player) {
        try {
            return pingField.getInt(ReflectionManager.getNmsEntity((Entity)player));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public static float[] getSize(Entity entity) {
        try {
            if (NmsVersion.v1_14.isSupported()) {
                Object size = ReflectionManager.getNmsField("Entity", "size").get(ReflectionManager.getNmsEntity(entity));
                float width = ReflectionManager.getNmsField("EntitySize", "width").getFloat(size);
                float height = ReflectionManager.getNmsField("Entity", "headHeight").getFloat(ReflectionManager.getNmsEntity(entity));
                return new float[]{width, height};
            }
            float width = ReflectionManager.getNmsField("Entity", "width").getFloat(ReflectionManager.getNmsEntity(entity));
            float height = ((Float)ReflectionManager.getNmsMethod("Entity", "getHeadHeight", new Class[0]).invoke(ReflectionManager.getNmsEntity(entity), new Object[0])).floatValue();
            return new float[]{width, height};
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getSkullBlob(WrappedGameProfile gameProfile) {
        try {
            Object minecraftServer = ReflectionManager.getMinecraftServer();
            for (Method method : ReflectionManager.getNmsClass("MinecraftServer").getMethods()) {
                if (!method.getReturnType().getSimpleName().equals("MinecraftSessionService")) continue;
                Object session = method.invoke(minecraftServer, new Object[0]);
                return WrappedGameProfile.fromHandle((Object)session.getClass().getDeclaredMethod("fillProfileProperties", gameProfile.getHandleType(), Boolean.TYPE).invoke(session, gameProfile.getHandle(), true));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static Float getSoundModifier(Object entity) {
        try {
            return (Float)damageAndIdleSoundMethod.invoke(entity, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static WrappedGameProfile grabProfileAddUUID(String playername) {
        try {
            Object minecraftServer = ReflectionManager.getMinecraftServer();
            for (Method method : ReflectionManager.getNmsClass("MinecraftServer").getMethods()) {
                if (!method.getReturnType().getSimpleName().equals("GameProfileRepository")) continue;
                Object agent = Class.forName("com.mojang.authlib.Agent").getDeclaredField("MINECRAFT").get(null);
                LibsProfileLookupCaller callback = new LibsProfileLookupCaller();
                Object profileRepo = method.invoke(minecraftServer, new Object[0]);
                method.getReturnType().getMethod("findProfilesByNames", String[].class, agent.getClass(), Class.forName("com.mojang.authlib.ProfileLookupCallback")).invoke(profileRepo, new String[]{playername}, agent, callback);
                if (callback.getGameProfile() != null) {
                    return callback.getGameProfile();
                }
                return ReflectionManager.getGameProfile(null, playername);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void setBoundingBox(Entity entity, FakeBoundingBox newBox) {
        try {
            Location loc = entity.getLocation();
            Object boundingBox = boundingBoxConstructor.newInstance(loc.getX() - newBox.getX() / 2.0, loc.getY(), loc.getZ() - newBox.getZ() / 2.0, loc.getX() + newBox.getX() / 2.0, loc.getY() + newBox.getY(), loc.getZ() + newBox.getZ() / 2.0);
            setBoundingBoxMethod.invoke(ReflectionManager.getNmsEntity(entity), boundingBox);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Enum getSoundCategory(String category) {
        try {
            Method method = ReflectionManager.getNmsMethod("SoundCategory", "a", new Class[0]);
            for (Enum anEnum : (Enum[])ReflectionManager.getNmsClass("SoundCategory").getEnumConstants()) {
                if (!category.equals(method.invoke((Object)anEnum, new Object[0]))) continue;
                return anEnum;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Enum getSoundCategory(DisguiseType disguiseType) {
        if (disguiseType == DisguiseType.PLAYER) {
            return ReflectionManager.getSoundCategory("player");
        }
        Class entityClass = disguiseType.getEntityType().getEntityClass();
        if (Monster.class.isAssignableFrom(entityClass)) {
            return ReflectionManager.getSoundCategory("hostile");
        }
        if (Ambient.class.isAssignableFrom(entityClass)) {
            return ReflectionManager.getSoundCategory("ambient");
        }
        return ReflectionManager.getSoundCategory("neutral");
    }

    public static Enum createEnumItemSlot(EquipmentSlot slot) {
        T[] enums;
        Class clazz = ReflectionManager.getNmsClass("EnumItemSlot");
        T[] TArray = enums = clazz != null ? clazz.getEnumConstants() : null;
        if (enums == null) {
            return null;
        }
        switch (slot) {
            case HAND: {
                return (Enum)enums[0];
            }
            case OFF_HAND: {
                return (Enum)enums[1];
            }
            case FEET: {
                return (Enum)enums[2];
            }
            case LEGS: {
                return (Enum)enums[3];
            }
            case CHEST: {
                return (Enum)enums[4];
            }
            case HEAD: {
                return (Enum)enums[5];
            }
        }
        return null;
    }

    public static EquipmentSlot createEquipmentSlot(Object enumItemSlot) {
        try {
            Enum nmsSlot = (Enum)enumItemSlot;
            switch (nmsSlot.name()) {
                case "MAINHAND": {
                    return EquipmentSlot.HAND;
                }
                case "OFFHAND": {
                    return EquipmentSlot.OFF_HAND;
                }
                case "FEET": {
                    return EquipmentSlot.FEET;
                }
                case "LEGS": {
                    return EquipmentSlot.LEGS;
                }
                case "CHEST": {
                    return EquipmentSlot.CHEST;
                }
                case "HEAD": {
                    return EquipmentSlot.HEAD;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ItemStack getEquipment(EquipmentSlot slot, Entity disguisedEntity) {
        if (!(disguisedEntity instanceof LivingEntity)) {
            return null;
        }
        switch (slot) {
            case HAND: {
                return ((LivingEntity)disguisedEntity).getEquipment().getItemInMainHand();
            }
            case OFF_HAND: {
                return ((LivingEntity)disguisedEntity).getEquipment().getItemInOffHand();
            }
            case FEET: {
                return ((LivingEntity)disguisedEntity).getEquipment().getBoots();
            }
            case LEGS: {
                return ((LivingEntity)disguisedEntity).getEquipment().getLeggings();
            }
            case CHEST: {
                return ((LivingEntity)disguisedEntity).getEquipment().getChestplate();
            }
            case HEAD: {
                return ((LivingEntity)disguisedEntity).getEquipment().getHelmet();
            }
        }
        return null;
    }

    public static Object getSoundString(Sound sound) {
        try {
            return ReflectionManager.getCraftMethod("CraftSound", "getSound", Sound.class).invoke(null, sound);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getNmsClass(Class cl) {
        if (VillagerData.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("VillagerData");
        }
        if (BlockPosition.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("BlockPosition");
        }
        if (WrappedBlockData.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("IBlockData");
        }
        if (ItemStack.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("ItemStack");
        }
        if (WrappedChatComponent.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("IChatBaseComponent");
        }
        if (Vector3F.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("Vector3f");
        }
        if (EnumWrappers.Direction.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("EnumDirection");
        }
        if (WrappedParticle.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("ParticleParam");
        }
        if (EntityPose.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("EntityPose");
        }
        if (NbtWrapper.class.isAssignableFrom(cl)) {
            return ReflectionManager.getNmsClass("NBTTagCompound");
        }
        return cl;
    }

    public static Object convertInvalidMeta(Object value) {
        if (value instanceof Optional) {
            Optional opt = (Optional)value;
            if (!opt.isPresent()) {
                return NmsVersion.v1_13.isSupported() ? value : com.google.common.base.Optional.absent();
            }
            Object val = opt.get();
            if (val instanceof BlockPosition) {
                BlockPosition pos = (BlockPosition)val;
                try {
                    Object obj = ReflectionManager.getNmsConstructor("BlockPosition", Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(pos.getX(), pos.getY(), pos.getZ());
                    return NmsVersion.v1_13.isSupported() ? Optional.of(obj) : com.google.common.base.Optional.of(obj);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (val instanceof WrappedBlockData) {
                try {
                    Object obj = ((WrappedBlockData)val).getHandle();
                    return NmsVersion.v1_13.isSupported() ? Optional.of(obj) : com.google.common.base.Optional.of((Object)obj);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                if (val instanceof ItemStack) {
                    if ((val = ReflectionManager.getNmsItem((ItemStack)val)) == null) {
                        return NmsVersion.v1_13.isSupported() ? Optional.empty() : com.google.common.base.Optional.absent();
                    }
                    return Optional.of(val);
                }
                if (val instanceof WrappedChatComponent) {
                    Object obj = ((WrappedChatComponent)val).getHandle();
                    return NmsVersion.v1_13.isSupported() ? Optional.of(obj) : com.google.common.base.Optional.of((Object)obj);
                }
                if (!NmsVersion.v1_13.isSupported()) {
                    return com.google.common.base.Optional.of(val);
                }
            }
        } else if (value instanceof Vector3F) {
            Vector3F angle = (Vector3F)value;
            try {
                return ReflectionManager.getNmsConstructor("Vector3f", Float.TYPE, Float.TYPE, Float.TYPE).newInstance(Float.valueOf(angle.getX()), Float.valueOf(angle.getY()), Float.valueOf(angle.getZ()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (value instanceof EnumWrappers.Direction) {
            try {
                return ReflectionManager.getNmsMethod("EnumDirection", "fromType1", Integer.TYPE).invoke(null, ((EnumWrappers.Direction)value).ordinal());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (value instanceof BlockPosition) {
            BlockPosition pos = (BlockPosition)value;
            try {
                return ReflectionManager.getNmsConstructor("BlockPosition", Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(pos.getX(), pos.getY(), pos.getZ());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            if (value instanceof ItemStack) {
                return ReflectionManager.getNmsItem((ItemStack)value);
            }
            if (value instanceof Double) {
                return Float.valueOf(((Double)value).floatValue());
            }
            if (value instanceof NbtWrapper) {
                return ((NbtWrapper)value).getHandle();
            }
            if (value instanceof WrappedParticle) {
                return ((WrappedParticle)value).getHandle();
            }
            if (value instanceof EntityPose) {
                return ReflectionManager.getNmsEntityPose((EntityPose)((Object)value));
            }
            if (value instanceof VillagerData) {
                return ReflectionManager.getNmsVillagerData((VillagerData)value);
            }
            if (value instanceof WrappedChatComponent) {
                return ((WrappedChatComponent)value).getHandle();
            }
        }
        return value;
    }

    public static Material getMaterial(String name) {
        try {
            if (!NmsVersion.v1_13.isSupported()) {
                Method toMinecraft = ReflectionManager.getCraftMethod("util.CraftMagicNumbers", "getMaterialFromInternalName", String.class);
                return (Material)toMinecraft.invoke(null, name);
            }
            Object mcKey = ReflectionManager.getNmsConstructor("MinecraftKey", String.class).newInstance(name);
            Object registry = ReflectionManager.getNmsField("IRegistry", "ITEM").get(null);
            Method getMethod = ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass("RegistryMaterials"), "get", mcKey.getClass());
            Object item = getMethod.invoke(registry, mcKey);
            if (item == null) {
                return null;
            }
            Method getMaterial = ReflectionManager.getCraftMethod("util.CraftMagicNumbers", "getMaterial", ReflectionManager.getNmsClass("Item"));
            return (Material)getMaterial.invoke(null, item);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getItemName(Material material) {
        try {
            Object item = ReflectionManager.getCraftMethod("util.CraftMagicNumbers", "getItem", Material.class).invoke(null, material);
            if (item == null) {
                return null;
            }
            Object registry = NmsVersion.v1_13.isSupported() ? ReflectionManager.getNmsField("IRegistry", "ITEM").get(null) : ReflectionManager.getNmsField("Item", "REGISTRY").get(null);
            Method getMethod = ReflectionManager.getNmsMethod(registry.getClass(), NmsVersion.v1_13.isSupported() ? "getKey" : "b", Object.class);
            Object mcKey = getMethod.invoke(registry, item);
            if (mcKey == null) {
                return null;
            }
            return (String)ReflectionManager.getNmsMethod("MinecraftKey", "getKey", new Class[0]).invoke(mcKey, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getNmsVillagerData(VillagerData data) {
        Object type = ReflectionManager.getVillagerType(data.getType());
        Object profession = ReflectionManager.getVillagerProfession(data.getProfession());
        try {
            return ReflectionManager.getNmsConstructor("VillagerData", ReflectionManager.getNmsClass("VillagerType"), profession.getClass(), Integer.TYPE).newInstance(type, profession, data.getLevel());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getVillagerType(Villager.Type type) {
        try {
            Object villagerType = ReflectionManager.getNmsField("IRegistry", "VILLAGER_TYPE").get(null);
            Method toMinecraft = ReflectionManager.getCraftMethod("util.CraftNamespacedKey", "toMinecraft", NamespacedKey.class);
            Object mcKey = toMinecraft.invoke(null, type.getKey());
            Method getField = ReflectionManager.getNmsMethod("RegistryBlocks", "get", mcKey.getClass());
            return getField.invoke(villagerType, mcKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAssignableFrom(Class toCheck, Class checkAgainst) {
        if (!NmsVersion.v1_14.isSupported() && toCheck != checkAgainst && toCheck == OcelotWatcher.class) {
            toCheck = TameableWatcher.class;
        }
        return checkAgainst.isAssignableFrom(toCheck);
    }

    public static Class getSuperClass(Class cl) {
        if (cl == FlagWatcher.class) {
            return null;
        }
        if (!NmsVersion.v1_14.isSupported() && cl == OcelotWatcher.class) {
            return TameableWatcher.class;
        }
        return cl.getSuperclass();
    }

    public static Object getVillagerProfession(Villager.Profession profession) {
        try {
            Object villagerProfession = ReflectionManager.getNmsField("IRegistry", "VILLAGER_PROFESSION").get(null);
            Method toMinecraft = ReflectionManager.getCraftMethod("util.CraftNamespacedKey", "toMinecraft", NamespacedKey.class);
            Object mcKey = toMinecraft.invoke(null, profession.getKey());
            Method getField = ReflectionManager.getNmsMethod("RegistryBlocks", "get", mcKey.getClass());
            return getField.invoke(villagerProfession, mcKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMinecraftVersion() {
        String version = Bukkit.getVersion();
        version = version.substring(version.lastIndexOf(" ") + 1, version.length() - 1);
        return version;
    }

    public static WrappedDataWatcher.WrappedDataWatcherObject createDataWatcherObject(MetaIndex index, Object value) {
        if (value == null) {
            return null;
        }
        return new WrappedDataWatcher.WrappedDataWatcherObject(index.getIndex(), index.getSerializer());
    }

    public static Object createDataWatcherItem(MetaIndex id, Object value) {
        WrappedDataWatcher.WrappedDataWatcherObject watcherObject = ReflectionManager.createDataWatcherObject(id, value);
        Constructor construct = ReflectionManager.getNmsConstructor("DataWatcher$Item", ReflectionManager.getNmsClass("DataWatcherObject"), Object.class);
        try {
            return construct.newInstance(watcherObject.getHandle(), ReflectionManager.convertInvalidMeta(value));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object createMinecraftKey(String name) {
        try {
            return ReflectionManager.getNmsClass("MinecraftKey").getConstructor(String.class).newInstance(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getVec3D(Vector vector) {
        try {
            Constructor c = ReflectionManager.getNmsConstructor("Vec3D", Double.TYPE, Double.TYPE, Double.TYPE);
            return c.newInstance(vector.getX(), vector.getY(), vector.getZ());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getEntityType(EntityType entityType) {
        try {
            Method entityTypes = ReflectionManager.getNmsMethod("EntityTypes", "a", String.class);
            Object val = entityTypes.invoke(null, entityType.getName() == null ? entityType.name().toLowerCase() : entityType.getName());
            if (NmsVersion.v1_14.isSupported()) {
                return ((Optional)val).orElse(null);
            }
            return val;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getEntityTypeId(EntityType entityType) {
        try {
            if (NmsVersion.v1_13.isSupported()) {
                Object entityTypes = ReflectionManager.getEntityType(entityType);
                Class typesClass = ReflectionManager.getNmsClass("IRegistry");
                Object registry = typesClass.getField("ENTITY_TYPE").get(null);
                return (Integer)registry.getClass().getMethod("a", Object.class).invoke(registry, entityTypes);
            }
            return entityType.getTypeId();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Failed to find EntityType id for " + entityType);
        }
    }

    public static Object getNmsEntityPose(EntityPose entityPose) {
        return Enum.valueOf(ReflectionManager.getNmsClass("EntityPose"), entityPose.name());
    }

    public static EntityPose getEntityPose(Object nmsEntityPose) {
        return EntityPose.valueOf(((Enum)nmsEntityPose).name());
    }

    public static WrappedWatchableObject createWatchable(MetaIndex index, Object obj) {
        Object watcherItem = ReflectionManager.createDataWatcherItem(index, obj);
        if (watcherItem == null) {
            return null;
        }
        return new WrappedWatchableObject(watcherItem);
    }

    public static int getCombinedIdByItemStack(ItemStack itemStack) {
        try {
            Object nmsItem = ReflectionManager.getNmsItem(itemStack);
            Object item = ReflectionManager.getNmsMethod("ItemStack", "getItem", new Class[0]).invoke(nmsItem, new Object[0]);
            Class blockClass = ReflectionManager.getNmsClass("Block");
            Object nmsBlock = ReflectionManager.getNmsMethod(blockClass, "asBlock", ReflectionManager.getNmsClass("Item")).invoke(null, item);
            Object iBlockData = ReflectionManager.getNmsMethod(blockClass, "getBlockData", new Class[0]).invoke(nmsBlock, new Object[0]);
            return (Integer)ReflectionManager.getNmsMethod("Block", "getCombinedId", ReflectionManager.getNmsClass("IBlockData")).invoke(null, iBlockData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static ItemStack getItemStackByCombinedId(int id) {
        try {
            Method idMethod = ReflectionManager.getNmsMethod("Block", "getByCombinedId", Integer.TYPE);
            Object iBlockData = idMethod.invoke(null, id);
            Class iBlockClass = ReflectionManager.getNmsClass("IBlockData");
            Method getBlock = ReflectionManager.getNmsMethod(iBlockClass, "getBlock", new Class[0]);
            Object block = getBlock.invoke(iBlockData, new Object[0]);
            Method getItem = ReflectionManager.getNmsMethod("Block", "t", iBlockClass);
            return ReflectionManager.getBukkitItem(getItem.invoke(block, iBlockData));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getWorldServer(World w) {
        try {
            return ReflectionManager.getCraftMethod("CraftWorld", "getHandle", new Class[0]).invoke((Object)w, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerInteractManager(World w) {
        Object worldServer = ReflectionManager.getWorldServer(w);
        try {
            return ReflectionManager.getNmsConstructor("PlayerInteractManager", ReflectionManager.getNmsClass("World")).newInstance(worldServer);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ItemMeta getDeserializedItemMeta(Map<String, Object> meta) {
        try {
            Method method = ReflectionManager.getCraftMethod(ReflectionManager.getCraftClass("inventory.CraftMetaItem$SerializableMeta"), "deserialize", Map.class);
            return (ItemMeta)method.invoke(null, meta);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Class<? extends FlagWatcher> getFlagWatcher(DisguiseType disguiseType) {
        Class watcherClass;
        try {
            switch (disguiseType) {
                case ARROW: {
                    watcherClass = TippedArrowWatcher.class;
                    break;
                }
                case COD: 
                case SALMON: {
                    watcherClass = FishWatcher.class;
                    break;
                }
                case SPECTRAL_ARROW: {
                    watcherClass = ArrowWatcher.class;
                    break;
                }
                case PRIMED_TNT: {
                    watcherClass = TNTWatcher.class;
                    break;
                }
                case MINECART_CHEST: 
                case MINECART_HOPPER: 
                case MINECART_MOB_SPAWNER: 
                case MINECART_TNT: {
                    watcherClass = MinecartWatcher.class;
                    break;
                }
                case SPIDER: 
                case CAVE_SPIDER: {
                    watcherClass = SpiderWatcher.class;
                    break;
                }
                case PIG_ZOMBIE: 
                case HUSK: 
                case DROWNED: {
                    watcherClass = ZombieWatcher.class;
                    break;
                }
                case MAGMA_CUBE: {
                    watcherClass = SlimeWatcher.class;
                    break;
                }
                case ELDER_GUARDIAN: {
                    watcherClass = GuardianWatcher.class;
                    break;
                }
                case WITHER_SKELETON: 
                case STRAY: {
                    watcherClass = SkeletonWatcher.class;
                    break;
                }
                case ILLUSIONER: 
                case EVOKER: {
                    watcherClass = IllagerWizardWatcher.class;
                    break;
                }
                case PUFFERFISH: {
                    watcherClass = PufferFishWatcher.class;
                    break;
                }
                default: {
                    watcherClass = Class.forName("me.libraryaddict.disguise.disguisetypes.watchers." + ReflectionManager.toReadable(disguiseType.name()) + "Watcher");
                    break;
                }
            }
        }
        catch (ClassNotFoundException ex) {
            Class entityClass = disguiseType.getEntityType().getEntityClass();
            if (entityClass != null) {
                watcherClass = Tameable.class.isAssignableFrom(entityClass) ? TameableWatcher.class : (Ageable.class.isAssignableFrom(entityClass) ? AgeableWatcher.class : (Creature.class.isAssignableFrom(entityClass) ? InsentientWatcher.class : (LivingEntity.class.isAssignableFrom(entityClass) ? LivingWatcher.class : (Fish.class.isAssignableFrom(entityClass) ? FishWatcher.class : FlagWatcher.class))));
            }
            watcherClass = FlagWatcher.class;
        }
        return watcherClass;
    }

    public static void registerValues() {
        for (DisguiseType disguiseType : DisguiseType.values()) {
            if (disguiseType.getEntityType() == null) continue;
            Class<? extends FlagWatcher> watcherClass = ReflectionManager.getFlagWatcher(disguiseType);
            if (watcherClass == null) {
                DisguiseUtilities.getLogger().severe("Error loading " + disguiseType.name() + ", FlagWatcher not assigned");
                continue;
            }
            if (LibsPremium.isPremium().booleanValue() && (LibsPremium.getPaidInformation() != null && LibsPremium.getPaidInformation().isPremium() && !LibsPremium.getPaidInformation().isLegit() || LibsPremium.getPluginInformation() != null && LibsPremium.getPluginInformation().isPremium() && !LibsPremium.getPluginInformation().isLegit())) {
                throw new IllegalStateException("Error while checking pi rate on startup! Please re-download the jar from SpigotMC before reporting this error!");
            }
            disguiseType.setWatcherClass(watcherClass);
            if (LibsDisguises.getInstance() == null || DisguiseValues.getDisguiseValues(disguiseType) != null) continue;
            ReflectionManager.createNMSValues(disguiseType);
        }
    }

    private static void createNMSValues(DisguiseType disguiseType) {
        String nmsEntityName = ReflectionManager.toReadable(disguiseType.name());
        Class nmsClass = ReflectionManager.getNmsClassIgnoreErrors("Entity" + nmsEntityName);
        if (nmsClass == null || Modifier.isAbstract(nmsClass.getModifiers())) {
            Object[] split = ReflectionManager.splitReadable(disguiseType.name());
            ArrayUtils.reverse((Object[])split);
            nmsEntityName = StringUtils.join((Object[])split);
            nmsClass = ReflectionManager.getNmsClassIgnoreErrors("Entity" + nmsEntityName);
            if (nmsClass == null || Modifier.isAbstract(nmsClass.getModifiers())) {
                nmsEntityName = null;
            }
        }
        if (nmsEntityName == null) {
            switch (disguiseType) {
                case DONKEY: {
                    nmsEntityName = "HorseDonkey";
                    break;
                }
                case ARROW: {
                    nmsEntityName = "TippedArrow";
                    break;
                }
                case DROPPED_ITEM: {
                    nmsEntityName = "Item";
                    break;
                }
                case FIREBALL: {
                    nmsEntityName = "LargeFireball";
                    break;
                }
                case FIREWORK: {
                    nmsEntityName = "Fireworks";
                    break;
                }
                case GIANT: {
                    nmsEntityName = "GiantZombie";
                    break;
                }
                case HUSK: {
                    nmsEntityName = "ZombieHusk";
                    break;
                }
                case ILLUSIONER: {
                    nmsEntityName = "IllagerIllusioner";
                    break;
                }
                case LEASH_HITCH: {
                    nmsEntityName = "Leash";
                    break;
                }
                case MINECART: {
                    nmsEntityName = "MinecartRideable";
                    break;
                }
                case MINECART_COMMAND: {
                    nmsEntityName = "MinecartCommandBlock";
                    break;
                }
                case MINECART_TNT: {
                    nmsEntityName = "MinecartTNT";
                    break;
                }
                case MULE: {
                    nmsEntityName = "HorseMule";
                    break;
                }
                case PRIMED_TNT: {
                    nmsEntityName = "TNTPrimed";
                    break;
                }
                case PUFFERFISH: {
                    nmsEntityName = "PufferFish";
                    break;
                }
                case SPLASH_POTION: {
                    nmsEntityName = "Potion";
                    break;
                }
                case STRAY: {
                    nmsEntityName = "SkeletonStray";
                    break;
                }
                case TRIDENT: {
                    nmsEntityName = "ThrownTrident";
                    break;
                }
                case WANDERING_TRADER: {
                    nmsEntityName = "VillagerTrader";
                    break;
                }
                case TRADER_LLAMA: {
                    nmsEntityName = "LLamaTrader";
                    break;
                }
            }
        }
        try {
            Float soundStrength;
            if (disguiseType == DisguiseType.UNKNOWN) {
                DisguiseValues disguiseValues = new DisguiseValues(disguiseType, null, 0, 0.0);
                disguiseValues.setAdultBox(new FakeBoundingBox(0.0, 0.0, 0.0));
                DisguiseSound sound = DisguiseSound.getType(disguiseType.name());
                if (sound != null) {
                    sound.setDamageAndIdleSoundVolume(1.0f);
                }
                return;
            }
            if (nmsEntityName == null) {
                DisguiseUtilities.getLogger().warning("Entity name not found! (" + disguiseType.name() + ")");
                return;
            }
            Object nmsEntity = ReflectionManager.createEntityInstance(disguiseType, nmsEntityName);
            if (nmsEntity == null) {
                DisguiseUtilities.getLogger().warning("Entity not found! (" + nmsEntityName + ")");
                return;
            }
            disguiseType.setTypeId(ReflectionManager.getEntityTypeId(disguiseType.getEntityType()));
            Entity bukkitEntity = ReflectionManager.getBukkitEntity(nmsEntity);
            int entitySize = 0;
            for (Field field : ReflectionManager.getNmsClass("Entity").getFields()) {
                if (!field.getType().getName().equals("EnumEntitySize")) continue;
                Iterator<MetaIndex> enumEntitySize = (Enum)field.get(nmsEntity);
                entitySize = ((Enum)((Object)enumEntitySize)).ordinal();
                break;
            }
            DisguiseValues disguiseValues = new DisguiseValues(disguiseType, nmsEntity.getClass(), entitySize, bukkitEntity instanceof Damageable ? ((Damageable)bukkitEntity).getMaxHealth() : 0.0);
            WrappedDataWatcher watcher = WrappedDataWatcher.getEntityWatcher((Entity)bukkitEntity);
            ArrayList<MetaIndex> indexes = MetaIndex.getMetaIndexes(disguiseType.getWatcherClass());
            boolean loggedName = false;
            for (WrappedWatchableObject watch : watcher.getWatchableObjects()) {
                MetaIndex flagType = MetaIndex.getMetaIndex(disguiseType.getWatcherClass(), watch.getIndex());
                if (flagType == null) {
                    DisguiseUtilities.getLogger().severe("MetaIndex not found for " + (Object)((Object)disguiseType) + "! Index: " + watch.getIndex());
                    DisguiseUtilities.getLogger().severe("Value: " + watch.getRawValue() + " (" + watch.getRawValue().getClass() + ") (" + nmsEntity.getClass() + ") & " + disguiseType.getWatcherClass().getSimpleName());
                    continue;
                }
                indexes.remove(flagType);
                Object ourValue = ReflectionManager.convertInvalidMeta(flagType.getDefault());
                Object nmsValue = ReflectionManager.convertInvalidMeta(watch.getValue());
                if (ourValue.getClass() == nmsValue.getClass()) continue;
                if (!loggedName) {
                    DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"=", (int)20));
                    DisguiseUtilities.getLogger().severe("MetaIndex mismatch! Disguise " + (Object)((Object)disguiseType) + ", Entity " + nmsEntityName);
                    loggedName = true;
                }
                DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"-", (int)20));
                DisguiseUtilities.getLogger().severe("Index: " + watch.getIndex() + " | " + flagType.getFlagWatcher().getSimpleName() + " | " + MetaIndex.getName(flagType));
                Object flagDefault = flagType.getDefault();
                DisguiseUtilities.getLogger().severe("LibsDisguises: " + flagDefault + " (" + flagDefault.getClass() + ")");
                DisguiseUtilities.getLogger().severe("LibsDisguises Converted: " + ourValue + " (" + ourValue.getClass() + ")");
                DisguiseUtilities.getLogger().severe("Minecraft: " + watch.getRawValue() + " (" + watch.getRawValue().getClass() + ")");
                DisguiseUtilities.getLogger().severe("Minecraft Converted: " + nmsValue + " (" + nmsValue.getClass() + ")");
                DisguiseUtilities.getLogger().severe(StringUtils.repeat((String)"-", (int)20));
            }
            for (MetaIndex index : indexes) {
                DisguiseUtilities.getLogger().warning((Object)((Object)disguiseType) + " has MetaIndex remaining! " + index.getFlagWatcher().getSimpleName() + " at index " + index.getIndex());
            }
            DisguiseSound sound = DisguiseSound.getType(disguiseType.name());
            if (sound != null && (soundStrength = ReflectionManager.getSoundModifier(nmsEntity)) != null) {
                sound.setDamageAndIdleSoundVolume(soundStrength.floatValue());
            }
            disguiseValues.setAdultBox(ReflectionManager.getBoundingBox(bukkitEntity));
            if (bukkitEntity instanceof Ageable) {
                ((Ageable)bukkitEntity).setBaby();
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
            } else if (bukkitEntity instanceof Zombie) {
                ((Zombie)bukkitEntity).setBaby(true);
                disguiseValues.setBabyBox(ReflectionManager.getBoundingBox(bukkitEntity));
            }
        }
        catch (FieldAccessException | IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            DisguiseUtilities.getLogger().severe("Uh oh! Trouble while making values for the disguise " + disguiseType.name() + "!");
            DisguiseUtilities.getLogger().severe("Before reporting this error, please make sure you are using the latest version of LibsDisguises and ProtocolLib.");
            DisguiseUtilities.getLogger().severe("Development builds are available at (ProtocolLib) http://ci.dmulloy2.net/job/ProtocolLib/ and (LibsDisguises) https://ci.md-5.net/job/LibsDisguises/");
            ex.printStackTrace();
        }
    }

    private static String[] splitReadable(String string) {
        String[] split = string.split("_");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].substring(0, 1) + split[i].substring(1).toLowerCase();
        }
        return split;
    }

    private static String toReadable(String string) {
        return StringUtils.join((Object[])ReflectionManager.splitReadable(string));
    }
}

