/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets.packethandlers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.packets.IPacketHandler;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsHandler;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PacketHandlerEquipment
implements IPacketHandler {
    private PacketsHandler packetsHandler;

    public PacketHandlerEquipment(PacketsHandler packetsHandler) {
        this.packetsHandler = packetsHandler;
    }

    @Override
    public PacketType[] getHandledPackets() {
        return new PacketType[]{PacketType.Play.Server.ENTITY_EQUIPMENT};
    }

    @Override
    public void handle(Disguise disguise, PacketContainer sentPacket, LibsPackets packets, Player observer, Entity entity) {
        ItemStack heldItem;
        if (DisguiseConfig.isPlayerHideArmor() && this.packetsHandler.isCancelMeta(disguise, observer)) {
            packets.clear();
            PacketContainer equipPacket = sentPacket.shallowClone();
            packets.addPacket(equipPacket);
            equipPacket.getModifier().write(2, ReflectionManager.getNmsItem(new ItemStack(Material.AIR)));
            return;
        }
        EquipmentSlot slot = ReflectionManager.createEquipmentSlot(packets.getPackets().get(0).getModifier().read(1));
        ItemStack itemStack = disguise.getWatcher().getItemStack(slot);
        if (itemStack != null) {
            packets.clear();
            PacketContainer equipPacket = sentPacket.shallowClone();
            packets.addPacket(equipPacket);
            equipPacket.getModifier().write(2, ReflectionManager.getNmsItem(itemStack.getType() == Material.AIR ? null : itemStack));
        }
        if (disguise.getWatcher().isRightClicking() && slot == EquipmentSlot.HAND && (heldItem = (ItemStack)packets.getPackets().get(0).getItemModifier().read(0)) != null && heldItem.getType() != Material.AIR) {
            List<WrappedWatchableObject> list = new ArrayList<WrappedWatchableObject>();
            if (DisguiseConfig.isMetaPacketsEnabled()) {
                WrappedWatchableObject watch = ReflectionManager.createWatchable(MetaIndex.ENTITY_META, WrappedDataWatcher.getEntityWatcher((Entity)entity).getByte(0));
                if (watch != null) {
                    list.add(watch);
                }
                list = disguise.getWatcher().convert(list);
            } else {
                for (WrappedWatchableObject obj : disguise.getWatcher().getWatchableObjects()) {
                    if (obj.getIndex() != 0) continue;
                    list.add(obj);
                    break;
                }
            }
            PacketContainer packetBlock = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
            packetBlock.getModifier().write(0, (Object)entity.getEntityId());
            packetBlock.getWatchableCollectionModifier().write(0, list);
            PacketContainer packetUnblock = packetBlock.deepClone();
            for (WrappedWatchableObject watcher : (List)packetUnblock.getWatchableCollectionModifier().read(0)) {
                watcher.setValue((Object)((byte)((Byte)watcher.getValue() & 0xFFFFFFEF)));
            }
            PacketContainer packet1 = packets.getPackets().get(0);
            packets.clear();
            packets.addPacket(packetUnblock);
            packets.addPacket(packet1);
            packets.addPacket(packetBlock);
        }
    }
}

