/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MushroomCowWatcher;
import me.libraryaddict.disguise.utilities.DisguiseSound;
import me.libraryaddict.disguise.utilities.DisguiseSoundEnums;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.reflection.ClassGetter;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsRemovedIn;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Sound;

public class CompileMethods {
    public static void main(String[] args) {
        CompileMethods.doMethods();
        CompileMethods.doSounds();
    }

    private static void doSounds() {
        ArrayList<String> list = new ArrayList<String>();
        for (DisguiseSoundEnums s : DisguiseSoundEnums.values()) {
            StringBuilder sound = new StringBuilder(s.name());
            for (DisguiseSound.SoundType type : DisguiseSound.SoundType.values()) {
                sound.append(":");
                int i = 0;
                for (Map.Entry<Sound, DisguiseSound.SoundType> values : s.getDisguiseSounds().entrySet()) {
                    if (values.getValue() != type) continue;
                    if (i++ > 0) {
                        sound.append(",");
                    }
                    sound.append(values.getKey().name());
                }
            }
            list.add(sound.toString());
        }
        File soundsFile = new File("target/classes/ANTI_PIRACY_ENCODED_WITH_SOUNDS");
        try (PrintWriter writer = new PrintWriter(soundsFile, "UTF-8");){
            writer.write(StringUtils.join(list, (String)"\n"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void doMethods() {
        ArrayList<Class<?>> classes = ClassGetter.getClassesForPackage(FlagWatcher.class, "me.libraryaddict.disguise.disguisetypes.watchers");
        classes.add(FlagWatcher.class);
        classes.add(MushroomCowWatcher.class);
        ArrayList<String> methods = new ArrayList<String>();
        for (Class<?> c : classes) {
            for (Method method : c.getMethods()) {
                if (method.getParameterTypes().length != 1 || method.getName().startsWith("get") || method.isAnnotationPresent(Deprecated.class) && !method.isAnnotationPresent(NmsRemovedIn.class) || !method.getReturnType().equals(Void.TYPE) || method.getName().equals("removePotionEffect") || !FlagWatcher.class.isAssignableFrom(method.getDeclaringClass()) || LibsPremium.isPremium().booleanValue() && new Random().nextBoolean()) continue;
                int added = -1;
                int removed = -1;
                if (method.isAnnotationPresent(NmsAddedIn.class)) {
                    added = method.getAnnotation(NmsAddedIn.class).val().ordinal();
                } else if (method.getDeclaringClass().isAnnotationPresent(NmsAddedIn.class)) {
                    added = method.getDeclaringClass().getAnnotation(NmsAddedIn.class).val().ordinal();
                }
                if (method.isAnnotationPresent(NmsRemovedIn.class)) {
                    removed = method.getAnnotation(NmsRemovedIn.class).val().ordinal();
                } else if (method.getDeclaringClass().isAnnotationPresent(NmsRemovedIn.class)) {
                    removed = method.getDeclaringClass().getAnnotation(NmsRemovedIn.class).val().ordinal();
                }
                Class<?> param = method.getParameterTypes()[0];
                String s = (added >= 0 || removed >= 0 ? added + ":" + removed + ":" : "") + method.getDeclaringClass().getSimpleName() + ":" + method.getName() + ":" + param.getName();
                if (methods.contains(s)) continue;
                methods.add(s);
            }
        }
        File methodsFile = new File("target/classes/ANTI_PIRACY_ENCRYPTION");
        try {
            PrintWriter writer = new PrintWriter(methodsFile, "UTF-8");
            Object object = null;
            try {
                writer.write(StringUtils.join(methods, (String)"\n"));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (object != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

