/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser.params;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.params.ParamInfo;
import me.libraryaddict.disguise.utilities.parser.params.ParamInfoTypes;
import me.libraryaddict.disguise.utilities.reflection.DisguiseMethods;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.ChatColor;

public class ParamInfoManager {
    private static List<ParamInfo> paramList = new ParamInfoTypes().getParamInfos();
    private static DisguiseMethods disguiseMethods = new DisguiseMethods();

    public static List<ParamInfo> getParamInfos() {
        return paramList;
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        ParamInfo info = ParamInfoManager.getParamInfo(object.getClass());
        if (info == null) {
            throw new IllegalArgumentException(object.getClass() + " is not handled by ParamInfo!");
        }
        return info.toString(object);
    }

    public static ParamInfo getParamInfo(Class c) {
        for (ParamInfo info : ParamInfoManager.getParamInfos()) {
            if (!info.isParam(c)) continue;
            return info;
        }
        return null;
    }

    public static ParamInfo getParamInfo(DisguisePerm disguiseType, String methodName) {
        return ParamInfoManager.getParamInfo(disguiseType.getType(), methodName);
    }

    public static ParamInfo getParamInfo(DisguiseType disguiseType, String methodName) {
        for (Method method : ParamInfoManager.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
            if (!method.getName().toLowerCase().equals(methodName.toLowerCase())) continue;
            return ParamInfoManager.getParamInfo(method.getParameterTypes()[0]);
        }
        return null;
    }

    public static Method[] getDisguiseWatcherMethods(@Nullable Class<? extends FlagWatcher> watcherClass) {
        if (watcherClass == null) {
            return new Method[0];
        }
        ArrayList<Method> methods = new ArrayList<Method>(disguiseMethods.getMethods(watcherClass));
        Iterator<Method> itel = methods.iterator();
        while (itel.hasNext()) {
            String[] method = itel.next();
            if (!ReflectionManager.isSupported((AccessibleObject)method)) {
                itel.remove();
                continue;
            }
            if (ParamInfoManager.getParamInfo(method.getParameterTypes()[0]) != null) continue;
            itel.remove();
        }
        methods.sort((m1, m2) -> {
            int v2;
            int v1 = ParamInfoManager.getValue(m1);
            if (v1 != (v2 = ParamInfoManager.getValue(m2))) {
                return v1 - v2;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(m1.getName(), m2.getName());
        });
        for (String methodName : new String[]{"setSelfDisguiseVisible", "setHideHeldItemFromSelf", "setHideArmorFromSelf", "setHearSelfDisguise", "setHidePlayer", "setExpires"}) {
            try {
                methods.add(Disguise.class.getMethod(methodName, methodName.equals("setExpires") ? Long.TYPE : Boolean.TYPE));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (watcherClass == PlayerWatcher.class) {
            try {
                methods.add(PlayerDisguise.class.getMethod("setNameVisible", Boolean.TYPE));
                methods.add(PlayerDisguise.class.getMethod("setDynamicName", Boolean.TYPE));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return methods.toArray(new Method[0]);
    }

    public static int getValue(Method method) {
        ChatColor methodColor = ChatColor.YELLOW;
        Class<?> declaring = method.getDeclaringClass();
        if (declaring == LivingWatcher.class) {
            return 1;
        }
        if (!FlagWatcher.class.isAssignableFrom(declaring) || declaring == FlagWatcher.class) {
            return 2;
        }
        return 0;
    }
}

