/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.parser.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class LibsDisguisesCommand
implements CommandExecutor,
TabCompleter {
    protected ArrayList<String> filterTabs(ArrayList<String> list, String[] origArgs) {
        if (origArgs.length == 0) {
            return list;
        }
        Iterator<String> itel = list.iterator();
        String label = origArgs[origArgs.length - 1].toLowerCase();
        while (itel.hasNext()) {
            String name = itel.next();
            if (name.toLowerCase().startsWith(label)) continue;
            itel.remove();
        }
        return list;
    }

    protected String[] getArgs(String[] args) {
        ArrayList<String> newArgs = new ArrayList<String>();
        for (int i = 0; i < args.length - 1; ++i) {
            String s = args[i];
            if (s.trim().isEmpty()) continue;
            newArgs.add(s);
        }
        return newArgs.toArray(new String[0]);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            LibsDisguises disguises = LibsDisguises.getInstance();
            String version = disguises.getDescription().getVersion();
            if (!disguises.isReleaseBuild()) {
                version = version + "-";
                if (disguises.isNumberedBuild()) {
                    version = version + "b";
                }
                version = version + disguises.getBuildNo();
            }
            sender.sendMessage(ChatColor.DARK_GREEN + "This server is running Lib's Disguises v" + version + " by libraryaddict, formerly maintained by Byteflux and NavidK0." + (sender.hasPermission("libsdisguises.reload") ? "\nUse " + ChatColor.GREEN + "/libsdisguises reload" + ChatColor.DARK_GREEN + " to reload the config. All disguises will be blown by doing this." : ""));
            if (LibsPremium.isPremium().booleanValue()) {
                sender.sendMessage(ChatColor.DARK_GREEN + "This server supports the plugin developer!");
            }
        } else if (args.length > 0) {
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("libsdisguises.reload")) {
                    sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
                    return true;
                }
                DisguiseConfig.loadConfig();
                sender.sendMessage(LibsMsg.RELOADED_CONFIG.get(new Object[0]));
                return true;
            }
            if (args[0].equalsIgnoreCase("scoreboard") || args[0].equalsIgnoreCase("board")) {
                Scoreboard board;
                Team team;
                Player player;
                if (!sender.hasPermission("libsdisguises.scoreboardtest")) {
                    sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
                    return true;
                }
                if (DisguiseConfig.getPushingOption() == DisguiseConfig.DisguisePushing.IGNORE_SCOREBOARD) {
                    sender.sendMessage(LibsMsg.LIBS_SCOREBOARD_DISABLED.get(new Object[0]));
                }
                if (args.length > 1) {
                    player = Bukkit.getPlayer((String)args[1]);
                    if (player == null) {
                        sender.sendMessage(LibsMsg.CANNOT_FIND_PLAYER.get(args[1]));
                        return true;
                    }
                    if (!DisguiseAPI.isDisguised((Entity)player)) {
                        sender.sendMessage(LibsMsg.DMODPLAYER_NODISGUISE.get(player.getName()));
                        return true;
                    }
                } else if (sender instanceof Player) {
                    player = (Player)sender;
                    if (!DisguiseAPI.isDisguised((Entity)player)) {
                        sender.sendMessage(LibsMsg.NOT_DISGUISED.get(new Object[0]));
                        return true;
                    }
                } else {
                    sender.sendMessage(LibsMsg.NO_CONSOLE.get(new Object[0]));
                    return true;
                }
                if ((team = (board = player.getScoreboard()).getEntryTeam(sender.getName())) == null) {
                    sender.sendMessage(LibsMsg.LIBS_SCOREBOARD_NO_TEAM.get(new Object[0]));
                    return true;
                }
                if (team.getOption(Team.Option.COLLISION_RULE) != Team.OptionStatus.NEVER && team.getOption(Team.Option.COLLISION_RULE) != Team.OptionStatus.FOR_OTHER_TEAMS) {
                    sender.sendMessage(LibsMsg.LIBS_SCOREBOARD_NO_TEAM_PUSH.get(new Object[0]));
                    return true;
                }
                sender.sendMessage(LibsMsg.LIBS_SCOREBOARD_SUCCESS.get(new Object[0]));
                return true;
            }
            if (args[0].equalsIgnoreCase("permtest")) {
                CommandSender player;
                if (!sender.hasPermission("libsdisguises.permtest")) {
                    sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
                    return true;
                }
                if (args.length > 1) {
                    player = Bukkit.getPlayer((String)args[1]);
                    if (player == null) {
                        sender.sendMessage(LibsMsg.CANNOT_FIND_PLAYER.get(args[1]));
                        return true;
                    }
                } else {
                    player = sender;
                }
                DisguisePermissions permissions = new DisguisePermissions((Permissible)player, "disguise");
                sender.sendMessage(LibsMsg.LIBS_PERM_CHECK_INFO_1.get(new Object[0]));
                sender.sendMessage(LibsMsg.LIBS_PERM_CHECK_INFO_2.get(new Object[0]));
                if (player.hasPermission("libsdisguises.disguise.pig")) {
                    sender.sendMessage(LibsMsg.NORMAL_PERM_CHECK_SUCCESS.get(new Object[0]));
                    if (permissions.isAllowedDisguise(new DisguisePerm(DisguiseType.PIG))) {
                        sender.sendMessage(LibsMsg.LIBS_PERM_CHECK_SUCCESS.get(new Object[0]));
                    } else {
                        sender.sendMessage(LibsMsg.LIBS_PERM_CHECK_FAIL.get(new Object[0]));
                    }
                } else {
                    sender.sendMessage(LibsMsg.NORMAL_PERM_CHECK_FAIL.get(new Object[0]));
                }
            } else if (args[0].equalsIgnoreCase("json") || args[0].equalsIgnoreCase("gson") || args[0].equalsIgnoreCase("item") || args[0].equalsIgnoreCase("parse") || args[0].equalsIgnoreCase("tostring")) {
                if (!sender.hasPermission("libsdisguises.json")) {
                    sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
                    return true;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(LibsMsg.NO_CONSOLE.get(new Object[0]));
                    return true;
                }
                ItemStack item = ((Player)sender).getInventory().getItemInMainHand();
                String gson = DisguiseUtilities.getGson().toJson((Object)item);
                String simple = ParamInfoManager.toString(item);
                this.sendMessage(sender, LibsMsg.ITEM_SERIALIZED, gson);
                if (!gson.equals(simple)) {
                    this.sendMessage(sender, LibsMsg.ITEM_SIMPLE_STRING, simple);
                }
            } else if (args[0].equalsIgnoreCase("metainfo") || args[0].equalsIgnoreCase("meta")) {
                if (!sender.hasPermission("libsdisguises.metainfo")) {
                    sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
                    return true;
                }
                if (args.length > 1) {
                    MetaIndex index = MetaIndex.getMetaIndexByName(args[1]);
                    if (index == null) {
                        sender.sendMessage(LibsMsg.META_NOT_FOUND.get(new Object[0]));
                        return true;
                    }
                    sender.sendMessage(index.toString());
                } else {
                    ArrayList<String> names = new ArrayList<String>();
                    for (MetaIndex index : MetaIndex.values()) {
                        names.add(MetaIndex.getName(index));
                    }
                    names.sort(String::compareToIgnoreCase);
                    ComponentBuilder builder = new ComponentBuilder("").appendLegacy(LibsMsg.META_VALUES.get(new Object[0]));
                    Iterator itel = names.iterator();
                    while (itel.hasNext()) {
                        String name = (String)itel.next();
                        builder.appendLegacy(name);
                        builder.event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmd.getName() + " metainfo " + name));
                        builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("").appendLegacy(LibsMsg.META_CLICK_SHOW.get(name)).create()));
                        if (!itel.hasNext()) continue;
                        builder.appendLegacy(LibsMsg.META_VALUE_SEPERATOR.get(new Object[0]));
                    }
                    sender.spigot().sendMessage(builder.create());
                }
            } else {
                sender.sendMessage(LibsMsg.LIBS_COMMAND_WRONG_ARG.get(new Object[0]));
            }
        }
        return true;
    }

    private void sendMessage(CommandSender sender, LibsMsg prefix, String string) {
        int start = 0;
        int msg = 1;
        ComponentBuilder builder = new ComponentBuilder("").appendLegacy(prefix.get(new Object[0]));
        while (start < string.length()) {
            int end = Math.min(256, string.length() - start);
            String sub = string.substring(start, start + end);
            builder.append(" ");
            if (string.length() <= 256) {
                builder.appendLegacy(LibsMsg.CLICK_TO_COPY_DATA.get(new Object[0]));
            } else {
                builder.reset();
                builder.appendLegacy(LibsMsg.CLICK_COPY.get(msg));
            }
            start += end;
            builder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, sub));
            builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(LibsMsg.CLICK_TO_COPY_HOVER.get(new Object[0]) + " " + msg).create()));
            ++msg;
        }
        sender.spigot().sendMessage(builder.create());
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs = new ArrayList<String>();
        String[] args = this.getArgs(origArgs);
        if (args.length == 0) {
            tabs.add("Reload");
        }
        return this.filterTabs(tabs, origArgs);
    }
}

