/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LibsPackets {
    private ArrayList<PacketContainer> packets = new ArrayList();
    private HashMap<Integer, ArrayList<PacketContainer>> delayedPackets = new HashMap();
    private boolean isSpawnPacket;
    private Disguise disguise;
    private boolean doNothing;
    private int removeMetaAt = -1;

    public LibsPackets(Disguise disguise) {
        this.disguise = disguise;
    }

    public void setUnhandled() {
        this.doNothing = true;
    }

    public void setRemoveMetaAt(int tick) {
        this.removeMetaAt = tick;
    }

    public boolean isUnhandled() {
        return this.doNothing;
    }

    public Disguise getDisguise() {
        return this.disguise;
    }

    public void setSpawnPacketCheck(PacketType type) {
        this.isSpawnPacket = type.name().contains("SPAWN") && type.name().contains("ENTITY");
    }

    public void addPacket(PacketContainer packet) {
        this.packets.add(packet);
    }

    public void addDelayedPacket(PacketContainer packet) {
        this.addDelayedPacket(packet, 2);
    }

    public void clear() {
        this.getPackets().clear();
    }

    public void addDelayedPacket(PacketContainer packet, int ticksDelayed) {
        if (!this.delayedPackets.containsKey(ticksDelayed)) {
            this.delayedPackets.put(ticksDelayed, new ArrayList());
        }
        this.delayedPackets.get(ticksDelayed).add(packet);
    }

    public ArrayList<PacketContainer> getPackets() {
        return this.packets;
    }

    public Collection<ArrayList<PacketContainer>> getDelayedPackets() {
        return this.delayedPackets.values();
    }

    public void sendDelayed(Player observer) {
        for (Map.Entry<Integer, ArrayList<PacketContainer>> entry : this.delayedPackets.entrySet()) {
            boolean isRemoveCancel = this.isSpawnPacket && entry.getKey() >= this.removeMetaAt && this.removeMetaAt >= 0;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                if (isRemoveCancel) {
                    PacketsManager.getPacketsHandler().removeCancel(this.disguise, observer);
                }
                try {
                    for (PacketContainer packet : (ArrayList)entry.getValue()) {
                        ProtocolLibrary.getProtocolManager().sendServerPacket(observer, packet, false);
                    }
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }, (long)entry.getKey().intValue());
        }
    }
}

