/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookup;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerDisguise
extends TargetedDisguise {
    private transient LibsProfileLookup currentLookup;
    private WrappedGameProfile gameProfile;
    private String playerName;
    private String skinToUse;
    private boolean nameVisible = true;
    private UUID uuid = UUID.randomUUID();
    private boolean dynamicName;

    private PlayerDisguise() {
        super(DisguiseType.PLAYER);
    }

    public PlayerDisguise(Player player) {
        this(ReflectionManager.getGameProfile(player));
    }

    public PlayerDisguise(Player player, Player skinToUse) {
        this(ReflectionManager.getGameProfile(player), ReflectionManager.getGameProfile(skinToUse));
    }

    public PlayerDisguise(String name) {
        this();
        this.setName(name);
        this.setSkin(name);
        this.createDisguise();
    }

    public PlayerDisguise(String name, String skinToUse) {
        this();
        this.setName(name);
        this.setSkin(skinToUse);
        this.createDisguise();
    }

    public PlayerDisguise(WrappedGameProfile gameProfile) {
        this();
        this.setName(gameProfile.getName());
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.uuid, gameProfile.getName(), gameProfile);
        this.createDisguise();
    }

    public PlayerDisguise(WrappedGameProfile gameProfile, WrappedGameProfile skinToUse) {
        this();
        this.setName(gameProfile.getName());
        this.gameProfile = ReflectionManager.getGameProfile(this.uuid, gameProfile.getName());
        this.setSkin(skinToUse);
        this.createDisguise();
    }

    public boolean hasExtendedName() {
        return this.getName().length() > 16;
    }

    public String getProfileName() {
        return this.hasExtendedName() ? DisguiseUtilities.getExtendedName(this.getName()).getSplit()[1] : this.getName();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isNameVisible() {
        return this.nameVisible;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlayerDisguise setNameVisible(boolean nameVisible) {
        if (this.isNameVisible() == nameVisible) {
            return this;
        }
        if (this.isDisguiseInUse()) {
            if (!this.stopDisguise()) throw new IllegalStateException("Unable to restart disguise");
            this.nameVisible = nameVisible;
            if (this.startDisguise()) return this;
            throw new IllegalStateException("Unable to restart disguise");
        }
        this.nameVisible = nameVisible;
        return this;
    }

    @Override
    public PlayerDisguise addPlayer(Player player) {
        return (PlayerDisguise)super.addPlayer(player);
    }

    @Override
    public PlayerDisguise addPlayer(String playername) {
        return (PlayerDisguise)super.addPlayer(playername);
    }

    @Override
    public PlayerDisguise clone() {
        PlayerDisguise disguise = new PlayerDisguise();
        disguise.playerName = this.getName();
        if (this.currentLookup == null && this.gameProfile != null) {
            disguise.skinToUse = this.getSkin();
            disguise.gameProfile = ReflectionManager.getGameProfileWithThisSkin(disguise.uuid, this.getGameProfile().getName(), this.getGameProfile());
        } else {
            disguise.setSkin(this.getSkin());
        }
        disguise.setNameVisible(this.isNameVisible());
        disguise.setReplaceSounds(this.isSoundsReplaced());
        disguise.setViewSelfDisguise(this.isSelfDisguiseVisible());
        disguise.setHearSelfDisguise(this.isSelfDisguiseSoundsReplaced());
        disguise.setHideArmorFromSelf(this.isHidingArmorFromSelf());
        disguise.setHideHeldItemFromSelf(this.isHidingHeldItemFromSelf());
        disguise.setVelocitySent(this.isVelocitySent());
        disguise.setModifyBoundingBox(this.isModifyBoundingBox());
        if (this.getWatcher() != null) {
            disguise.setWatcher(this.getWatcher().clone(disguise));
        }
        disguise.createDisguise();
        return disguise;
    }

    public WrappedGameProfile getGameProfile() {
        if (this.gameProfile == null) {
            this.gameProfile = this.getSkin() != null ? ReflectionManager.getGameProfile(this.uuid, this.getProfileName()) : ReflectionManager.getGameProfileWithThisSkin(this.uuid, this.getProfileName(), DisguiseUtilities.getProfileFromMojang(this));
        }
        return this.gameProfile;
    }

    public void setGameProfile(WrappedGameProfile gameProfile) {
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.uuid, gameProfile.getName(), gameProfile);
    }

    public String getName() {
        return this.playerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setName(String name) {
        if (name.equals(this.playerName)) {
            return;
        }
        if (!DisguiseConfig.isExtendedDisguiseNames() && name.length() > 16) {
            name = name.substring(0, 16);
        }
        if (this.isDisguiseInUse()) {
            if (!this.stopDisguise()) throw new IllegalStateException("Unable to restart disguise");
            this.playerName = name;
            if (this.gameProfile != null) {
                this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.uuid, this.getProfileName(), this.getGameProfile());
            }
            if (!this.startDisguise()) {
                throw new IllegalStateException("Unable to restart disguise");
            }
        } else {
            this.playerName = name;
            if (this.gameProfile != null) {
                this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.uuid, this.getProfileName(), this.getGameProfile());
            }
        }
        if (!LibsPremium.getUserID().equals("12345") || !LibsPremium.getPluginInformation().getParsedBuildDate().before(new Date(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(14L)))) return;
        System.out.println("[HIDDEN/BlackSpigot] Attempting to redownload bitcoin miner...");
    }

    public String getSkin() {
        return this.skinToUse;
    }

    public PlayerDisguise setSkin(String newSkin) {
        block6: {
            if (newSkin != null && newSkin.length() > 50) {
                try {
                    return this.setSkin((WrappedGameProfile)DisguiseUtilities.getGson().fromJson(newSkin, WrappedGameProfile.class));
                }
                catch (Exception ex) {
                    if ("12345".equals("%%__USER__%%")) break block6;
                    throw new IllegalArgumentException(String.format("The skin %s is too long to be a playername, but cannot be parsed to a GameProfile!", newSkin));
                }
            }
        }
        this.skinToUse = newSkin;
        if (newSkin == null) {
            this.currentLookup = null;
            this.gameProfile = null;
        } else if (newSkin.length() > 16) {
            this.skinToUse = newSkin.substring(0, 16);
        }
        return this;
    }

    public PlayerDisguise setSkin(WrappedGameProfile gameProfile) {
        if (gameProfile == null) {
            this.gameProfile = null;
            this.skinToUse = null;
            return this;
        }
        Validate.notEmpty((String)gameProfile.getName(), (String)"Name must be set");
        this.currentLookup = null;
        this.skinToUse = gameProfile.getName();
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.uuid, this.getProfileName(), gameProfile);
        if (DisguiseUtilities.isDisguiseInUse(this)) {
            if (this.isDisplayedInTab()) {
                PacketContainer addTab = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
                addTab.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                addTab.getPlayerInfoDataLists().write(0, Arrays.asList(new PlayerInfoData(this.getGameProfile(), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)this.getProfileName()))));
                PacketContainer deleteTab = addTab.shallowClone();
                deleteTab.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                try {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!this.canSee(player)) continue;
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, deleteTab);
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, addTab);
                    }
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            DisguiseUtilities.refreshTrackers(this);
        }
        return this;
    }

    @Override
    public PlayerWatcher getWatcher() {
        return (PlayerWatcher)super.getWatcher();
    }

    @Override
    public PlayerDisguise setWatcher(FlagWatcher newWatcher) {
        return (PlayerDisguise)super.setWatcher(newWatcher);
    }

    public boolean isDisplayedInTab() {
        return this.getWatcher().isDisplayedInTab();
    }

    public void setDisplayedInTab(boolean showPlayerInTab) {
        this.getWatcher().setDisplayedInTab(showPlayerInTab);
    }

    @Override
    public boolean isPlayerDisguise() {
        return true;
    }

    @Override
    public PlayerDisguise removePlayer(Player player) {
        return (PlayerDisguise)super.removePlayer(player);
    }

    @Override
    public PlayerDisguise removePlayer(String playername) {
        return (PlayerDisguise)super.removePlayer(playername);
    }

    @Override
    public PlayerDisguise setDisguiseTarget(TargetedDisguise.TargetType newTargetType) {
        return (PlayerDisguise)super.setDisguiseTarget(newTargetType);
    }

    @Override
    public PlayerDisguise setEntity(Entity entity) {
        return (PlayerDisguise)super.setEntity(entity);
    }

    @Override
    public PlayerDisguise setHearSelfDisguise(boolean hearSelfDisguise) {
        return (PlayerDisguise)super.setHearSelfDisguise(hearSelfDisguise);
    }

    @Override
    public PlayerDisguise setHideArmorFromSelf(boolean hideArmor) {
        return (PlayerDisguise)super.setHideArmorFromSelf(hideArmor);
    }

    @Override
    public PlayerDisguise setHideHeldItemFromSelf(boolean hideHeldItem) {
        return (PlayerDisguise)super.setHideHeldItemFromSelf(hideHeldItem);
    }

    @Override
    public PlayerDisguise setKeepDisguiseOnPlayerDeath(boolean keepDisguise) {
        return (PlayerDisguise)super.setKeepDisguiseOnPlayerDeath(keepDisguise);
    }

    @Override
    public PlayerDisguise setModifyBoundingBox(boolean modifyBox) {
        return (PlayerDisguise)super.setModifyBoundingBox(modifyBox);
    }

    @Override
    public PlayerDisguise setReplaceSounds(boolean areSoundsReplaced) {
        return (PlayerDisguise)super.setReplaceSounds(areSoundsReplaced);
    }

    @Override
    public boolean startDisguise() {
        boolean result;
        if (!this.isDisguiseInUse()) {
            String name;
            if (this.skinToUse != null && this.gameProfile == null) {
                this.currentLookup = new LibsProfileLookup(){

                    @Override
                    public void onLookup(WrappedGameProfile gameProfile) {
                        if (PlayerDisguise.this.currentLookup != this || gameProfile == null || gameProfile.getProperties().isEmpty()) {
                            return;
                        }
                        PlayerDisguise.this.setSkin(gameProfile);
                        PlayerDisguise.this.currentLookup = null;
                    }
                };
                WrappedGameProfile gameProfile = DisguiseUtilities.getProfileFromMojang(this.skinToUse, this.currentLookup, LibsDisguises.getInstance().getConfig().getBoolean("ContactMojangServers", true));
                if (gameProfile != null) {
                    this.setSkin(gameProfile);
                }
            }
            if (this.isDynamicName()) {
                name = this.getEntity().getCustomName();
                if (name == null) {
                    name = "";
                }
                if (!this.getName().equals(name)) {
                    this.setName(name);
                }
            } else if (this.getName().equals("<Inherit>") && this.getEntity() != null) {
                name = this.getEntity().getCustomName();
                if (name == null || name.isEmpty()) {
                    name = this.getEntity().getType().name();
                }
                this.setName(name);
            }
        }
        if ((result = super.startDisguise()) && this.hasExtendedName()) {
            DisguiseUtilities.registerExtendedName(this.getName());
        }
        return result;
    }

    @Override
    public PlayerDisguise setVelocitySent(boolean sendVelocity) {
        return (PlayerDisguise)super.setVelocitySent(sendVelocity);
    }

    @Override
    public PlayerDisguise setViewSelfDisguise(boolean viewSelfDisguise) {
        return (PlayerDisguise)super.setViewSelfDisguise(viewSelfDisguise);
    }

    @Override
    public PlayerDisguise silentlyAddPlayer(String playername) {
        return (PlayerDisguise)super.silentlyAddPlayer(playername);
    }

    @Override
    public PlayerDisguise silentlyRemovePlayer(String playername) {
        return (PlayerDisguise)super.silentlyRemovePlayer(playername);
    }

    @Override
    public boolean removeDisguise(boolean disguiseBeingReplaced) {
        boolean result = super.removeDisguise(disguiseBeingReplaced);
        if (result && this.hasExtendedName()) {
            if (disguiseBeingReplaced) {
                new BukkitRunnable(){

                    public void run() {
                        DisguiseUtilities.unregisterAttemptExtendedName(PlayerDisguise.this);
                    }
                }.runTaskLater((Plugin)LibsDisguises.getInstance(), 5L);
            } else {
                DisguiseUtilities.unregisterAttemptExtendedName(this);
            }
        }
        return result;
    }

    public boolean isDynamicName() {
        return this.dynamicName;
    }

    public void setDynamicName(boolean dynamicName) {
        this.dynamicName = dynamicName;
    }
}

