/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public enum DisguiseType {
    AREA_EFFECT_CLOUD(3, 0),
    ARMOR_STAND(78),
    ARROW(60, 0),
    BAT(new int[0]),
    BEE(new int[0]),
    BLAZE(new int[0]),
    BOAT(1),
    CAT(new int[0]),
    CAVE_SPIDER(new int[0]),
    CHICKEN(new int[0]),
    COD(new int[0]),
    COW(new int[0]),
    CREEPER(new int[0]),
    DOLPHIN(new int[0]),
    DONKEY(new int[0]),
    DRAGON_FIREBALL(93),
    DROWNED(new int[0]),
    DROPPED_ITEM(2, 1),
    EGG(62),
    ELDER_GUARDIAN(new int[0]),
    ENDER_CRYSTAL(51),
    ENDER_DRAGON(new int[0]),
    ENDER_PEARL(65),
    ENDER_SIGNAL(72),
    ENDERMAN(new int[0]),
    ENDERMITE(new int[0]),
    EVOKER(new int[0]),
    EVOKER_FANGS(79),
    EXPERIENCE_ORB(new int[0]),
    FALLING_BLOCK(70),
    FIREBALL(63),
    FIREWORK(76),
    FISHING_HOOK(90),
    FOX(new int[0]),
    GHAST(new int[0]),
    GIANT(new int[0]),
    GUARDIAN(new int[0]),
    HORSE(new int[0]),
    HUSK(new int[0]),
    ILLUSIONER(new int[0]),
    IRON_GOLEM(new int[0]),
    ITEM_FRAME(71),
    LLAMA(new int[0]),
    LLAMA_SPIT(68),
    LEASH_HITCH(77),
    MAGMA_CUBE(new int[0]),
    MINECART(10),
    MINECART_CHEST(10, 1),
    MINECART_COMMAND(10, 6),
    MINECART_FURNACE(10, 2),
    MINECART_HOPPER(10, 5),
    MINECART_MOB_SPAWNER(10, 4),
    MINECART_TNT(10, 3),
    MULE(new int[0]),
    MUSHROOM_COW(new int[0]),
    OCELOT(new int[0]),
    PAINTING(new int[0]),
    PANDA(new int[0]),
    PARROT(new int[0]),
    PHANTOM(new int[0]),
    PIG(new int[0]),
    PIG_ZOMBIE(new int[0]),
    PILLAGER(new int[0]),
    PLAYER(new int[0]),
    POLAR_BEAR(new int[0]),
    PRIMED_TNT(50),
    PUFFERFISH(new int[0]),
    RABBIT(new int[0]),
    RAVAGER(new int[0]),
    SALMON(new int[0]),
    SHEEP(new int[0]),
    SHULKER(new int[0]),
    SHULKER_BULLET(67),
    SILVERFISH(new int[0]),
    SKELETON(new int[0]),
    SKELETON_HORSE(new int[0]),
    SLIME(new int[0]),
    SMALL_FIREBALL(63),
    SNOWBALL(61),
    SNOWMAN(new int[0]),
    SPECTRAL_ARROW(91),
    SPIDER(new int[0]),
    SPLASH_POTION(73, 0),
    SQUID(new int[0]),
    STRAY(new int[0]),
    THROWN_EXP_BOTTLE(75),
    TRIDENT(94, 0),
    TRADER_LLAMA(new int[0]),
    TROPICAL_FISH(new int[0]),
    TURTLE(new int[0]),
    ZOMBIE_HORSE(new int[0]),
    UNKNOWN(new int[0]),
    VEX(new int[0]),
    VILLAGER(new int[0]),
    VINDICATOR(new int[0]),
    WANDERING_TRADER(new int[0]),
    WITCH(new int[0]),
    WITHER(new int[0]),
    WITHER_SKELETON(new int[0]),
    WITHER_SKULL(66),
    WOLF(new int[0]),
    ZOMBIE(new int[0]),
    ZOMBIE_VILLAGER(new int[0]);

    private EntityType entityType;
    private int objectId = -1;
    private int defaultData = 0;
    private int typeId;
    private Class<? extends FlagWatcher> watcherClass;

    public static DisguiseType getType(Entity entity) {
        DisguiseType disguiseType = DisguiseType.getType(entity.getType());
        return disguiseType;
    }

    public static DisguiseType getType(EntityType entityType) {
        for (DisguiseType type : DisguiseType.values()) {
            if (type.getEntityType() != entityType) continue;
            return type;
        }
        return UNKNOWN;
    }

    private DisguiseType(int ... ints) {
        block4: for (int i = 0; i < ints.length; ++i) {
            int value = ints[i];
            switch (i) {
                case 0: {
                    this.objectId = value;
                    continue block4;
                }
                case 1: {
                    this.defaultData = value;
                    continue block4;
                }
            }
        }
        this.setEntityType(EntityType.valueOf((String)this.name()));
    }

    public int getDefaultData() {
        return this.defaultData;
    }

    public Class<? extends Entity> getEntityClass() {
        if (this.entityType != null && this.getEntityType().getEntityClass() != null) {
            return this.getEntityType().getEntityClass();
        }
        return Entity.class;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public Class<? extends FlagWatcher> getWatcherClass() {
        return this.watcherClass;
    }

    public boolean isMisc() {
        return this.getEntityType() != null && !this.getEntityType().isAlive();
    }

    public boolean isMob() {
        return this.getEntityType() != null && this.getEntityType().isAlive() && !this.isPlayer();
    }

    public boolean isPlayer() {
        return this == PLAYER;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    private void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public void setWatcherClass(Class<? extends FlagWatcher> c) {
        this.watcherClass = c;
    }

    public String toReadable() {
        Object[] split = this.name().split("_");
        for (int i = 0; i < split.length; ++i) {
            split[i] = ((String)split[i]).substring(0, 1) + ((String)split[i]).substring(1).toLowerCase();
        }
        return TranslateType.DISGUISES.get(StringUtils.join((Object[])split, (String)" "));
    }
}

