/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class DisguiseModifyEntityCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(LibsMsg.NO_CONSOLE.get(new Object[0]));
            return true;
        }
        DisguisePermissions permissions = this.getPermissions(sender);
        if (!permissions.hasPermissions()) {
            sender.sendMessage(LibsMsg.NO_PERM.get(new Object[0]));
            return true;
        }
        if (args.length == 0) {
            this.sendCommandUsage(sender, permissions);
            return true;
        }
        LibsDisguises.getInstance().getListener().setDisguiseModify(sender.getName(), DisguiseUtilities.split(StringUtils.join((Object[])args, (String)" ")));
        sender.sendMessage(LibsMsg.DMODIFYENT_CLICK.get(DisguiseConfig.getDisguiseEntityExpire()));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        String[] args = this.getPreviousArgs(origArgs);
        DisguisePermissions perms = this.getPermissions(sender);
        if (!perms.hasPermissions()) {
            return new ArrayList<String>();
        }
        ArrayList<String> tabs = new ArrayList<String>();
        for (DisguisePerm perm : perms.getAllowed()) {
            tabs.addAll(this.getTabDisguiseSubOptions(sender, perms, perm, args, 0, this.getCurrentArg(args)));
        }
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, DisguisePermissions permissions) {
        ArrayList<String> allowedDisguises = this.getAllowedDisguises(permissions);
        sender.sendMessage(LibsMsg.DMODENT_HELP1.get(new Object[0]));
        sender.sendMessage(LibsMsg.DMODIFY_HELP3.get(ChatColor.GREEN + StringUtils.join(allowedDisguises, (String)(ChatColor.RED + ", " + ChatColor.GREEN))));
    }
}

