/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.UUID;
import java.util.regex.Pattern;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.mineskin.MineSkinResponse;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookup;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SkinUtils {
    public static void handleFile(final File file, final SkinCallback callback) {
        new BukkitRunnable(){

            public void run() {
                try {
                    final MineSkinResponse response = DisguiseUtilities.getMineSkinAPI().generateFromFile(callback, file);
                    new BukkitRunnable(){

                        public void run() {
                            if (response == null) {
                                return;
                            }
                            if (response.getGameProfile() == null) {
                                callback.onError(LibsMsg.SKIN_API_FAIL, new Object[0]);
                                return;
                            }
                            SkinUtils.handleProfile(response.getGameProfile(), callback);
                        }
                    }.runTask((Plugin)LibsDisguises.getInstance());
                }
                catch (IllegalArgumentException e) {
                    new BukkitRunnable(){

                        public void run() {
                            callback.onError(LibsMsg.SKIN_API_BAD_FILE, new Object[0]);
                        }
                    }.runTask((Plugin)LibsDisguises.getInstance());
                }
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    public static void handleUrl(final String url, final SkinCallback callback) {
        new BukkitRunnable(){

            public void run() {
                final MineSkinResponse response = DisguiseUtilities.getMineSkinAPI().generateFromUrl(callback, url);
                new BukkitRunnable(){

                    public void run() {
                        if (response == null) {
                            return;
                        }
                        if (response.getGameProfile() == null) {
                            callback.onError(LibsMsg.SKIN_API_FAIL, new Object[0]);
                        }
                        SkinUtils.handleProfile(response.getGameProfile(), callback);
                    }
                }.runTask((Plugin)LibsDisguises.getInstance());
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    public static void handleName(final String playerName, final SkinCallback callback) {
        WrappedGameProfile gameProfile = DisguiseUtilities.getProfileFromMojang(playerName, new LibsProfileLookup(){

            @Override
            public void onLookup(WrappedGameProfile gameProfile) {
                if (!Pattern.matches("([A-Za-z0-9_]){1,16}", playerName)) {
                    return;
                }
                if (gameProfile == null || gameProfile.getProperties().isEmpty()) {
                    callback.onError(LibsMsg.CANNOT_FIND_PLAYER_NAME, playerName);
                    return;
                }
                SkinUtils.handleProfile(gameProfile, callback);
            }
        });
        if (gameProfile == null) {
            return;
        }
        if (gameProfile.getProperties().isEmpty()) {
            callback.onError(LibsMsg.CANNOT_FIND_PLAYER_NAME, playerName);
            return;
        }
        SkinUtils.handleProfile(gameProfile, callback);
    }

    public static void handleProfile(GameProfile profile, SkinCallback callback) {
        SkinUtils.handleProfile(WrappedGameProfile.fromHandle((Object)profile), callback);
    }

    public static void handleProfile(WrappedGameProfile profile, SkinCallback callback) {
        callback.onSuccess(profile);
    }

    public static void handleUUID(final UUID uuid, final SkinCallback callback) {
        new BukkitRunnable(){

            public void run() {
                final WrappedGameProfile profile = ReflectionManager.getSkullBlob(new WrappedGameProfile(uuid, "AutoGenerated"));
                new BukkitRunnable(){

                    public void run() {
                        if (profile == null || profile.getProperties().isEmpty()) {
                            callback.onError(LibsMsg.CANNOT_FIND_PLAYER_UUID, uuid.toString());
                            return;
                        }
                        SkinUtils.handleProfile(profile, callback);
                    }
                }.runTask((Plugin)LibsDisguises.getInstance());
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    public static boolean isUsable() {
        return SkinUtils.getUsableStatus() == null;
    }

    public static String getUsableStatus() {
        if (DisguiseUtilities.getMineSkinAPI().isInUse()) {
            return LibsMsg.SKIN_API_IN_USE.get(new Object[0]);
        }
        if (DisguiseUtilities.getMineSkinAPI().nextRequestIn() > 0) {
            return LibsMsg.SKIN_API_TIMER.get(DisguiseUtilities.getMineSkinAPI().nextRequestIn());
        }
        return null;
    }

    public static void grabSkin(String param, SkinCallback callback) {
        if (param.matches("https?:\\/\\/.+")) {
            callback.onInfo(LibsMsg.SKIN_API_USING_URL, new Object[0]);
            SkinUtils.handleUrl(param, callback);
        } else {
            if (!param.matches("[a-zA-Z0-9 -_]+(\\.png)?")) {
                callback.onError(LibsMsg.SKIN_API_INVALID_NAME, new Object[0]);
                return;
            }
            File file = new File(LibsDisguises.getInstance().getDataFolder(), "/Skins/" + param + (param.toLowerCase().endsWith(".png") ? "" : ".png"));
            if (!file.exists()) {
                file = null;
                if (param.toLowerCase().endsWith(".png")) {
                    callback.onError(LibsMsg.SKIN_API_BAD_FILE_NAME, new Object[0]);
                    return;
                }
            }
            if (file != null) {
                callback.onInfo(LibsMsg.SKIN_API_USING_FILE, new Object[0]);
                SkinUtils.handleFile(file, callback);
            } else {
                if (param.contains("-")) {
                    try {
                        UUID uuid = UUID.fromString(param);
                        callback.onInfo(LibsMsg.SKIN_API_USING_UUID, new Object[0]);
                        SkinUtils.handleUUID(uuid, callback);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                callback.onInfo(LibsMsg.SKIN_API_USING_NAME, new Object[0]);
                SkinUtils.handleName(param, callback);
            }
        }
    }

    public static interface SkinCallback {
        public void onError(LibsMsg var1, Object ... var2);

        public void onInfo(LibsMsg var1, Object ... var2);

        public void onSuccess(WrappedGameProfile var1);
    }
}

