/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Monster;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class DisguisePermissions {
    private List<PermissionStorage> disguises = new ArrayList<PermissionStorage>();

    public DisguisePermissions(Permissible permissionHolder, String commandName) {
        this.loadPermissions(permissionHolder, commandName.toLowerCase());
    }

    public boolean hasPermissions() {
        return !this.disguises.isEmpty();
    }

    public Collection<DisguisePerm> getAllowed() {
        ArrayList<DisguisePerm> list = new ArrayList<DisguisePerm>();
        for (PermissionStorage allowed : this.disguises) {
            if (list.contains(allowed.getDisguise())) continue;
            list.add(allowed.getDisguise());
        }
        list.sort((perm1, perm2) -> String.CASE_INSENSITIVE_ORDER.compare(perm1.toReadable(), perm2.toReadable()));
        return list;
    }

    private ParsedPermission parsePermission(String permission) {
        String[] split = permission.split("\\.");
        String disguiseName = split[2];
        DisguisePerm dPerm = DisguiseParser.getDisguisePerm(disguiseName);
        HashMap<String, Boolean> options = this.getOptions(permission);
        if (dPerm != null) {
            return new ParsedPermission(new DisguisePerm[]{dPerm}, options, 0, split[1].equals("*"));
        }
        ArrayList<DisguisePerm> disguisePerms = new ArrayList<DisguisePerm>();
        int inheritance = 0;
        for (DisguisePerm disguisePerm : DisguiseParser.getDisguisePerms()) {
            int inherit = this.getInheritance(disguisePerm, disguiseName);
            if (inherit < 0) continue;
            inheritance = inherit;
            disguisePerms.add(disguisePerm);
        }
        if (disguisePerms.isEmpty()) {
            return null;
        }
        return new ParsedPermission(disguisePerms.toArray(new DisguisePerm[0]), options, (byte)inheritance, split[1].equals("*"));
    }

    private void loadPermissions(Permissible sender, String commandName) {
        String permissionNode = "libsdisguises." + commandName + ".";
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        if (sender.hasPermission("libsdisguises.*.*.*")) {
            permissions.put("libsdisguises.*.*.*", true);
        }
        for (PermissionAttachmentInfo permission : sender.getEffectivePermissions()) {
            String perm = permission.getPermission().toLowerCase();
            String[] split = perm.split("\\.");
            if (split.length < 3 || !split[0].equals("libsdisguises") || !split[1].equals("*") && !split[1].equals(commandName) || permissions.containsKey(perm) && permission.getValue()) continue;
            permissions.put(perm, permission.getValue());
        }
        ArrayList<ParsedPermission> list = new ArrayList<ParsedPermission>();
        for (Map.Entry entry : permissions.entrySet()) {
            ParsedPermission temp = this.parsePermission((String)entry.getKey());
            if (temp == null) continue;
            temp.setNegated((Boolean)entry.getValue() == false);
            list.add(temp);
        }
        list.sort((t1, t2) -> {
            if (t1.isWildcardCommand() != t2.isWildcardCommand()) {
                return Boolean.compare(t2.isWildcardCommand(), t1.isWildcardCommand());
            }
            if (t1.getInheritance() == t2.getInheritance()) {
                return Boolean.compare(t1.isNegated(), t2.isNegated());
            }
            return t2.getInheritance() - t1.getInheritance();
        });
        for (DisguisePerm disguisePerm : DisguiseParser.getDisguisePerms()) {
            boolean disabled = true;
            PermissionStorage storage = new PermissionStorage(disguisePerm);
            byte lastOptionInheritance = -1;
            for (ParsedPermission parsedPermission : list) {
                if (!parsedPermission.isDisguise(disguisePerm)) continue;
                if (parsedPermission.isNegated() && parsedPermission.options.isEmpty()) {
                    disabled = true;
                    continue;
                }
                if (parsedPermission.isNegated() && !parsedPermission.options.values().contains(true)) continue;
                if (!parsedPermission.isNegated()) {
                    if (disabled) {
                        disabled = false;
                    }
                    if (parsedPermission.options.isEmpty() && !DisguiseConfig.isExplicitDisguisePermissions() && (storage.wildcardAllow || lastOptionInheritance != parsedPermission.inheritance)) {
                        storage.wildcardAllow = true;
                    } else if (!storage.permittedOptions.contains("*")) {
                        storage.wildcardAllow = false;
                    }
                }
                for (Map.Entry entry : parsedPermission.options.entrySet()) {
                    boolean allowUse = parsedPermission.isNegated() ? !((Boolean)entry.getValue()).booleanValue() : (Boolean)entry.getValue();
                    storage.permittedOptions.remove(entry.getKey());
                    storage.negatedOptions.remove(entry.getKey());
                    if (((String)entry.getKey()).equals("*")) {
                        storage.permittedOptions.clear();
                        storage.negatedOptions.clear();
                        storage.wildcardAllow = allowUse;
                        if (!allowUse) {
                            storage.permittedOptions.add("nooptions");
                        }
                    }
                    if (allowUse) {
                        storage.permittedOptions.add(entry.getKey());
                        continue;
                    }
                    storage.negatedOptions.add(entry.getKey());
                }
                if (parsedPermission.options.isEmpty()) continue;
                lastOptionInheritance = parsedPermission.inheritance;
            }
            if (disabled) continue;
            if (DisguiseConfig.isDisabledInvisibility()) {
                storage.permittedOptions.remove("setinvisible");
                storage.negatedOptions.add("setinvisible");
            }
            this.disguises.add(storage);
        }
    }

    private int getInheritance(DisguisePerm disguisePerm, String permissionName) {
        DisguiseType disguiseType = disguisePerm.getType();
        if (permissionName.equals("ageable")) {
            if (Ageable.class.isAssignableFrom(disguiseType.getEntityClass())) {
                return 1;
            }
        } else if (permissionName.equals("monster") || permissionName.equals("monsters")) {
            if (Monster.class.isAssignableFrom(disguiseType.getEntityClass())) {
                return 2;
            }
        } else if (permissionName.equals("animal") || permissionName.equals("animals")) {
            if (Animals.class.isAssignableFrom(disguiseType.getEntityClass())) {
                return 2;
            }
        } else if (permissionName.equals("mob")) {
            if (disguiseType.isMob()) {
                return 3;
            }
        } else if (permissionName.equals("misc")) {
            if (disguiseType.isMisc()) {
                return 3;
            }
        } else if (permissionName.equals("*")) {
            return 4;
        }
        return -1;
    }

    private HashMap<String, Boolean> getOptions(String perm) {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        String[] split = perm.split("\\.");
        for (int i = 3; i < split.length; ++i) {
            String option = split[i];
            boolean negated = option.startsWith("-");
            if (negated) {
                option = option.substring(1);
            }
            if (option.equals("baby")) {
                option = "setbaby";
            }
            options.put(option, !negated);
        }
        return options;
    }

    public boolean isAllowedDisguise(DisguisePerm disguisePerm, Collection<String> disguiseOptions) {
        PermissionStorage storage = this.getStorage(disguisePerm);
        if (storage == null) {
            return false;
        }
        if (!(storage.wildcardAllow || storage.permittedOptions.isEmpty() && !storage.negatedOptions.isEmpty() || disguiseOptions.stream().allMatch(option -> storage.permittedOptions.contains(option.toLowerCase())))) {
            return false;
        }
        return disguiseOptions.stream().noneMatch(option -> storage.negatedOptions.contains(option.toLowerCase()));
    }

    public boolean isAllowedDisguise(DisguisePerm disguisePerm) {
        return this.getStorage(disguisePerm) != null;
    }

    private PermissionStorage getStorage(DisguisePerm disguisePerm) {
        return this.disguises.stream().filter(disguise -> disguise.getDisguise().equals(disguisePerm)).findAny().orElse(null);
    }

    class DisguisePermitted {
        private boolean strictAllowed;
        private List<String> optionsAllowed;
        private List<String> optionsForbidden;

        public DisguisePermitted(List<String> optionsAllowed, List<String> optionsForbidden, boolean strict) {
            this.strictAllowed = strict;
            this.optionsAllowed = optionsAllowed;
            this.optionsForbidden = optionsForbidden;
        }

        public boolean isStrictAllowed() {
            return this.strictAllowed;
        }

        public List<String> getOptionsAllowed() {
            return this.optionsAllowed;
        }

        public List<String> getOptionsForbidden() {
            return this.optionsForbidden;
        }
    }

    private class ParsedPermission {
        private Vector<DisguisePerm> disguisePerm;
        private HashMap<String, Boolean> options;
        private boolean negated;
        private byte inheritance;
        private boolean wildcardCommand;

        public ParsedPermission(DisguisePerm[] disguisePerm, HashMap<String, Boolean> options, byte inheritance, boolean wildcardCommand) {
            this.disguisePerm = new Vector<DisguisePerm>(Arrays.asList(disguisePerm));
            this.options = options;
            this.inheritance = inheritance;
            this.wildcardCommand = wildcardCommand;
        }

        public boolean isWildcardCommand() {
            return this.wildcardCommand;
        }

        public boolean isDisguise(DisguisePerm perm) {
            return this.disguisePerm.contains(perm);
        }

        public boolean isNegated() {
            return this.negated;
        }

        public void setNegated(boolean negated) {
            this.negated = negated;
        }

        public byte getInheritance() {
            return this.inheritance;
        }
    }

    private class PermissionStorage {
        private DisguisePerm disguisePerm;
        private List<String> permittedOptions = new ArrayList<String>();
        private List<String> negatedOptions = new ArrayList<String>();
        private boolean wildcardAllow = false;

        public PermissionStorage(DisguisePerm disguisePerm) {
            this.disguisePerm = disguisePerm;
        }

        public DisguisePerm getDisguise() {
            return this.disguisePerm;
        }
    }
}

