/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.parser.params.ParamInfo;
import me.libraryaddict.disguise.utilities.parser.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.potion.PotionEffectType;

public class DisguiseParser {
    private static HashMap<Method, Map.Entry<Method, Object>> defaultWatcherValues = new HashMap();

    public static void createDefaultMethods() {
        try {
            for (DisguiseType type : DisguiseType.values()) {
                Method[] methods;
                TargetedDisguise disguise = type.isMisc() ? new MiscDisguise(type) : (type.isMob() ? new MobDisguise(type) : new PlayerDisguise("Foobar"));
                FlagWatcher watcher = type.getWatcherClass().getConstructor(Disguise.class).newInstance(disguise);
                for (Method setMethod : methods = ParamInfoManager.getDisguiseWatcherMethods(watcher.getClass())) {
                    if (setMethod.getName().equals("addPotionEffect") || setMethod.getName().equals("setSkin") && setMethod.getParameterTypes()[0] == String.class || setMethod.getName().equals("setTarget") && setMethod.getParameterTypes()[0] != Integer.TYPE || setMethod.getName().equals("setItemInMainHand") && setMethod.getParameterTypes()[0] == Material.class) continue;
                    String getName = setMethod.getName().substring(3);
                    getName = getName.equals("HasNectar") ? "hasNectar" : (getName.equals("HasStung") ? "hasStung" : (setMethod.getParameterTypes()[0].isAssignableFrom(Boolean.TYPE) ? "is" + getName : "get" + getName));
                    Method getMethod = null;
                    for (Method m : setMethod.getDeclaringClass().getDeclaredMethods()) {
                        if (!m.getName().equals(getName) || m.getParameterTypes().length > 0 || m.getReturnType() != setMethod.getParameterTypes()[0]) continue;
                        getMethod = m;
                        break;
                    }
                    if (getMethod == null) {
                        DisguiseUtilities.getLogger().severe(String.format("No such method '%s' when looking for the companion of '%s' in '%s'", getName, setMethod.getName(), setMethod.getDeclaringClass().getSimpleName()));
                        continue;
                    }
                    Object defaultValue = null;
                    if (!setMethod.isAnnotationPresent(RandomDefaultValue.class)) {
                        Object invokeWith = watcher;
                        if (!FlagWatcher.class.isAssignableFrom(getMethod.getDeclaringClass())) {
                            invokeWith = disguise;
                        }
                        defaultValue = getMethod.invoke(invokeWith, new Object[0]);
                    }
                    DisguiseParser.addWatcherDefault(setMethod, getMethod, defaultValue);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static String parseToString(Disguise disguise) {
        return DisguiseParser.parseToString(disguise, true);
    }

    public static String parseToString(Disguise disguise, boolean outputSkinData) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(disguise.getType().name());
            if (disguise.isPlayerDisguise()) {
                stringBuilder.append(" ").append(((PlayerDisguise)disguise).getName());
            }
            for (Method m : ParamInfoManager.getDisguiseWatcherMethods(disguise.getType().getWatcherClass())) {
                String valueString;
                if (m.getName().equals("addPotionEffect")) {
                    PotionEffectType[] types;
                    for (PotionEffectType type : types = (PotionEffectType[])m.getDeclaringClass().getMethod("getPotionEffects", new Class[0]).invoke((Object)disguise.getWatcher(), new Object[0])) {
                        if (type == null) continue;
                        stringBuilder.append(" ").append(m.getName()).append(" ").append(type.getName());
                    }
                    continue;
                }
                Map.Entry<Method, Object> entry = defaultWatcherValues.get(m);
                if (entry == null) continue;
                Object invokeWith = m.getDeclaringClass().isInstance(disguise) ? disguise : disguise.getWatcher();
                Object ourValue = entry.getKey().invoke(invokeWith, new Object[0]);
                if ("".equals(ourValue) && m.getName().equals("setCustomName")) {
                    ourValue = null;
                }
                if (m.getName().equals("setSkin") && !outputSkinData) {
                    PlayerDisguise pDisg = (PlayerDisguise)disguise;
                    ourValue = pDisg.getName();
                    if (pDisg.getSkin() != null) {
                        ourValue = pDisg.getSkin();
                    } else if (pDisg.getGameProfile() != null && pDisg.getGameProfile().getName() != null) {
                        ourValue = pDisg.getGameProfile().getName();
                    }
                    if (ourValue.equals(pDisg.getName())) {
                        continue;
                    }
                } else if (!m.isAnnotationPresent(RandomDefaultValue.class) && Objects.deepEquals(entry.getValue(), ourValue)) continue;
                stringBuilder.append(" ").append(m.getName());
                if (ourValue instanceof Boolean && ((Boolean)ourValue).booleanValue()) continue;
                if (ourValue != null) {
                    valueString = ParamInfoManager.getParamInfo(ourValue.getClass()).toString(ourValue);
                    valueString = DisguiseUtilities.quote(valueString);
                } else {
                    valueString = "null";
                }
                stringBuilder.append(" ").append(valueString);
            }
            return stringBuilder.toString();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addWatcherDefault(Method setMethod, Method getMethod, Object object) {
        AbstractMap.SimpleEntry<Method, Object> entry = new AbstractMap.SimpleEntry<Method, Object>(getMethod, object);
        if (defaultWatcherValues.containsKey(setMethod)) {
            Map.Entry<Method, Object> dObj = defaultWatcherValues.get(setMethod);
            if (!Objects.deepEquals(defaultWatcherValues.get(setMethod).getValue(), object)) {
                throw new IllegalStateException(String.format("%s has conflicting values!", setMethod.getName()));
            }
            return;
        }
        defaultWatcherValues.put(setMethod, entry);
    }

    private static void doCheck(CommandSender sender, DisguisePermissions permissions, DisguisePerm disguisePerm, Collection<String> usedOptions) throws DisguiseParseException {
        if (!permissions.isAllowedDisguise(disguisePerm, usedOptions)) {
            throw new DisguiseParseException(LibsMsg.D_PARSE_NOPERM, usedOptions.stream().reduce((first, second) -> second).orElse(null));
        }
    }

    private static HashMap<String, Boolean> getDisguiseOptions(CommandSender sender, String permNode, DisguisePerm type) {
        switch (type.getType()) {
            case PLAYER: 
            case FALLING_BLOCK: 
            case PAINTING: 
            case SPLASH_POTION: 
            case FISHING_HOOK: 
            case DROPPED_ITEM: {
                HashMap<String, Boolean> returns = new HashMap<String, Boolean>();
                String beginning = "libsdisguises.options." + permNode.toLowerCase() + ".";
                for (PermissionAttachmentInfo permission : sender.getEffectivePermissions()) {
                    String[] split;
                    String lowerPerm = permission.getPermission().toLowerCase();
                    if (!lowerPerm.startsWith(beginning) || (split = lowerPerm.substring(beginning.length()).split("\\.")).length <= 1 || !split[0].replace("_", "").equals(type.toReadable().toLowerCase().replace(" ", ""))) continue;
                    for (int i = 1; i < split.length; ++i) {
                        returns.put(split[i], permission.getValue());
                    }
                }
                return returns;
            }
        }
        return new HashMap<String, Boolean>();
    }

    public static DisguisePerm getDisguisePerm(String name) {
        for (DisguisePerm perm : DisguiseParser.getDisguisePerms()) {
            if (!perm.toReadable().replaceAll("[ |_]", "").equalsIgnoreCase(name.replaceAll("[ |_]", ""))) continue;
            return perm;
        }
        if (name.equalsIgnoreCase("p")) {
            return DisguiseParser.getDisguisePerm(DisguiseType.PLAYER.toReadable());
        }
        return null;
    }

    public static DisguisePerm[] getDisguisePerms() {
        DisguisePerm[] perms = new DisguisePerm[DisguiseType.values().length + DisguiseConfig.getCustomDisguises().size()];
        int i = 0;
        for (DisguiseType disguiseType : DisguiseType.values()) {
            perms[i++] = new DisguisePerm(disguiseType);
        }
        for (Map.Entry entry : DisguiseConfig.getCustomDisguises().entrySet()) {
            perms[i++] = (DisguisePerm)entry.getKey();
        }
        return perms;
    }

    public static DisguisePermissions getPermissions(CommandSender sender, String commandName) {
        return new DisguisePermissions((Permissible)sender, commandName);
    }

    private static boolean isDouble(String string) {
        try {
            Float.parseFloat(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static boolean hasPermissionOption(HashMap<String, Boolean> disguiseOptions, String string) {
        if (disguiseOptions.isEmpty()) {
            return true;
        }
        if (disguiseOptions.containsKey(string)) {
            return disguiseOptions.get(string);
        }
        return !disguiseOptions.containsValue(true);
    }

    public static String getName(Entity entity) {
        if (entity == null) {
            return "??";
        }
        if (entity instanceof Player) {
            return entity.getName();
        }
        if (entity.getCustomName() != null && entity.getCustomName().length() > 0) {
            return entity.getCustomName();
        }
        return entity.getName();
    }

    public static String getSkin(CommandSender entity) {
        WrappedGameProfile gameProfile;
        if (entity == null) {
            return "??";
        }
        if (entity instanceof Player && (gameProfile = ReflectionManager.getGameProfile((Player)entity)) != null) {
            return DisguiseUtilities.getGson().toJson((Object)gameProfile);
        }
        return "{}";
    }

    public static String[] parsePlaceholders(String[] args, String userName, String userSkin, String targetName, String targetSkin) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.contains("%user-name%")) {
                arg = arg.replace("%user-name%", userName);
            }
            if (arg.contains("%user-skin%")) {
                arg = arg.replace("%user-skin%", userSkin);
            }
            if (arg.contains("%target-name%")) {
                arg = arg.replace("%target-name%", targetName);
            }
            if (arg.contains("%target-skin%")) {
                arg = arg.replace("%target-skin%", targetSkin);
            }
            args[i] = arg;
        }
        return args;
    }

    public static long parseStringToTime(String string) throws DisguiseParseException {
        if (!(string = string.toLowerCase()).matches("([0-9]+[a-z]+)+")) {
            throw new DisguiseParseException(LibsMsg.PARSE_INVALID_TIME_SEQUENCE, string);
        }
        String[] split = string.split("((?<=[a-zA-Z])(?=[0-9]))|((?<=[0-9])(?=[a-zA-Z]))");
        long time = 0L;
        for (int i = 0; i < split.length; i += 2) {
            String t = split[i + 1];
            long v = Long.parseLong(split[i]);
            if (t.equals("s") || t.equals("sec") || t.equals("secs") || t.equals("seconds")) {
                time += v;
                continue;
            }
            if (t.equals("m") || t.equals("min") || t.equals("minute") || t.equals("minutes")) {
                time += TimeUnit.MINUTES.toSeconds(v);
                continue;
            }
            if (t.equals("h") || t.equals("hour") || t.equals("hours")) {
                time += TimeUnit.HOURS.toSeconds(v);
                continue;
            }
            if (t.equals("d") || t.equals("day") || t.equals("days")) {
                time += TimeUnit.DAYS.toSeconds(v);
                continue;
            }
            if (t.equals("w") || t.equals("week") || t.equals("weeks")) {
                time += TimeUnit.DAYS.toSeconds(v) * 7L;
                continue;
            }
            if (t.equals("mon") || t.equals("month") || t.equals("months")) {
                time += TimeUnit.DAYS.toSeconds(v) * 31L;
                continue;
            }
            if (t.equals("y") || t.equals("year") || t.equals("years")) {
                time += TimeUnit.DAYS.toSeconds(v) * 365L;
                continue;
            }
            throw new DisguiseParseException(LibsMsg.PARSE_INVALID_TIME, t);
        }
        return time;
    }

    public static Disguise parseTestDisguise(CommandSender sender, String permNode, String[] args, DisguisePermissions permissions) throws DisguiseParseException, IllegalAccessException, InvocationTargetException {
        args = Arrays.copyOf(args, args.length);
        String skin = "{\"id\":\"a149f81bf7844f8987c554afdd4db533\",\"name\":\"libraryaddict\",\"properties\":[]}";
        args = DisguiseParser.parsePlaceholders(args, "libraryaddict", skin, "libraryaddict", skin);
        return DisguiseParser.parseDisguise(sender, null, permNode, args, permissions);
    }

    public static Disguise parseDisguise(String disguise) throws IllegalAccessException, InvocationTargetException, DisguiseParseException {
        return DisguiseParser.parseDisguise((CommandSender)Bukkit.getConsoleSender(), null, disguise);
    }

    public static Disguise parseDisguise(CommandSender sender, Entity target, String disguise) throws IllegalAccessException, InvocationTargetException, DisguiseParseException {
        return DisguiseParser.parseDisguise(sender, target, "disguise", DisguiseUtilities.split(disguise), new DisguisePermissions((Permissible)Bukkit.getConsoleSender(), "disguise"));
    }

    public static Disguise parseDisguise(CommandSender sender, Entity target, String permNode, String[] args, DisguisePermissions permissions) throws DisguiseParseException, IllegalAccessException, InvocationTargetException {
        DisguisePerm disguisePerm;
        if (sender instanceof Player) {
            DisguiseUtilities.setCommandsUsed();
        }
        if (!permissions.hasPermissions()) {
            throw new DisguiseParseException(LibsMsg.NO_PERM, new String[0]);
        }
        if (args.length == 0) {
            throw new DisguiseParseException(LibsMsg.PARSE_NO_ARGS, new String[0]);
        }
        int toSkip = 1;
        ArrayList<String> usedOptions = new ArrayList<String>();
        Disguise disguise = null;
        if (args[0].startsWith("@")) {
            if (sender.hasPermission("libsdisguises.disguise.disguiseclone")) {
                disguise = DisguiseUtilities.getClonedDisguise(args[0].toLowerCase());
                if (disguise == null) {
                    throw new DisguiseParseException(LibsMsg.PARSE_NO_REF, args[0]);
                }
            } else {
                throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_REF, new String[0]);
            }
            disguisePerm = new DisguisePerm(disguise.getType());
            if (disguisePerm.isUnknown()) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_DISG_UNKNOWN, new String[0]);
            }
            if (disguisePerm.getEntityType() == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_LOAD, new String[0]);
            }
            if (!permissions.isAllowedDisguise(disguisePerm)) {
                throw new DisguiseParseException(LibsMsg.NO_PERM_DISGUISE, new String[0]);
            }
        } else {
            disguisePerm = DisguiseParser.getDisguisePerm(args[0]);
            Map.Entry<DisguisePerm, String> customDisguise = DisguiseConfig.getRawCustomDisguise(args[0]);
            if (customDisguise != null) {
                args = DisguiseUtilities.split(customDisguise.getValue());
            }
            args = DisguiseParser.parsePlaceholders(args, sender.getName(), DisguiseParser.getSkin(sender), DisguiseParser.getName(target), DisguiseParser.getSkin((CommandSender)target));
            if (disguisePerm == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_DISG_NO_EXIST, args[0]);
            }
            if (disguisePerm.isUnknown()) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_DISG_UNKNOWN, new String[0]);
            }
            if (disguisePerm.getEntityType() == null) {
                throw new DisguiseParseException(LibsMsg.PARSE_CANT_LOAD, new String[0]);
            }
            if (!permissions.isAllowedDisguise(disguisePerm)) {
                throw new DisguiseParseException(LibsMsg.NO_PERM_DISGUISE, new String[0]);
            }
            HashMap<String, Boolean> disguiseOptions = DisguiseParser.getDisguiseOptions(sender, permNode, disguisePerm);
            if (disguise == null) {
                if (disguisePerm.isPlayer()) {
                    if (args.length == 1) {
                        throw new DisguiseParseException(LibsMsg.PARSE_SUPPLY_PLAYER, new String[0]);
                    }
                    if (!DisguiseParser.hasPermissionOption(disguiseOptions, args[1].toLowerCase())) {
                        throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_NAME, new String[0]);
                    }
                    args[1] = args[1].replace("\\_", " ");
                    disguise = new PlayerDisguise(ChatColor.translateAlternateColorCodes((char)'&', (String)args[1]));
                    ++toSkip;
                } else if (disguisePerm.isMob()) {
                    boolean adult = true;
                    if (args.length > 1 && (args[1].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS.get("baby")) || args[1].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS.get("adult")))) {
                        usedOptions.add("setbaby");
                        DisguiseParser.doCheck(sender, permissions, disguisePerm, usedOptions);
                        adult = args[1].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS.get("adult"));
                        ++toSkip;
                    }
                    disguise = new MobDisguise(disguisePerm.getType(), adult);
                } else if (disguisePerm.isMisc()) {
                    ItemStack itemStack = new ItemStack(Material.STONE);
                    int miscId = -1;
                    if (args.length > 1) {
                        switch (disguisePerm.getType()) {
                            case FALLING_BLOCK: 
                            case DROPPED_ITEM: {
                                Material material = null;
                                for (Material mat : Material.values()) {
                                    if (!mat.name().replace("_", "").equalsIgnoreCase(args[1].replace("_", ""))) continue;
                                    material = mat;
                                    break;
                                }
                                if (material == null) break;
                                itemStack = new ItemStack(material);
                                if (!DisguiseParser.hasPermissionOption(disguiseOptions, itemStack.getType().name().toLowerCase())) {
                                    throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_PARAM, itemStack.getType().name(), disguisePerm.toReadable());
                                }
                                ++toSkip;
                                if (disguisePerm.getType() == DisguiseType.FALLING_BLOCK) {
                                    usedOptions.add("setblock");
                                } else {
                                    usedOptions.add("setitemstack");
                                }
                                DisguiseParser.doCheck(sender, permissions, disguisePerm, usedOptions);
                                break;
                            }
                            case PAINTING: 
                            case SPLASH_POTION: {
                                if (!DisguiseParser.isInteger(args[1])) break;
                                miscId = Integer.parseInt(args[1]);
                                ++toSkip;
                                if (!DisguiseParser.hasPermissionOption(disguiseOptions, miscId + "")) {
                                    throw new DisguiseParseException(LibsMsg.PARSE_NO_PERM_PARAM, miscId + "", disguisePerm.toReadable());
                                }
                                if (disguisePerm.getType() == DisguiseType.PAINTING) {
                                    usedOptions.add("setpainting");
                                } else {
                                    usedOptions.add("setpotionid");
                                }
                                DisguiseParser.doCheck(sender, permissions, disguisePerm, usedOptions);
                                break;
                            }
                        }
                    }
                    disguise = disguisePerm.getType() == DisguiseType.DROPPED_ITEM || disguisePerm.getType() == DisguiseType.FALLING_BLOCK ? new MiscDisguise(disguisePerm.getType(), itemStack) : new MiscDisguise(disguisePerm.getType(), miscId);
                }
            }
        }
        String[] newArgs = new String[args.length - toSkip];
        System.arraycopy(args, toSkip, newArgs, 0, args.length - toSkip);
        DisguiseParser.callMethods(sender, disguise, permissions, disguisePerm, usedOptions, newArgs);
        return disguise;
    }

    public static void callMethods(CommandSender sender, Disguise disguise, DisguisePermissions disguisePermission, DisguisePerm disguisePerm, Collection<String> usedOptions, String[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, DisguiseParseException {
        Method[] methods = ParamInfoManager.getDisguiseWatcherMethods(disguise.getWatcher().getClass());
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            String methodNameProvided = (String)list.remove(0);
            String methodNameJava = TranslateType.DISGUISE_OPTIONS.reverseGet(methodNameProvided);
            Method methodToUse = null;
            Object valueToSet = null;
            DisguiseParseException parseException = null;
            for (Method method : methods) {
                if (!method.getName().equalsIgnoreCase(methodNameJava)) continue;
                Class<?> paramType = method.getParameterTypes()[0];
                ParamInfo paramInfo = ParamInfoManager.getParamInfo(paramType);
                try {
                    int argCount = list.size();
                    if (argCount < paramInfo.getMinArguments()) {
                        throw new DisguiseParseException(LibsMsg.PARSE_NO_OPTION_VALUE, TranslateType.DISGUISE_OPTIONS.reverseGet(method.getName()));
                    }
                    valueToSet = paramInfo.fromString(list);
                    if (valueToSet == null && !paramInfo.canReturnNull()) {
                        throw new IllegalStateException();
                    }
                    argIndex += argCount - list.size();
                    methodToUse = method;
                    break;
                }
                catch (DisguiseParseException ex) {
                    parseException = ex;
                }
                catch (Exception ignored) {
                    parseException = new DisguiseParseException(LibsMsg.PARSE_EXPECTED_RECEIVED, paramInfo.getDescriptiveName(), list.isEmpty() ? null : (String)list.get(0), TranslateType.DISGUISE_OPTIONS.reverseGet(method.getName()));
                }
            }
            if (methodToUse == null) {
                if (parseException != null) {
                    throw parseException;
                }
                throw new DisguiseParseException(LibsMsg.PARSE_OPTION_NA, methodNameProvided);
            }
            if (!usedOptions.contains(methodToUse.getName().toLowerCase())) {
                usedOptions.add(methodToUse.getName().toLowerCase());
            }
            DisguiseParser.doCheck(sender, disguisePermission, disguisePerm, usedOptions);
            if (FlagWatcher.class.isAssignableFrom(methodToUse.getDeclaringClass())) {
                methodToUse.invoke((Object)disguise.getWatcher(), valueToSet);
                continue;
            }
            methodToUse.invoke((Object)disguise, valueToSet);
        }
    }
}

