/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.bukkit.craftbukkit.libs.org.apache.commons.io.IOUtils;

public class UpdateChecker {
    private final String resourceID;
    private String latestVersion;
    private int latestSnapshot;

    public UpdateChecker(String resourceID) {
        this.resourceID = resourceID;
    }

    public void checkSnapshotUpdate(int buildNumber) {
        Map<String, Object> lastBuild = this.fetchLastSnapshotBuild();
        if (lastBuild == null || !lastBuild.containsKey("id") || !lastBuild.containsKey("timestamp")) {
            return;
        }
        int newBuildNumber = Integer.parseInt((String)lastBuild.get("id"));
        if (newBuildNumber <= buildNumber) {
            return;
        }
        Date newBuildDate = new Date(((Number)lastBuild.get("timestamp")).longValue());
        this.latestSnapshot = newBuildNumber;
    }

    public void checkOfficialUpdate(String currentVersion) {
        String version = this.fetchSpigotVersion();
        if (version == null) {
            return;
        }
        if (!this.isNewerVersion(currentVersion, version)) {
            return;
        }
        this.latestVersion = version;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public int getLatestSnapshot() {
        return this.latestSnapshot;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fetchSpigotVersion() {
        try {
            URL url = new URL("https://www.spigotmc.org/api/general.php");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDoOutput(true);
            String body = "key=98BE0FE67F88AB82B4C197FAF1DC3B69206EFDCC4D3B80FC83A00037510B99B4&resource=" + this.resourceID;
            try (OutputStream stream = con.getOutputStream();){
                stream.write(body.getBytes(StandardCharsets.UTF_8));
            }
            throwable = null;
            try (InputStream input = con.getInputStream();){
                String version = IOUtils.toString((InputStream)input);
                if (version.isEmpty()) return null;
                String string = version;
                return string;
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Failed to check for a update on spigot.");
        }
        return null;
    }

    private boolean isNewerVersion(String currentVersion, String newVersion) {
        String[] cSplit = currentVersion.replaceAll("(v)|(-SNAPSHOT)", "").split("\\.");
        String[] nSplit = newVersion.replaceAll("(v)|(-SNAPSHOT)", "").split("\\.");
        for (int i = 0; i < Math.max(cSplit.length, nSplit.length); ++i) {
            if (cSplit.length <= i) {
                return true;
            }
            if (nSplit.length <= i) {
                return false;
            }
            if (cSplit[i].matches("[0-9]+") && nSplit[i].matches("[0-9]+")) {
                int nInt;
                int cInt = Integer.parseInt(cSplit[i]);
                if (cInt == (nInt = Integer.parseInt(nSplit[i]))) continue;
                return cInt < nInt;
            }
            int compareResult = cSplit[i].compareTo(nSplit[i]);
            if (compareResult == 0) continue;
            return compareResult < 0;
        }
        return false;
    }

    private Map<String, Object> fetchLastSnapshotBuild() {
        try {
            Map jsonObject;
            URL url = new URL("https://ci.md-5.net/job/LibsDisguises/lastSuccessfulBuild/api/json");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            try (InputStream input = con.getInputStream();){
                String json = IOUtils.toString((InputStream)input);
                jsonObject = (Map)new Gson().fromJson(json, Map.class);
            }
            return jsonObject;
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Failed to check for a snapshot update on jenkins.");
            return null;
        }
    }
}

