/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.Random;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.VillagerData;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import org.bukkit.entity.Villager;

public class ZombieVillagerWatcher
extends ZombieWatcher {
    public ZombieVillagerWatcher(Disguise disguise) {
        super(disguise);
        this.setProfession(Villager.Profession.values()[new Random().nextInt(Villager.Profession.values().length)]);
    }

    public boolean isShaking() {
        return this.getData(MetaIndex.ZOMBIE_VILLAGER_SHAKING);
    }

    public boolean isVillager() {
        return this.getData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION).getProfession() != Villager.Profession.NONE;
    }

    public void setShaking(boolean shaking) {
        this.setData(MetaIndex.ZOMBIE_VILLAGER_SHAKING, shaking);
        this.sendData(MetaIndex.ZOMBIE_VILLAGER_SHAKING);
    }

    public VillagerData getVillagerData() {
        return this.getData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION);
    }

    public void setVillagerData(VillagerData villagerData) {
        this.setData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION, villagerData);
        this.sendData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION);
    }

    public Villager.Profession getProfession() {
        return this.getVillagerData().getProfession();
    }

    public Villager.Type getType() {
        return this.getVillagerData().getType();
    }

    public int getLevel() {
        return this.getVillagerData().getLevel();
    }

    @RandomDefaultValue
    public void setProfession(Villager.Profession profession) {
        this.setVillagerData(new VillagerData(this.getType(), profession, this.getLevel()));
    }

    @Deprecated
    public void setType(Villager.Type type) {
        this.setVillagerData(new VillagerData(type, this.getProfession(), this.getLevel()));
    }

    @Deprecated
    public void setLevel(int level) {
        this.setVillagerData(new VillagerData(this.getType(), this.getProfession(), this.getLevel()));
    }

    public Villager.Type getBiome() {
        return this.getType();
    }

    public void setBiome(Villager.Type type) {
        this.setType(type);
    }
}

