/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import org.bukkit.inventory.MainHand;

public class PlayerWatcher
extends LivingWatcher {
    private boolean alwaysShowInTab = DisguiseConfig.isShowDisguisedPlayersInTab();

    public PlayerWatcher(Disguise disguise) {
        super(disguise);
        this.setData(MetaIndex.PLAYER_SKIN, MetaIndex.PLAYER_SKIN.getDefault());
    }

    public boolean isDisplayedInTab() {
        return this.alwaysShowInTab;
    }

    public void setDisplayedInTab(boolean showPlayerInTab) {
        if (this.getDisguise().isDisguiseInUse()) {
            throw new IllegalStateException("Cannot set this while disguise is in use!");
        }
        this.alwaysShowInTab = showPlayerInTab;
    }

    @Override
    public PlayerWatcher clone(Disguise disguise) {
        PlayerWatcher watcher = (PlayerWatcher)super.clone(disguise);
        watcher.alwaysShowInTab = this.alwaysShowInTab;
        return watcher;
    }

    public void setMainHand(MainHand mainHand) {
        this.setData(MetaIndex.PLAYER_HAND, (byte)mainHand.ordinal());
        this.sendData(MetaIndex.PLAYER_HAND);
    }

    public MainHand getMainHand() {
        return MainHand.values()[this.getData(MetaIndex.PLAYER_HAND)];
    }

    private boolean isSkinFlag(int i) {
        return (this.getData(MetaIndex.PLAYER_SKIN) & 1 << i) != 0;
    }

    public boolean isCapeEnabled() {
        return this.isSkinFlag(1);
    }

    public boolean isJacketEnabled() {
        return this.isSkinFlag(2);
    }

    public boolean isLeftSleeveEnabled() {
        return this.isSkinFlag(3);
    }

    public boolean isRightSleeveEnabled() {
        return this.isSkinFlag(4);
    }

    public boolean isLeftPantsEnabled() {
        return this.isSkinFlag(5);
    }

    public boolean isRightPantsEnabled() {
        return this.isSkinFlag(6);
    }

    public boolean isHatEnabled() {
        return this.isSkinFlag(7);
    }

    public void setCapeEnabled(boolean enabled) {
        this.setSkinFlags(1, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public void setJacketEnabled(boolean enabled) {
        this.setSkinFlags(2, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public void setLeftSleeveEnabled(boolean enabled) {
        this.setSkinFlags(3, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public void setRightSleeveEnabled(boolean enabled) {
        this.setSkinFlags(4, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public void setLeftPantsEnabled(boolean enabled) {
        this.setSkinFlags(5, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public void setRightPantsEnabled(boolean enabled) {
        this.setSkinFlags(6, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public void setHatEnabled(boolean enabled) {
        this.setSkinFlags(7, enabled);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public WrappedGameProfile getSkin() {
        return ((PlayerDisguise)this.getDisguise()).getGameProfile();
    }

    public void setSkin(String playerName) {
        ((PlayerDisguise)this.getDisguise()).setSkin(playerName);
    }

    @RandomDefaultValue
    public void setSkin(WrappedGameProfile profile) {
        ((PlayerDisguise)this.getDisguise()).setSkin(profile);
    }

    private void setSkinFlags(int i, boolean flag) {
        byte b0 = this.getData(MetaIndex.PLAYER_SKIN);
        if (flag) {
            this.setData(MetaIndex.PLAYER_SKIN, (byte)(b0 | 1 << i));
        } else {
            this.setData(MetaIndex.PLAYER_SKIN, (byte)(b0 & -2 << i));
        }
    }
}

