/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.ItemStack;

public class HorseWatcher
extends AbstractHorseWatcher {
    public HorseWatcher(Disguise disguise) {
        super(disguise);
        this.setStyle(Horse.Style.values()[DisguiseUtilities.random.nextInt(Horse.Style.values().length)]);
        this.setColor(Horse.Color.values()[DisguiseUtilities.random.nextInt(Horse.Color.values().length)]);
    }

    public Horse.Color getColor() {
        return Horse.Color.values()[this.getData(MetaIndex.HORSE_COLOR) & 0xFF];
    }

    public Horse.Style getStyle() {
        return Horse.Style.values()[this.getData(MetaIndex.HORSE_COLOR) >>> 8];
    }

    @RandomDefaultValue
    public void setColor(Horse.Color color) {
        this.setData(MetaIndex.HORSE_COLOR, color.ordinal() & 0xFF | this.getStyle().ordinal() << 8);
        this.sendData(MetaIndex.HORSE_COLOR);
    }

    @RandomDefaultValue
    public void setStyle(Horse.Style style) {
        this.setData(MetaIndex.HORSE_COLOR, this.getColor().ordinal() & 0xFF | style.ordinal() << 8);
        this.sendData(MetaIndex.HORSE_COLOR);
    }

    public void setHorseArmor(ItemStack item) {
        this.getEquipment().setChestplate(item);
    }

    public ItemStack getHorseArmor() {
        return this.getEquipment().getChestplate();
    }
}

