/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.libraryaddict.disguise.commands.DisguiseCommand;
import me.libraryaddict.disguise.commands.DisguiseEntityCommand;
import me.libraryaddict.disguise.commands.DisguiseModifyCommand;
import me.libraryaddict.disguise.commands.DisguiseModifyEntityCommand;
import me.libraryaddict.disguise.commands.DisguiseModifyPlayerCommand;
import me.libraryaddict.disguise.commands.DisguiseModifyRadiusCommand;
import me.libraryaddict.disguise.commands.DisguisePlayerCommand;
import me.libraryaddict.disguise.commands.DisguiseRadiusCommand;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.parser.params.ParamInfo;
import me.libraryaddict.disguise.utilities.parser.params.ParamInfoManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;

public abstract class DisguiseBaseCommand
implements CommandExecutor {
    private static final Map<Class<? extends DisguiseBaseCommand>, String> disguiseCommands;

    protected boolean isNotPremium(CommandSender sender) {
        if (!(!(sender instanceof Player) || sender.isOp() || LibsPremium.isPremium().booleanValue() && LibsPremium.getPaidInformation() != LibsPremium.getPluginInformation())) {
            sender.sendMessage(ChatColor.RED + "Please purchase Lib's Disguises to enable player commands");
            return true;
        }
        return false;
    }

    protected List<String> getTabDisguiseTypes(CommandSender sender, DisguisePermissions perms, String[] allArgs, int startsAt, String currentArg) {
        if (allArgs.length <= startsAt) {
            return this.getAllowedDisguises(perms);
        }
        DisguisePerm disguiseType = DisguiseParser.getDisguisePerm(allArgs[startsAt]);
        if (disguiseType == null) {
            return new ArrayList<String>();
        }
        if (allArgs.length == startsAt + 1 && disguiseType.getType() == DisguiseType.PLAYER && !disguiseType.isCustomDisguise()) {
            ArrayList<String> tabs = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (sender instanceof Player && !((Player)sender).canSee(player)) continue;
                tabs.add(player.getName());
            }
            return tabs;
        }
        return this.getTabDisguiseOptions(sender, perms, disguiseType, allArgs, startsAt + (disguiseType.isPlayer() ? 2 : 1), currentArg);
    }

    protected List<String> getTabDisguiseOptions(CommandSender commandSender, DisguisePermissions perms, DisguisePerm disguisePerm, String[] allArgs, int startsAt, String currentArg) {
        ArrayList<String> usedOptions = new ArrayList<String>();
        Method[] methods = ParamInfoManager.getDisguiseWatcherMethods(disguisePerm.getWatcherClass());
        block0: for (int i = startsAt; i < allArgs.length; ++i) {
            for (Method method : methods) {
                String arg = allArgs[i];
                if (!method.getName().equalsIgnoreCase(arg)) continue;
                usedOptions.add(arg);
                continue block0;
            }
        }
        if (!perms.isAllowedDisguise(disguisePerm, usedOptions)) {
            return new ArrayList<String>();
        }
        return this.getTabDisguiseSubOptions(commandSender, perms, disguisePerm, allArgs, startsAt, currentArg);
    }

    protected List<String> getTabDisguiseSubOptions(CommandSender commandSender, DisguisePermissions perms, DisguisePerm disguisePerm, String[] allArgs, int startsAt, String currentArg) {
        String prevArg;
        ParamInfo info;
        boolean addMethods = true;
        ArrayList<String> tabs = new ArrayList<String>();
        if (allArgs.length > startsAt && (info = ParamInfoManager.getParamInfo(disguisePerm, prevArg = allArgs[allArgs.length - 1])) != null) {
            if (!info.isParam(Boolean.TYPE)) {
                addMethods = false;
            }
            if (info.hasValues()) {
                tabs.addAll(info.getEnums(currentArg));
            } else if (info.isParam(String.class)) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (commandSender instanceof Player && !((Player)commandSender).canSee(player)) continue;
                    tabs.add(player.getName());
                }
            }
        }
        if (addMethods) {
            for (Method method : ParamInfoManager.getDisguiseWatcherMethods(disguisePerm.getWatcherClass())) {
                tabs.add(method.getName());
            }
        }
        return tabs;
    }

    protected List<String> filterTabs(List<String> list, String[] origArgs) {
        if (origArgs.length == 0) {
            return list;
        }
        Iterator<String> itel = list.iterator();
        String label = origArgs[origArgs.length - 1].toLowerCase();
        while (itel.hasNext()) {
            String name = itel.next();
            if (name.toLowerCase().startsWith(label)) continue;
            itel.remove();
        }
        return new ArrayList<String>(new HashSet<String>(list));
    }

    protected String getDisplayName(CommandSender player) {
        Team team = ((Player)player).getScoreboard().getEntryTeam(player.getName());
        if (team == null) {
            return player.getName();
        }
        return team.getPrefix() + team.getColor() + player.getName() + team.getSuffix();
    }

    protected ArrayList<String> getAllowedDisguises(DisguisePermissions permissions) {
        ArrayList<String> allowedDisguises = new ArrayList<String>();
        for (DisguisePerm type : permissions.getAllowed()) {
            if (type.isUnknown()) continue;
            allowedDisguises.add(type.toReadable().replaceAll(" ", "_"));
        }
        return allowedDisguises;
    }

    protected String[] getPreviousArgs(String[] args) {
        ArrayList<String> newArgs = new ArrayList<String>();
        for (int i = 0; i < args.length - 1; ++i) {
            String s = args[i];
            if (s.trim().isEmpty()) continue;
            newArgs.add(s);
        }
        return newArgs.toArray(new String[0]);
    }

    protected String getCurrentArg(String[] args) {
        if (args.length == 0) {
            return "";
        }
        return args[args.length - 1].trim();
    }

    protected static final Map<Class<? extends DisguiseBaseCommand>, String> getCommandNames() {
        return disguiseCommands;
    }

    public final String getPermNode() {
        String name = DisguiseBaseCommand.getCommandNames().get(this.getClass());
        if (name == null) {
            throw new UnsupportedOperationException("Unknown disguise command, perm node not found");
        }
        return name;
    }

    protected DisguisePermissions getPermissions(CommandSender sender) {
        return DisguiseParser.getPermissions(sender, this.getPermNode());
    }

    protected boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected abstract void sendCommandUsage(CommandSender var1, DisguisePermissions var2);

    static {
        HashMap<Class<? extends DisguiseBaseCommand>, String> map = new HashMap<Class<? extends DisguiseBaseCommand>, String>();
        map.put(DisguiseCommand.class, "Disguise");
        map.put(DisguiseEntityCommand.class, "DisguiseEntity");
        map.put(DisguisePlayerCommand.class, "DisguisePlayer");
        map.put(DisguiseRadiusCommand.class, "DisguiseRadius");
        map.put(DisguiseModifyCommand.class, "DisguiseModify");
        map.put(DisguiseModifyEntityCommand.class, "DisguiseModifyEntity");
        map.put(DisguiseModifyPlayerCommand.class, "DisguiseModifyPlayer");
        map.put(DisguiseModifyRadiusCommand.class, "DisguiseModifyRadius");
        disguiseCommands = map;
    }
}

