/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.libs.org.apache.commons.io.FileUtils;
import org.bukkit.entity.Entity;

public class DisguiseConfig {
    private static boolean animationEnabled;
    private static boolean blowDisguisesWhenAttacking;
    private static boolean blowDisguisesWhenAttacked;
    private static boolean collectEnabled;
    private static boolean colorizeSheep;
    private static boolean colorizeWolf;
    private static boolean colorizeCat;
    private static boolean saddleableHorse;
    private static boolean carpetableLlama;
    private static HashMap<DisguisePerm, String> customDisguises;
    private static boolean disableInvisibility;
    private static int disguiseCloneExpire;
    private static int disguiseEntityExpire;
    private static boolean displayPlayerDisguisesInTab;
    private static boolean entityAnimationsAdded;
    private static boolean entityStatusEnabled;
    private static boolean equipmentEnabled;
    private static boolean hearSelfDisguise;
    private static boolean hideDisguisedPlayers;
    private static boolean hidingArmor;
    private static boolean hidingHeldItem;
    private static boolean keepDisguisePlayerDeath;
    private static int maxClonedDisguises;
    private static boolean maxHealthIsDisguisedEntity;
    private static boolean miscDisguisesForLivingEnabled;
    private static boolean modifyBoundingBox;
    private static boolean movementEnabled;
    private static boolean sendsEntityMetadata;
    private static boolean sendVelocity;
    private static boolean showNameAboveHead;
    private static boolean showNameAboveHeadAlwaysVisible;
    private static boolean stopShulkerDisguisesFromMoving;
    private static boolean targetDisguises;
    private static boolean undisguiseSwitchWorlds;
    private static String updateNotificationPermission;
    private static boolean viewSelfDisguise;
    private static boolean witherSkullEnabled;
    private static DisguisePushing disablePushing;
    private static boolean saveCache;
    private static boolean updatePlayerCache;
    private static boolean savePlayerDisguises;
    private static boolean saveEntityDisguises;
    private static boolean useTranslations;
    private static boolean modifyCollisions;
    private static boolean disableFriendlyInvisibles;
    private static boolean warnScoreboardConflict;
    private static boolean explicitDisguisePermissions;
    private static boolean disableCommands;
    private static int uuidGeneratedVersion;
    private static UpdatesBranch updatesBranch;
    private static int playerDisguisesTablistExpires;
    private static boolean dynamicExpiry;
    private static boolean playerHideArmor;

    public static boolean isPlayerHideArmor() {
        return playerHideArmor;
    }

    public static void setPlayerHideArmor(boolean playerHiddenArmor) {
        playerHideArmor = playerHiddenArmor;
    }

    public static boolean isDynamicExpiry() {
        return dynamicExpiry;
    }

    public static void setDynamicExpiry(boolean setDynamicExpiry) {
        dynamicExpiry = setDynamicExpiry;
    }

    public static int getPlayerDisguisesTablistExpires() {
        return playerDisguisesTablistExpires;
    }

    public static void setPlayerDisguisesTablistExpires(int playerDisguisesTablistExpiresTicks) {
        playerDisguisesTablistExpires = playerDisguisesTablistExpiresTicks;
    }

    public static UpdatesBranch getUpdatesBranch() {
        return updatesBranch;
    }

    public static void setUpdatesBranch(UpdatesBranch newBranch) {
        updatesBranch = newBranch;
    }

    public static int getUUIDGeneratedVersion() {
        return uuidGeneratedVersion;
    }

    public static void setUUIDGeneratedVersion(int uuidVersion) {
        uuidGeneratedVersion = uuidVersion;
    }

    public static boolean isDisableCommands() {
        return disableCommands;
    }

    public static boolean isExplicitDisguisePermissions() {
        return explicitDisguisePermissions;
    }

    public static void setExplicitDisguisePermissions(boolean explictDisguisePermission) {
        explicitDisguisePermissions = explictDisguisePermission;
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(String disguise) {
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(disguise);
        if (entry == null) {
            return null;
        }
        try {
            return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise(entry.getValue()));
        }
        catch (IllegalAccessException | InvocationTargetException | DisguiseParseException e) {
            DisguiseUtilities.getLogger().warning("Error when attempting to grab the custom disguise " + disguise);
            e.printStackTrace();
            return null;
        }
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(Entity target, String disguise) throws IllegalAccessException, DisguiseParseException, InvocationTargetException {
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(disguise);
        if (entry == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise((CommandSender)Bukkit.getConsoleSender(), target, entry.getValue()));
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(CommandSender invoker, Entity target, String disguise) throws IllegalAccessException, DisguiseParseException, InvocationTargetException {
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(disguise);
        if (entry == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise(invoker, target, entry.getValue()));
    }

    public static void removeCustomDisguise(String disguise) {
        for (DisguisePerm entry : customDisguises.keySet()) {
            String name = entry.toReadable();
            if (!name.equalsIgnoreCase(disguise) && !name.replaceAll("_", "").equalsIgnoreCase(disguise)) continue;
            customDisguises.remove(entry);
            break;
        }
    }

    public static Map.Entry<DisguisePerm, String> getRawCustomDisguise(String disguise) {
        for (Map.Entry<DisguisePerm, String> entry : customDisguises.entrySet()) {
            String name = entry.getKey().toReadable();
            if (!name.equalsIgnoreCase(disguise) && !name.replaceAll("_", "").equalsIgnoreCase(disguise)) continue;
            return entry;
        }
        return null;
    }

    public static boolean isWarnScoreboardConflict() {
        return warnScoreboardConflict;
    }

    public static void setWarnScoreboardConflict(boolean warnConflict) {
        warnScoreboardConflict = warnConflict;
    }

    public static boolean isModifyCollisions() {
        return modifyCollisions;
    }

    public static boolean isDisableFriendlyInvisibles() {
        return disableFriendlyInvisibles;
    }

    public static void setModifyCollisions(boolean isModifyCollisions) {
        modifyCollisions = isModifyCollisions;
    }

    public static void setDisableFriendlyInvisibles(boolean isDisableFriendlyInvisibles) {
        disableFriendlyInvisibles = isDisableFriendlyInvisibles;
    }

    public static boolean isSavePlayerDisguises() {
        return savePlayerDisguises;
    }

    public static boolean isUseTranslations() {
        return useTranslations;
    }

    public static void setUseTranslations(boolean setUseTranslations) {
        useTranslations = setUseTranslations;
        TranslateType.refreshTranslations();
    }

    public static boolean isSaveEntityDisguises() {
        return saveEntityDisguises;
    }

    public static void setSavePlayerDisguises(boolean saveDisguises) {
        savePlayerDisguises = saveDisguises;
    }

    public static void setSaveEntityDisguises(boolean saveDisguises) {
        saveEntityDisguises = saveDisguises;
    }

    public static DisguisePushing getPushingOption() {
        return disablePushing;
    }

    public static HashMap<DisguisePerm, String> getCustomDisguises() {
        return customDisguises;
    }

    public static int getDisguiseCloneExpire() {
        return disguiseCloneExpire;
    }

    public static int getDisguiseEntityExpire() {
        return disguiseEntityExpire;
    }

    public static int getMaxClonedDisguises() {
        return maxClonedDisguises;
    }

    public static String getUpdateNotificationPermission() {
        return updateNotificationPermission;
    }

    public static boolean isSaveGameProfiles() {
        return saveCache;
    }

    public static void setSaveGameProfiles(boolean doCache) {
        saveCache = doCache;
    }

    public static boolean isUpdateGameProfiles() {
        return updatePlayerCache;
    }

    public static void setUpdateGameProfiles(boolean setUpdatePlayerCache) {
        updatePlayerCache = setUpdatePlayerCache;
    }

    public static void loadConfig() {
        LibsDisguises.getInstance().saveDefaultConfig();
        LibsDisguises.getInstance().reloadConfig();
        File skinsFolder = new File(LibsDisguises.getInstance().getDataFolder(), "Skins");
        if (!skinsFolder.exists()) {
            skinsFolder.mkdir();
            File explain = new File(skinsFolder, "README");
            try {
                explain.createNewFile();
                FileUtils.write((File)explain, (CharSequence)"This folder is used to store .png files for uploading with the /savedisguise or /grabskin commands");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileConfiguration config = LibsDisguises.getInstance().getConfig();
        DisguiseConfig.setSoundsEnabled(config.getBoolean("DisguiseSounds"));
        DisguiseConfig.setVelocitySent(config.getBoolean("SendVelocity"));
        DisguiseConfig.setViewDisguises(config.getBoolean("ViewSelfDisguises"));
        PacketsManager.setViewDisguisesListener(true);
        DisguiseConfig.setHearSelfDisguise(config.getBoolean("HearSelfDisguise"));
        DisguiseConfig.setHideArmorFromSelf(config.getBoolean("RemoveArmor"));
        DisguiseConfig.setHideHeldItemFromSelf(config.getBoolean("RemoveHeldItem"));
        DisguiseConfig.setAddEntityAnimations(config.getBoolean("AddEntityAnimations"));
        DisguiseConfig.setNameOfPlayerShownAboveDisguise(config.getBoolean("ShowNamesAboveDisguises"));
        DisguiseConfig.setNameAboveHeadAlwaysVisible(config.getBoolean("NameAboveHeadAlwaysVisible"));
        DisguiseConfig.setModifyBoundingBox(config.getBoolean("ModifyBoundingBox"));
        DisguiseConfig.setMonstersIgnoreDisguises(config.getBoolean("MonstersIgnoreDisguises"));
        DisguiseConfig.setDisguiseBlownWhenAttacking(config.getBoolean("BlowDisguises", config.getBoolean("BlowDisguisesWhenAttacking")));
        DisguiseConfig.setDisguiseBlownWhenAttacked(config.getBoolean("BlowDisguises", config.getBoolean("BlowDisguisesWhenAttacked")));
        DisguiseConfig.setKeepDisguiseOnPlayerDeath(config.getBoolean("KeepDisguises.PlayerDeath"));
        DisguiseConfig.setMiscDisguisesForLivingEnabled(config.getBoolean("MiscDisguisesForLiving"));
        DisguiseConfig.setMovementPacketsEnabled(config.getBoolean("PacketsEnabled.Movement"));
        DisguiseConfig.setWitherSkullPacketsEnabled(config.getBoolean("PacketsEnabled.WitherSkull"));
        DisguiseConfig.setEquipmentPacketsEnabled(config.getBoolean("PacketsEnabled.Equipment"));
        DisguiseConfig.setAnimationPacketsEnabled(config.getBoolean("PacketsEnabled.Animation"));
        DisguiseConfig.setEntityStatusPacketsEnabled(config.getBoolean("PacketsEnabled.EntityStatus"));
        DisguiseConfig.setCollectPacketsEnabled(config.getBoolean("PacketsEnabled.Collect"));
        DisguiseConfig.setMetadataPacketsEnabled(config.getBoolean("PacketsEnabled.Metadata"));
        DisguiseConfig.setMaxHealthDeterminedByDisguisedEntity(config.getBoolean("MaxHealthDeterminedByEntity"));
        DisguiseConfig.setDisguiseEntityExpire(config.getInt("DisguiseEntityExpire"));
        DisguiseConfig.setDisguiseCloneExpire(config.getInt("DisguiseCloneExpire"));
        DisguiseConfig.setMaxClonedDisguises(config.getInt("DisguiseCloneSize"));
        DisguiseConfig.setSheepDyeable(config.getBoolean("DyeableSheep"));
        DisguiseConfig.setWolfDyeable(config.getBoolean("DyeableWolf"));
        DisguiseConfig.setCatDyeable(config.getBoolean("DyeableCat"));
        DisguiseConfig.setHorseSaddleable(config.getBoolean("SaddleableHorse"));
        DisguiseConfig.setLlamaCarpetable(config.getBoolean("CarpetableLlama"));
        DisguiseConfig.setUndisguiseOnWorldChange(config.getBoolean("UndisguiseOnWorldChange"));
        DisguiseConfig.setUpdateNotificationPermission(config.getString("Permission"));
        DisguiseConfig.setStopShulkerDisguisesFromMoving(config.getBoolean("StopShulkerDisguisesFromMoving", true));
        DisguiseConfig.setHideDisguisedPlayers(config.getBoolean("HideDisguisedPlayersFromTab"));
        DisguiseConfig.setShowDisguisedPlayersInTab(config.getBoolean("ShowPlayerDisguisesInTab"));
        DisguiseConfig.setDisabledInvisibility(config.getBoolean("DisableInvisibility"));
        DisguiseConfig.setSaveGameProfiles(config.getBoolean("SaveGameProfiles"));
        DisguiseConfig.setUpdateGameProfiles(config.getBoolean("UpdateGameProfiles"));
        DisguiseConfig.setSavePlayerDisguises(config.getBoolean("SaveDisguises.Players"));
        DisguiseConfig.setSaveEntityDisguises(config.getBoolean("SaveDisguises.Entities"));
        DisguiseConfig.setUseTranslations(config.getBoolean("Translations"));
        DisguiseConfig.setModifyCollisions(config.getBoolean("Scoreboard.Collisions"));
        DisguiseConfig.setDisableFriendlyInvisibles(config.getBoolean("Scoreboard.DisableFriendlyInvisibles"));
        DisguiseConfig.setWarnScoreboardConflict(config.getBoolean("Scoreboard.WarnConflict"));
        disableCommands = config.getBoolean("DisableCommands");
        DisguiseConfig.setExplicitDisguisePermissions(config.getBoolean("Permissions.ExplicitDisguises"));
        DisguiseConfig.setUUIDGeneratedVersion(config.getInt("UUIDVersion"));
        DisguiseConfig.setPlayerDisguisesTablistExpires(config.getInt("PlayerDisguisesTablistExpires"));
        DisguiseConfig.setDynamicExpiry(config.getBoolean("DynamicExpiry"));
        DisguiseConfig.setPlayerHideArmor(config.getBoolean("PlayerHideArmor"));
        if (!LibsPremium.isPremium().booleanValue() && (DisguiseConfig.isSavePlayerDisguises() || DisguiseConfig.isSaveEntityDisguises())) {
            DisguiseUtilities.getLogger().warning("You must purchase the plugin to use saved disguises!");
        }
        try {
            DisguiseConfig.setUpdatesBranch(UpdatesBranch.valueOf(config.getString("UpdatesBranch").toUpperCase()));
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + config.getString("UpdatesBranch") + "' to a valid option for UpdatesBranch");
        }
        try {
            String option = config.getString("SelfDisguisesScoreboard", DisguisePushing.MODIFY_SCOREBOARD.name()).toUpperCase();
            if (!option.endsWith("_SCOREBOARD")) {
                option = option + "_SCOREBOARD";
            }
            disablePushing = DisguisePushing.valueOf(option);
        }
        catch (Exception ex) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + config.getString("SelfDisguisesScoreboard") + "' to a valid option for SelfDisguisesScoreboard");
        }
        DisguiseConfig.loadCustomDisguises();
        if ("%%__USER__%%".equals("12345")) {
            DisguiseConfig.setSoundsEnabled(false);
            Iterator<Map.Entry<DisguisePerm, String>> itel = DisguiseConfig.getCustomDisguises().entrySet().iterator();
            boolean i = false;
            while (itel.hasNext()) {
                itel.next();
                if (!new Random().nextBoolean()) continue;
                itel.remove();
            }
        }
        int missingConfigs = 0;
        for (String key : config.getDefaultSection().getKeys(true)) {
            if (config.contains(key, true)) continue;
            ++missingConfigs;
        }
        if (missingConfigs > 0) {
            DisguiseUtilities.getLogger().warning("Your config is missing " + missingConfigs + " options! Please consider regenerating your config!");
        }
    }

    static void loadCustomDisguises() {
        customDisguises.clear();
        File disguisesFile = new File("plugins/LibsDisguises/disguises.yml");
        if (!disguisesFile.exists()) {
            return;
        }
        YamlConfiguration disguisesConfig = YamlConfiguration.loadConfiguration((File)disguisesFile);
        ConfigurationSection section = disguisesConfig.getConfigurationSection("Disguises");
        if (section == null) {
            return;
        }
        int failedCustomDisguises = 0;
        for (String key : section.getKeys(false)) {
            String toParse = section.getString(key);
            try {
                DisguiseConfig.addCustomDisguise(key, toParse);
            }
            catch (DisguiseParseException e) {
                ++failedCustomDisguises;
                if (e.getMessage() != null) {
                    DisguiseUtilities.getLogger().severe(e.getMessage());
                }
                if (e.getCause() == null) continue;
                e.printStackTrace();
            }
        }
        if (failedCustomDisguises > 0) {
            DisguiseUtilities.getLogger().severe("Failed to load " + failedCustomDisguises + " custom disguises");
        }
        DisguiseUtilities.getLogger().info("Loaded " + customDisguises.size() + " custom disguise" + (customDisguises.size() == 1 ? "" : "s"));
    }

    public static void addCustomDisguise(String disguiseName, String toParse) throws DisguiseParseException {
        if (DisguiseConfig.getRawCustomDisguise(toParse) != null) {
            throw new DisguiseParseException(LibsMsg.CUSTOM_DISGUISE_NAME_CONFLICT, disguiseName);
        }
        try {
            String[] disguiseArgs = DisguiseUtilities.split(toParse);
            Disguise disguise = DisguiseParser.parseTestDisguise((CommandSender)Bukkit.getConsoleSender(), "disguise", disguiseArgs, DisguiseParser.getPermissions((CommandSender)Bukkit.getConsoleSender(), "disguise"));
            DisguisePerm perm = new DisguisePerm(disguise.getType(), disguiseName);
            customDisguises.put(perm, toParse);
            DisguiseUtilities.getLogger().info("Loaded custom disguise " + disguiseName);
        }
        catch (DisguiseParseException e) {
            throw new DisguiseParseException(LibsMsg.ERROR_LOADING_CUSTOM_DISGUISE, disguiseName, e.getMessage() == null ? "" : ": " + e.getMessage());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            throw new DisguiseParseException(LibsMsg.ERROR_LOADING_CUSTOM_DISGUISE, disguiseName, "");
        }
    }

    public static boolean isAnimationPacketsEnabled() {
        return animationEnabled;
    }

    public static boolean isCollectPacketsEnabled() {
        return collectEnabled;
    }

    public static boolean isDisabledInvisibility() {
        return disableInvisibility;
    }

    public static boolean isDisguiseBlownWhenAttacking() {
        return blowDisguisesWhenAttacking;
    }

    public static boolean isDisguiseBlownWhenAttacked() {
        return blowDisguisesWhenAttacked;
    }

    public static boolean isEntityAnimationsAdded() {
        return entityAnimationsAdded;
    }

    public static boolean isEntityStatusPacketsEnabled() {
        return entityStatusEnabled;
    }

    public static boolean isEquipmentPacketsEnabled() {
        return equipmentEnabled;
    }

    public static boolean isHideDisguisedPlayers() {
        return hideDisguisedPlayers;
    }

    public static boolean isHidingArmorFromSelf() {
        return hidingArmor;
    }

    public static boolean isHidingHeldItemFromSelf() {
        return hidingHeldItem;
    }

    public static boolean isKeepDisguiseOnPlayerDeath() {
        return keepDisguisePlayerDeath;
    }

    public static boolean isMaxHealthDeterminedByDisguisedEntity() {
        return maxHealthIsDisguisedEntity;
    }

    public static boolean isMetadataPacketsEnabled() {
        return sendsEntityMetadata;
    }

    public static boolean isMiscDisguisesForLivingEnabled() {
        return miscDisguisesForLivingEnabled;
    }

    public static boolean isModifyBoundingBox() {
        return modifyBoundingBox;
    }

    public static boolean isMonstersIgnoreDisguises() {
        return targetDisguises;
    }

    public static boolean isMovementPacketsEnabled() {
        return movementEnabled;
    }

    public static boolean isNameAboveHeadAlwaysVisible() {
        return showNameAboveHeadAlwaysVisible;
    }

    public static boolean isNameOfPlayerShownAboveDisguise() {
        return showNameAboveHead;
    }

    public static boolean isSelfDisguisesSoundsReplaced() {
        return hearSelfDisguise;
    }

    public static boolean isSheepDyeable() {
        return colorizeSheep;
    }

    public static boolean isShowDisguisedPlayersInTab() {
        return displayPlayerDisguisesInTab;
    }

    public static boolean isSoundEnabled() {
        return PacketsManager.isHearDisguisesEnabled();
    }

    public static boolean isStopShulkerDisguisesFromMoving() {
        return stopShulkerDisguisesFromMoving;
    }

    public static boolean isUndisguiseOnWorldChange() {
        return undisguiseSwitchWorlds;
    }

    public static boolean isVelocitySent() {
        return sendVelocity;
    }

    public static boolean isViewDisguises() {
        return viewSelfDisguise;
    }

    public static boolean isWitherSkullPacketsEnabled() {
        return witherSkullEnabled;
    }

    public static boolean isWolfDyeable() {
        return colorizeWolf;
    }

    public static void setAddEntityAnimations(boolean isEntityAnimationsAdded) {
        entityAnimationsAdded = isEntityAnimationsAdded;
    }

    public static void setAnimationPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isAnimationPacketsEnabled()) {
            animationEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setCollectPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isCollectPacketsEnabled()) {
            collectEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setDisabledInvisibility(boolean disableInvis) {
        disableInvisibility = disableInvis;
    }

    public static void setDisguiseBlownWhenAttacking(boolean blowDisguise) {
        blowDisguisesWhenAttacking = blowDisguise;
    }

    public static void setDisguiseBlownWhenAttacked(boolean blowDisguise) {
        blowDisguisesWhenAttacked = blowDisguise;
    }

    public static void setDisguiseCloneExpire(int newExpires) {
        disguiseCloneExpire = newExpires;
    }

    public static void setDisguiseEntityExpire(int newExpires) {
        disguiseEntityExpire = newExpires;
    }

    public static void setEntityStatusPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isEntityStatusPacketsEnabled()) {
            entityStatusEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setEquipmentPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isEquipmentPacketsEnabled()) {
            equipmentEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setHearSelfDisguise(boolean replaceSound) {
        if (hearSelfDisguise != replaceSound) {
            hearSelfDisguise = replaceSound;
        }
    }

    public static void setHideArmorFromSelf(boolean hideArmor) {
        if (hidingArmor != hideArmor) {
            hidingArmor = hideArmor;
            PacketsManager.setInventoryListenerEnabled(DisguiseConfig.isHidingHeldItemFromSelf() || DisguiseConfig.isHidingArmorFromSelf());
        }
    }

    public static void setHideDisguisedPlayers(boolean hideDisguisedPlayersInTab) {
        hideDisguisedPlayers = hideDisguisedPlayersInTab;
    }

    public static void setHideHeldItemFromSelf(boolean hideHelditem) {
        if (hidingHeldItem != hideHelditem) {
            hidingHeldItem = hideHelditem;
            PacketsManager.setInventoryListenerEnabled(DisguiseConfig.isHidingHeldItemFromSelf() || DisguiseConfig.isHidingArmorFromSelf());
        }
    }

    public static void setKeepDisguiseOnPlayerDeath(boolean keepDisguise) {
        keepDisguisePlayerDeath = keepDisguise;
    }

    public static void setMaxClonedDisguises(int newMax) {
        maxClonedDisguises = newMax;
    }

    public static void setMaxHealthDeterminedByDisguisedEntity(boolean isDetermined) {
        maxHealthIsDisguisedEntity = isDetermined;
    }

    public static void setMetadataPacketsEnabled(boolean enabled) {
        sendsEntityMetadata = enabled;
    }

    public static void setMiscDisguisesForLivingEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
            miscDisguisesForLivingEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setModifyBoundingBox(boolean modifyBounding) {
        modifyBoundingBox = modifyBounding;
    }

    public static void setMonstersIgnoreDisguises(boolean ignore) {
        targetDisguises = ignore;
    }

    public static void setMovementPacketsEnabled(boolean enabled) {
        if (enabled != DisguiseConfig.isMovementPacketsEnabled()) {
            movementEnabled = enabled;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setNameAboveHeadAlwaysVisible(boolean alwaysVisible) {
        showNameAboveHeadAlwaysVisible = alwaysVisible;
    }

    public static void setNameOfPlayerShownAboveDisguise(boolean showNames) {
        showNameAboveHead = showNames;
    }

    public static void setSheepDyeable(boolean color) {
        colorizeSheep = color;
    }

    public static void setShowDisguisedPlayersInTab(boolean displayPlayerDisguisesInTablist) {
        displayPlayerDisguisesInTab = displayPlayerDisguisesInTablist;
    }

    public static void setSoundsEnabled(boolean isSoundsEnabled) {
        PacketsManager.setHearDisguisesListener(isSoundsEnabled);
    }

    public static void setStopShulkerDisguisesFromMoving(boolean stopShulkerDisguisesFromMoving) {
        DisguiseConfig.stopShulkerDisguisesFromMoving = stopShulkerDisguisesFromMoving;
    }

    public static void setUndisguiseOnWorldChange(boolean isUndisguise) {
        undisguiseSwitchWorlds = isUndisguise;
    }

    public static void setUpdateNotificationPermission(String newPermission) {
        updateNotificationPermission = newPermission;
    }

    public static void setVelocitySent(boolean sendVelocityPackets) {
        sendVelocity = sendVelocityPackets;
    }

    public static void setViewDisguises(boolean seeOwnDisguise) {
        viewSelfDisguise = seeOwnDisguise;
    }

    public static void setWitherSkullPacketsEnabled(boolean enabled) {
        witherSkullEnabled = enabled;
    }

    public static void setWolfDyeable(boolean color) {
        colorizeWolf = color;
    }

    public static void setCatDyeable(boolean color) {
        colorizeCat = color;
    }

    public static boolean isCatDyeable() {
        return colorizeCat;
    }

    public static void setHorseSaddleable(boolean saddle) {
        saddleableHorse = saddle;
    }

    public static boolean isHorseSaddleable() {
        return saddleableHorse;
    }

    public static void setLlamaCarpetable(boolean carpet) {
        carpetableLlama = carpet;
    }

    public static boolean isLlamaCarpetable() {
        return carpetableLlama;
    }

    private DisguiseConfig() {
    }

    static {
        customDisguises = new HashMap();
        disablePushing = DisguisePushing.MODIFY_SCOREBOARD;
        updatesBranch = UpdatesBranch.SAME_BUILDS;
    }

    public static enum UpdatesBranch {
        SAME_BUILDS,
        SNAPSHOTS,
        RELEASES;

    }

    public static enum DisguisePushing {
        MODIFY_SCOREBOARD,
        IGNORE_SCOREBOARD,
        CREATE_SCOREBOARD;

    }
}

