/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.reflection;

import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedParticle;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookupCaller;
import org.apache.commons.io.IOUtils;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class ReflectionManager {
    private static final String bukkitVersion = Bukkit.getServer().getClass().getName().split("\\.")[3];
    private static final Class<?> craftItemClass;
    private static Method damageAndIdleSoundMethod;
    private static final Field entitiesField;
    private static final Constructor<?> boundingBoxConstructor;
    private static final Method setBoundingBoxMethod;
    private static final Method ihmGet;
    private static final Field pingField;
    private static final Field trackerField;
    public static final Field entityCountField;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static YamlConfiguration getPluginYaml(ClassLoader loader) {
        try (InputStream stream = loader.getResourceAsStream("plugin.yml");){
            YamlConfiguration config = new YamlConfiguration();
            config.loadFromString(IOUtils.toString((InputStream)stream, (String)"UTF-8"));
            YamlConfiguration yamlConfiguration = config;
            return yamlConfiguration;
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getNewEntityId() {
        return ReflectionManager.getNewEntityId(true);
    }

    public static int getNewEntityId(boolean increment) {
        try {
            int id = entityCountField.getInt(null);
            if (increment) {
                entityCountField.set(null, id + 1);
            }
            return id;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static Object createEntityInstance(String entityName) {
        try {
            Object entityObject;
            Class entityClass = ReflectionManager.getNmsClass("Entity" + entityName);
            Object world = ReflectionManager.getWorldServer((World)Bukkit.getWorlds().get(0));
            switch (entityName) {
                case "Player": {
                    Object minecraftServer = ReflectionManager.getNmsMethod("MinecraftServer", "getServer", new Class[0]).invoke(null, new Object[0]);
                    Object playerinteractmanager = ReflectionManager.getNmsClass("PlayerInteractManager").getDeclaredConstructor(ReflectionManager.getNmsClass("World")).newInstance(world);
                    WrappedGameProfile gameProfile = ReflectionManager.getGameProfile(new UUID(0L, 0L), "Steve");
                    entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("MinecraftServer"), ReflectionManager.getNmsClass("WorldServer"), gameProfile.getHandleType(), playerinteractmanager.getClass()).newInstance(minecraftServer, world, gameProfile.getHandle(), playerinteractmanager);
                    break;
                }
                case "EnderPearl": {
                    entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), ReflectionManager.getNmsClass("EntityLiving")).newInstance(world, ReflectionManager.createEntityInstance("Cow"));
                    break;
                }
                case "Potion": {
                    entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), Double.TYPE, Double.TYPE, Double.TYPE, ReflectionManager.getNmsClass("ItemStack")).newInstance(world, 0.0, 0.0, 0.0, ReflectionManager.getNmsItem(new ItemStack(Material.SPLASH_POTION)));
                    break;
                }
                case "FishingHook": {
                    entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World"), ReflectionManager.getNmsClass("EntityHuman")).newInstance(world, ReflectionManager.createEntityInstance("Player"));
                    break;
                }
                default: {
                    entityObject = entityClass.getDeclaredConstructor(ReflectionManager.getNmsClass("World")).newInstance(world);
                }
            }
            return entityObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getMobEffectList(int id) {
        Method nmsMethod = ReflectionManager.getNmsMethod("MobEffectList", "fromId", Integer.TYPE);
        try {
            return nmsMethod.invoke(null, id);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object createMobEffect(PotionEffect effect) {
        return ReflectionManager.createMobEffect(effect.getType().getId(), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles());
    }

    public static Object createMobEffect(int id, int duration, int amplification, boolean ambient, boolean particles) {
        try {
            return ReflectionManager.getNmsClass("MobEffect").getDeclaredConstructor(ReflectionManager.getNmsClass("MobEffectList"), Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE).newInstance(ReflectionManager.getMobEffectList(id), duration, amplification, ambient, particles);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FakeBoundingBox getBoundingBox(Entity entity) {
        try {
            Object boundingBox = ReflectionManager.getNmsMethod("Entity", "getBoundingBox", new Class[0]).invoke(ReflectionManager.getNmsEntity(entity), new Object[0]);
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            int stage = 0;
            block10: for (Field field : boundingBox.getClass().getDeclaredFields()) {
                if (!field.getType().getSimpleName().equals("double")) continue;
                switch (++stage) {
                    case 1: {
                        x -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 2: {
                        y -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 3: {
                        z -= field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 4: {
                        x += field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 5: {
                        y += field.getDouble(boundingBox);
                        continue block10;
                    }
                    case 6: {
                        z += field.getDouble(boundingBox);
                        continue block10;
                    }
                    default: {
                        throw new Exception("Error while setting the bounding box, more doubles than I thought??");
                    }
                }
            }
            return new FakeBoundingBox(x, y, z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Entity getBukkitEntity(Object nmsEntity) {
        try {
            return (Entity)ReflectionManager.getNmsMethod("Entity", "getBukkitEntity", new Class[0]).invoke(nmsEntity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ItemStack getBukkitItem(Object nmsItem) {
        try {
            return (ItemStack)craftItemClass.getMethod("asBukkitCopy", ReflectionManager.getNmsClass("ItemStack")).invoke(null, nmsItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getBukkitVersion() {
        return bukkitVersion;
    }

    public static Class<?> getCraftClass(String className) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + ReflectionManager.getBukkitVersion() + "." + className);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getCraftConstructor(Class clazz, Class<?> ... parameters) {
        try {
            Constructor declaredConstructor = clazz.getDeclaredConstructor(parameters);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getCraftConstructor(String className, Class<?> ... parameters) {
        return ReflectionManager.getCraftConstructor(ReflectionManager.getCraftClass(className), parameters);
    }

    public static Object getCraftSound(Sound sound) {
        try {
            return ReflectionManager.getCraftClass("CraftSound").getMethod("getSoundEffect", String.class).invoke(null, ReflectionManager.getSoundString(sound));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getEntityTrackerEntry(Entity target) throws Exception {
        Object world = ReflectionManager.getWorldServer(target.getWorld());
        Object tracker = trackerField.get(world);
        Object trackedEntities = entitiesField.get(tracker);
        return ihmGet.invoke(trackedEntities, target.getEntityId());
    }

    public static Object getMinecraftServer() {
        try {
            return ReflectionManager.getCraftMethod("CraftServer", "getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getEnumArt(Art art) {
        try {
            Object enumArt = ReflectionManager.getCraftClass("CraftArt").getMethod("BukkitToNotch", Art.class).invoke(null, art);
            for (Field field : enumArt.getClass().getDeclaredFields()) {
                if (field.getType() != String.class) continue;
                return (String)field.get(enumArt);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static Object getBlockPosition(int x, int y, int z) {
        try {
            return ReflectionManager.getNmsClass("BlockPosition").getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(x, y, z);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Enum getEnumDirection(int direction) {
        try {
            return (Enum)ReflectionManager.getNmsMethod("EnumDirection", "fromType2", Integer.TYPE).invoke(null, direction);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Enum getEnumPlayerInfoAction(int action) {
        try {
            return (Enum)ReflectionManager.getNmsClass("PacketPlayOutPlayerInfo$EnumPlayerInfoAction").getEnumConstants()[action];
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerInfoData(Object playerInfoPacket, WrappedGameProfile gameProfile) {
        try {
            Object playerListName = ReflectionManager.getNmsClass("ChatComponentText").getDeclaredConstructor(String.class).newInstance(gameProfile.getName());
            return ReflectionManager.getNmsClass("PacketPlayOutPlayerInfo$PlayerInfoData").getDeclaredConstructor(ReflectionManager.getNmsClass("PacketPlayOutPlayerInfo"), gameProfile.getHandleType(), Integer.TYPE, ReflectionManager.getNmsClass("EnumGamemode"), ReflectionManager.getNmsClass("IChatBaseComponent")).newInstance(playerInfoPacket, gameProfile.getHandle(), 0, ReflectionManager.getNmsClass("EnumGamemode").getEnumConstants()[1], playerListName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getGameProfile(Player player) {
        return WrappedGameProfile.fromPlayer((Player)player);
    }

    public static WrappedGameProfile getGameProfile(UUID uuid, String playerName) {
        try {
            return new WrappedGameProfile(uuid != null ? uuid : ReflectionManager.getRandomUUID(), playerName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getClonedProfile(WrappedGameProfile gameProfile) {
        return ReflectionManager.getGameProfileWithThisSkin(null, gameProfile.getName(), gameProfile);
    }

    public static WrappedGameProfile getGameProfileWithThisSkin(UUID uuid, String playerName, WrappedGameProfile profileWithSkin) {
        try {
            WrappedGameProfile gameProfile = new WrappedGameProfile(uuid != null ? uuid : ReflectionManager.getRandomUUID(), playerName);
            if (profileWithSkin != null) {
                gameProfile.getProperties().putAll(profileWithSkin.getProperties());
            }
            return gameProfile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static UUID getRandomUUID() {
        UUID uuid = UUID.randomUUID();
        if (DisguiseConfig.getUUIDGeneratedVersion() == 4) {
            return uuid;
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        bb.put(6, (byte)(bb.get(6) & 0xF));
        bb.put(6, (byte)(bb.get(6) | DisguiseConfig.getUUIDGeneratedVersion()));
        bb.position(0);
        long firstLong = bb.getLong();
        long secondLong = bb.getLong();
        return new UUID(firstLong, secondLong);
    }

    public static Class getNmsClass(String className) {
        try {
            return Class.forName("net.minecraft.server." + ReflectionManager.getBukkitVersion() + "." + className);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class getNmsClassIgnoreErrors(String className) {
        try {
            return Class.forName("net.minecraft.server." + ReflectionManager.getBukkitVersion() + "." + className);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Constructor getNmsConstructor(Class clazz, Class<?> ... parameters) {
        try {
            Constructor declaredConstructor = clazz.getDeclaredConstructor(parameters);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor getNmsConstructor(String className, Class<?> ... parameters) {
        return ReflectionManager.getNmsConstructor(ReflectionManager.getNmsClass(className), parameters);
    }

    public static Object getNmsEntity(Entity entity) {
        try {
            return ReflectionManager.getCraftClass("entity.CraftEntity").getMethod("getHandle", new Class[0]).invoke((Object)entity, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Field getNmsField(Class clazz, String fieldName) {
        try {
            Field declaredField = clazz.getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            return declaredField;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Field getNmsField(String className, String fieldName) {
        return ReflectionManager.getNmsField(ReflectionManager.getNmsClass(className), fieldName);
    }

    public static Object getNmsItem(ItemStack itemstack) {
        try {
            return craftItemClass.getMethod("asNMSCopy", ItemStack.class).invoke(null, itemstack);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getCraftMethod(String className, String methodName, Class<?> ... parameters) {
        return ReflectionManager.getCraftMethod(ReflectionManager.getCraftClass(className), methodName, parameters);
    }

    public static Method getCraftMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Method declaredMethod = clazz.getDeclaredMethod(methodName, parameters);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            Method declaredMethod = clazz.getDeclaredMethod(methodName, parameters);
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getNmsMethod(String className, String methodName, Class<?> ... parameters) {
        return ReflectionManager.getNmsMethod(ReflectionManager.getNmsClass(className), methodName, parameters);
    }

    public static double getPing(Player player) {
        try {
            return pingField.getInt(ReflectionManager.getNmsEntity((Entity)player));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    public static float[] getSize(Entity entity) {
        try {
            float length = ReflectionManager.getNmsField("Entity", "length").getFloat(ReflectionManager.getNmsEntity(entity));
            float width = ReflectionManager.getNmsField("Entity", "width").getFloat(ReflectionManager.getNmsEntity(entity));
            float height = ((Float)ReflectionManager.getNmsMethod("Entity", "getHeadHeight", new Class[0]).invoke(ReflectionManager.getNmsEntity(entity), new Object[0])).floatValue();
            return new float[]{length, width, height};
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static WrappedGameProfile getSkullBlob(WrappedGameProfile gameProfile) {
        try {
            Object minecraftServer = ReflectionManager.getMinecraftServer();
            for (Method method : ReflectionManager.getNmsClass("MinecraftServer").getMethods()) {
                if (!method.getReturnType().getSimpleName().equals("MinecraftSessionService")) continue;
                Object session = method.invoke(minecraftServer, new Object[0]);
                return WrappedGameProfile.fromHandle((Object)session.getClass().getDeclaredMethod("fillProfileProperties", gameProfile.getHandleType(), Boolean.TYPE).invoke(session, gameProfile.getHandle(), true));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static Float getSoundModifier(Object entity) {
        try {
            return (Float)damageAndIdleSoundMethod.invoke(entity, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static WrappedGameProfile grabProfileAddUUID(String playername) {
        try {
            Object minecraftServer = ReflectionManager.getMinecraftServer();
            for (Method method : ReflectionManager.getNmsClass("MinecraftServer").getMethods()) {
                if (!method.getReturnType().getSimpleName().equals("GameProfileRepository")) continue;
                Object agent = Class.forName("com.mojang.authlib.Agent").getDeclaredField("MINECRAFT").get(null);
                LibsProfileLookupCaller callback = new LibsProfileLookupCaller();
                Object profileRepo = method.invoke(minecraftServer, new Object[0]);
                method.getReturnType().getMethod("findProfilesByNames", String[].class, agent.getClass(), Class.forName("com.mojang.authlib.ProfileLookupCallback")).invoke(profileRepo, new String[]{playername}, agent, callback);
                if (callback.getGameProfile() != null) {
                    return callback.getGameProfile();
                }
                return ReflectionManager.getGameProfile(null, playername);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void setBoundingBox(Entity entity, FakeBoundingBox newBox) {
        try {
            Location loc = entity.getLocation();
            Object boundingBox = boundingBoxConstructor.newInstance(loc.getX() - newBox.getX() / 2.0, loc.getY(), loc.getZ() - newBox.getZ() / 2.0, loc.getX() + newBox.getX() / 2.0, loc.getY() + newBox.getY(), loc.getZ() + newBox.getZ() / 2.0);
            setBoundingBoxMethod.invoke(ReflectionManager.getNmsEntity(entity), boundingBox);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Enum getSoundCategory(String category) {
        try {
            Method method = ReflectionManager.getNmsMethod("SoundCategory", "a", new Class[0]);
            for (Enum anEnum : (Enum[])ReflectionManager.getNmsClass("SoundCategory").getEnumConstants()) {
                if (!category.equals(method.invoke((Object)anEnum, new Object[0]))) continue;
                return anEnum;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Enum getSoundCategory(DisguiseType disguiseType) {
        if (disguiseType == DisguiseType.PLAYER) {
            return ReflectionManager.getSoundCategory("player");
        }
        Class entityClass = disguiseType.getEntityType().getEntityClass();
        if (Monster.class.isAssignableFrom(entityClass)) {
            return ReflectionManager.getSoundCategory("hostile");
        }
        if (Ambient.class.isAssignableFrom(entityClass)) {
            return ReflectionManager.getSoundCategory("ambient");
        }
        return ReflectionManager.getSoundCategory("neutral");
    }

    public static Enum createEnumItemSlot(EquipmentSlot slot) {
        T[] enums;
        Class clazz = ReflectionManager.getNmsClass("EnumItemSlot");
        T[] TArray = enums = clazz != null ? clazz.getEnumConstants() : null;
        if (enums == null) {
            return null;
        }
        switch (slot) {
            case HAND: {
                return (Enum)enums[0];
            }
            case OFF_HAND: {
                return (Enum)enums[1];
            }
            case FEET: {
                return (Enum)enums[2];
            }
            case LEGS: {
                return (Enum)enums[3];
            }
            case CHEST: {
                return (Enum)enums[4];
            }
            case HEAD: {
                return (Enum)enums[5];
            }
        }
        return null;
    }

    public static EquipmentSlot createEquipmentSlot(Object enumItemSlot) {
        try {
            Enum nmsSlot = (Enum)enumItemSlot;
            switch (nmsSlot.name()) {
                case "MAINHAND": {
                    return EquipmentSlot.HAND;
                }
                case "OFFHAND": {
                    return EquipmentSlot.OFF_HAND;
                }
                case "FEET": {
                    return EquipmentSlot.FEET;
                }
                case "LEGS": {
                    return EquipmentSlot.LEGS;
                }
                case "CHEST": {
                    return EquipmentSlot.CHEST;
                }
                case "HEAD": {
                    return EquipmentSlot.HEAD;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ItemStack getEquipment(EquipmentSlot slot, Entity disguisedEntity) {
        if (!(disguisedEntity instanceof LivingEntity)) {
            return null;
        }
        switch (slot) {
            case HAND: {
                return ((LivingEntity)disguisedEntity).getEquipment().getItemInMainHand();
            }
            case OFF_HAND: {
                return ((LivingEntity)disguisedEntity).getEquipment().getItemInOffHand();
            }
            case FEET: {
                return ((LivingEntity)disguisedEntity).getEquipment().getBoots();
            }
            case LEGS: {
                return ((LivingEntity)disguisedEntity).getEquipment().getLeggings();
            }
            case CHEST: {
                return ((LivingEntity)disguisedEntity).getEquipment().getChestplate();
            }
            case HEAD: {
                return ((LivingEntity)disguisedEntity).getEquipment().getHelmet();
            }
        }
        return null;
    }

    public static Object getSoundString(Sound sound) {
        try {
            return ReflectionManager.getCraftMethod("CraftSound", "getSound", Sound.class).invoke(null, sound);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object convertInvalidMeta(Object value) {
        if (value instanceof Optional) {
            Optional opt = (Optional)value;
            if (!opt.isPresent()) {
                return value;
            }
            Object val = opt.get();
            if (val instanceof BlockPosition) {
                BlockPosition pos = (BlockPosition)val;
                try {
                    return Optional.of(ReflectionManager.getNmsConstructor("BlockPosition", Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(pos.getX(), pos.getY(), pos.getZ()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (val instanceof WrappedBlockData) {
                try {
                    return Optional.of(((WrappedBlockData)val).getHandle());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                if (val instanceof ItemStack) {
                    if ((val = ReflectionManager.getNmsItem((ItemStack)val)) == null) {
                        return Optional.empty();
                    }
                    return Optional.of(val);
                }
                if (val instanceof WrappedChatComponent) {
                    return Optional.of(((WrappedChatComponent)val).getHandle());
                }
            }
        } else if (value instanceof Vector3F) {
            Vector3F angle = (Vector3F)value;
            try {
                return ReflectionManager.getNmsConstructor("Vector3f", Float.TYPE, Float.TYPE, Float.TYPE).newInstance(Float.valueOf(angle.getX()), Float.valueOf(angle.getY()), Float.valueOf(angle.getZ()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (value instanceof EnumWrappers.Direction) {
            try {
                return ReflectionManager.getNmsMethod("EnumDirection", "fromType1", Integer.TYPE).invoke(null, ((EnumWrappers.Direction)value).ordinal());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (value instanceof BlockPosition) {
            BlockPosition pos = (BlockPosition)value;
            try {
                return ReflectionManager.getNmsConstructor("BlockPosition", Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(pos.getX(), pos.getY(), pos.getZ());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            if (value instanceof ItemStack) {
                return ReflectionManager.getNmsItem((ItemStack)value);
            }
            if (value instanceof Double) {
                return Float.valueOf(((Double)value).floatValue());
            }
            if (value instanceof NbtWrapper) {
                return ((NbtWrapper)value).getHandle();
            }
            if (value instanceof WrappedParticle) {
                return ((WrappedParticle)value).getHandle();
            }
        }
        return value;
    }

    public static String getMinecraftVersion() {
        String version = Bukkit.getVersion();
        version = version.substring(version.lastIndexOf(" ") + 1, version.length() - 1);
        return version;
    }

    public static WrappedDataWatcher.WrappedDataWatcherObject createDataWatcherObject(int id, Object value) {
        WrappedDataWatcher.Serializer serializer;
        if (value == null) {
            return null;
        }
        if ((value = ReflectionManager.convertInvalidMeta(value)) instanceof Optional) {
            Optional opt = (Optional)value;
            if (opt.isPresent()) {
                Object val = opt.get();
                Class<?> iBlockData = ReflectionManager.getNmsClass("IBlockData");
                Class iChat = ReflectionManager.getNmsClass("IChatBaseComponent");
                Class<Object> cl = iBlockData.isInstance(val) ? iBlockData : (iChat.isInstance(val) ? iChat : val.getClass());
                serializer = WrappedDataWatcher.Registry.get((Class)cl, (boolean)true);
            } else {
                serializer = WrappedDataWatcher.Registry.get(UUID.class, (boolean)true);
            }
        } else {
            serializer = WrappedDataWatcher.Registry.get(ReflectionManager.getNmsClass("ParticleParam").isInstance(value) ? ReflectionManager.getNmsClass("ParticleParam") : value.getClass());
        }
        if (serializer == null) {
            if (value.getClass().getSimpleName().equals("NBTTagCompound")) {
                return null;
            }
            throw new IllegalArgumentException("Unable to find Serializer for " + value + (value instanceof Optional && ((Optional)value).isPresent() ? " (" + ((Optional)value).get().getClass().getName() + ")" : (value instanceof Optional || value == null ? "" : " " + value.getClass().getName())) + "! Are you running the latest version of ProtocolLib?");
        }
        return new WrappedDataWatcher.WrappedDataWatcherObject(id, serializer);
    }

    public static Object createDataWatcherItem(int id, Object value) {
        WrappedDataWatcher.WrappedDataWatcherObject watcherObject = ReflectionManager.createDataWatcherObject(id, value);
        Constructor construct = ReflectionManager.getNmsConstructor("DataWatcher$Item", ReflectionManager.getNmsClass("DataWatcherObject"), Object.class);
        try {
            return construct.newInstance(watcherObject.getHandle(), ReflectionManager.convertInvalidMeta(value));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object createMinecraftKey(String name) {
        try {
            return ReflectionManager.getNmsClass("MinecraftKey").getConstructor(String.class).newInstance(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getEntityType(Object nmsEntity) {
        try {
            Object entityTypesField = null;
            for (Method method : ReflectionManager.getNmsClass("Entity").getMethods()) {
                if (!method.getReturnType().getSimpleName().equals("EntityTypes")) continue;
                Object entityType = method.invoke(nmsEntity, new Object[0]);
                Class typesClass = ReflectionManager.getNmsClass("IRegistry");
                Object registry = typesClass.getField("ENTITY_TYPE").get(null);
                return (Integer)registry.getClass().getMethod("a", Object.class).invoke(registry, entityType);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        throw new IllegalStateException("Failed to find EntityType for " + nmsEntity.getClass().getSimpleName());
    }

    public static WrappedWatchableObject createWatchable(int index, Object obj) {
        Object watcherItem = ReflectionManager.createDataWatcherItem(index, obj);
        if (watcherItem == null) {
            return null;
        }
        return new WrappedWatchableObject(watcherItem);
    }

    public static int getCombinedIdByItemStack(ItemStack itemStack) {
        try {
            Object nmsItem = ReflectionManager.getNmsItem(itemStack);
            Object item = ReflectionManager.getNmsMethod("ItemStack", "getItem", new Class[0]).invoke(nmsItem, new Object[0]);
            Class blockClass = ReflectionManager.getNmsClass("Block");
            Object nmsBlock = ReflectionManager.getNmsMethod(blockClass, "asBlock", ReflectionManager.getNmsClass("Item")).invoke(null, item);
            Object iBlockData = ReflectionManager.getNmsMethod(blockClass, "getBlockData", new Class[0]).invoke(nmsBlock, new Object[0]);
            return (Integer)ReflectionManager.getNmsMethod("Block", "getCombinedId", ReflectionManager.getNmsClass("IBlockData")).invoke(null, iBlockData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static ItemStack getItemStackByCombinedId(int id) {
        try {
            Method idMethod = ReflectionManager.getNmsMethod("Block", "getByCombinedId", Integer.TYPE);
            Object iBlockData = idMethod.invoke(null, id);
            Class iBlockClass = ReflectionManager.getNmsClass("IBlockData");
            Method getBlock = ReflectionManager.getNmsMethod(iBlockClass, "getBlock", new Class[0]);
            Object block = getBlock.invoke(iBlockData, new Object[0]);
            Method getItem = ReflectionManager.getNmsMethod("Block", "t", iBlockClass);
            return ReflectionManager.getBukkitItem(getItem.invoke(block, iBlockData));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object getWorldServer(World w) {
        try {
            return ReflectionManager.getCraftMethod("CraftWorld", "getHandle", new Class[0]).invoke((Object)w, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPlayerInteractManager(World w) {
        Object worldServer = ReflectionManager.getWorldServer(w);
        try {
            return ReflectionManager.getNmsConstructor("PlayerInteractManager", ReflectionManager.getNmsClass("World")).newInstance(worldServer);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            Object entity = ReflectionManager.createEntityInstance("Cow");
            for (Method method : ReflectionManager.getNmsClass("EntityLiving").getDeclaredMethods()) {
                if (method.getReturnType() != Float.TYPE || !Modifier.isProtected(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
                method.setAccessible(true);
                float value = ((Float)method.invoke(entity, new Object[0])).floatValue();
                if (((Float)method.invoke(entity, new Object[0])).floatValue() != 0.4f) continue;
                damageAndIdleSoundMethod = method;
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        craftItemClass = ReflectionManager.getCraftClass("inventory.CraftItemStack");
        pingField = ReflectionManager.getNmsField("EntityPlayer", "ping");
        trackerField = ReflectionManager.getNmsField("WorldServer", "tracker");
        entitiesField = ReflectionManager.getNmsField("EntityTracker", "trackedEntities");
        ihmGet = ReflectionManager.getNmsMethod("IntHashMap", "get", Integer.TYPE);
        boundingBoxConstructor = ReflectionManager.getNmsConstructor("AxisAlignedBB", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
        setBoundingBoxMethod = ReflectionManager.getNmsMethod("Entity", "a", ReflectionManager.getNmsClass("AxisAlignedBB"));
        entityCountField = ReflectionManager.getNmsField("Entity", "entityCount");
        entityCountField.setAccessible(true);
    }
}

