/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser.params.types.custom;

import me.libraryaddict.disguise.utilities.parser.params.types.ParamInfoEnum;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class ParamInfoItemStack
extends ParamInfoEnum {
    public ParamInfoItemStack(Class paramClass, String name, String valueType, String description, Enum[] possibleValues) {
        super(paramClass, name, valueType, description, possibleValues);
        this.setOtherValues("null", "glow");
    }

    @Override
    public boolean canTranslateValues() {
        return false;
    }

    @Override
    public boolean canReturnNull() {
        return true;
    }

    @Override
    public Object fromString(String string) {
        return ParamInfoItemStack.parseToItemstack(string);
    }

    protected static ItemStack parseToItemstack(String string) {
        return ParamInfoItemStack.parseToItemstack(string.split("[:,]"));
    }

    protected static ItemStack parseToItemstack(String[] split) {
        if (split[0].isEmpty() || split[0].equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("null"))) {
            return null;
        }
        Material material = Material.getMaterial((String)split[0]);
        if (material == null) {
            throw new IllegalArgumentException();
        }
        Integer amount = null;
        boolean enchanted = false;
        for (int i = 1; i < split.length; ++i) {
            String s = split[i];
            if (!enchanted && s.equalsIgnoreCase(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("glow"))) {
                enchanted = true;
                continue;
            }
            if (s.matches("\\d+") && amount == null) {
                amount = Integer.parseInt(s);
                continue;
            }
            throw new IllegalArgumentException();
        }
        ItemStack itemStack = new ItemStack(material, amount == null ? 1 : amount);
        if (enchanted) {
            itemStack.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        }
        return itemStack;
    }
}

