/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.parser.params;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.translations.TranslateType;

public abstract class ParamInfo {
    private Class paramClass;
    private String descriptiveName;
    private String name;
    private Map<String, Object> possibleValues;
    private String[] otherValues;
    private String description;

    public ParamInfo(Class paramClass, String name, String description) {
        this(paramClass, name, name, description);
    }

    public ParamInfo(Class paramClass, String name, String descriptiveName, String description) {
        this.name = name;
        this.paramClass = paramClass;
        this.descriptiveName = descriptiveName;
        this.description = description;
    }

    public ParamInfo(Class paramClass, String name, String description, Enum[] possibleValues) {
        this(paramClass, name, name, description, possibleValues);
    }

    public ParamInfo(Class paramClass, String name, String descriptiveName, String description, Enum[] possibleValues) {
        this(paramClass, name, descriptiveName, description);
        this.possibleValues = new HashMap<String, Object>();
        for (Enum anEnum : possibleValues) {
            this.getValues().put(anEnum.name(), anEnum);
        }
    }

    public ParamInfo(Class paramClass, String name, String description, Map<String, Object> possibleValues) {
        this(paramClass, name, name, description, possibleValues);
    }

    public ParamInfo(Class paramClass, String name, String descriptiveName, String description, Map<String, Object> possibleValues) {
        this(paramClass, name, descriptiveName, description);
        this.possibleValues = new HashMap<String, Object>();
        this.possibleValues.putAll(possibleValues);
    }

    public boolean canTranslateValues() {
        return this.getValues() != null;
    }

    public String[] getOtherValues() {
        return this.otherValues;
    }

    public void setOtherValues(String ... otherValues) {
        this.otherValues = otherValues;
    }

    public boolean canReturnNull() {
        return false;
    }

    protected abstract Object fromString(String var1) throws DisguiseParseException;

    public Object fromString(List<String> arguments) throws DisguiseParseException {
        String string = arguments.get(0);
        Object value = this.fromString(string);
        if (value == null && !this.canReturnNull()) {
            throw new IllegalArgumentException();
        }
        arguments.remove(0);
        return value;
    }

    public int getMinArguments() {
        return 1;
    }

    public boolean hasValues() {
        return this.getValues() != null;
    }

    private Class getParamClass() {
        return this.paramClass;
    }

    public boolean isParam(Class paramClass) {
        return this.getParamClass() == paramClass;
    }

    public String getName() {
        return TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(this.getRawName());
    }

    public String getDescriptiveName() {
        return TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(this.getRawDescriptiveName());
    }

    public String getRawName() {
        return this.name;
    }

    public String getRawDescriptiveName() {
        return this.descriptiveName;
    }

    public String getDescription() {
        return TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(this.getRawDescription());
    }

    public String getRawDescription() {
        return this.description;
    }

    public Map<String, Object> getValues() {
        return this.possibleValues;
    }

    public Set<String> getEnums(String tabComplete) {
        return this.getValues().keySet();
    }
}

